/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel.index;

import info.archinnov.achilles.annotations.SASI;
import info.archinnov.achilles.internals.metamodel.index.IndexImpl;
import info.archinnov.achilles.internals.metamodel.index.IndexType;
import info.archinnov.achilles.internals.parser.context.DSESearchInfoContext;
import info.archinnov.achilles.internals.parser.context.SASIInfoContext;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexInfo.class);
    public final IndexImpl impl;
    public final IndexType type;
    public final String name;
    public final Optional<String> indexClassName;
    public final Optional<String> indexOptions;
    public final Optional<SASIInfoContext> sasiInfoContext;
    public final Optional<DSESearchInfoContext> dseSearchInfoContext;

    private IndexInfo(IndexImpl indexImpl, IndexType type, String name, String indexClassName, String indexOptions, Optional<SASIInfoContext> sasiInfoContext, Optional<DSESearchInfoContext> dseSearchInfoContext) {
        this.impl = indexImpl;
        this.type = type;
        this.name = name;
        this.sasiInfoContext = sasiInfoContext;
        this.dseSearchInfoContext = dseSearchInfoContext;
        this.indexClassName = StringUtils.isNotBlank((CharSequence)indexClassName) ? Optional.of(indexClassName) : Optional.empty();
        this.indexOptions = StringUtils.isNotBlank((CharSequence)indexOptions) ? Optional.of(indexOptions) : Optional.empty();
    }

    public static IndexInfo forNative(IndexType indexType, String indexName, String indexClassName, String indexOptions) {
        return new IndexInfo(IndexImpl.NATIVE, indexType, indexName, indexClassName, indexOptions, Optional.empty(), Optional.empty());
    }

    public static IndexInfo forSASI(String indexName, SASI.IndexMode indexMode, boolean analyzed, SASI.Analyzer analyzer, int maxCompactionFlushMemoryInMb, SASI.Normalization normalization, String locale, boolean enableStemming, boolean skipStopWords) {
        String options = IndexInfo.buildOptionsForSASI(indexMode, analyzed, analyzer, maxCompactionFlushMemoryInMb, normalization, locale, enableStemming, skipStopWords);
        SASIInfoContext sasiInfoContext = new SASIInfoContext(indexName, indexMode, analyzed, analyzer, maxCompactionFlushMemoryInMb, normalization, locale, enableStemming, skipStopWords);
        return new IndexInfo(IndexImpl.SASI, IndexType.NORMAL, indexName, "org.apache.cassandra.index.sasi.SASIIndex", options, Optional.of(sasiInfoContext), Optional.empty());
    }

    public static IndexInfo forDSESearch(boolean fullTextSearchEnable) {
        return new IndexInfo(IndexImpl.DSE_SEARCH, IndexType.NORMAL, "", "com.datastax.bdp.search.solr.Cql3SolrSecondaryIndex", "", Optional.empty(), Optional.of(new DSESearchInfoContext(fullTextSearchEnable)));
    }

    private static String buildOptionsForSASI(SASI.IndexMode indexMode, boolean analyzed, SASI.Analyzer analyzer, int maxCompactionFlushMemoryInMb, SASI.Normalization normalization, String locale, boolean enableStemming, boolean skipStopWords) {
        StringJoiner joiner = new StringJoiner(",");
        joiner.add(String.format("'max_compaction_flush_memory_in_mb' : '%s'", maxCompactionFlushMemoryInMb));
        joiner.add(String.format("'mode' : '%s'", indexMode.name()));
        if (analyzed) {
            joiner.add(String.format("'analyzed' : '%s'", analyzed));
            joiner.add(String.format("'analyzer_class' : '%s'", analyzer.analyzerClass()));
            if (analyzer == SASI.Analyzer.STANDARD_ANALYZER) {
                joiner.add(String.format("'tokenization_locale': '%s'", locale.toLowerCase()));
                joiner.add(String.format("'tokenization_enable_stemming': '%s'", enableStemming));
                joiner.add(String.format("'tokenization_skip_stop_words': '%s'", skipStopWords));
                if (normalization != SASI.Normalization.NONE) {
                    joiner.add(String.format("'%s': 'true'", normalization.forStandardAnalyzer()));
                }
            } else if (analyzer == SASI.Analyzer.NON_TOKENIZING_ANALYZER) {
                if (normalization == SASI.Normalization.NONE) {
                    joiner.add(String.format("'case_sensitive': 'true'", new Object[0]));
                } else {
                    joiner.add(String.format("'%s': 'true'", normalization.forNonTokenizingAnalyzer()));
                }
            }
        }
        return joiner.toString();
    }

    public static IndexInfo noIndex() {
        return new IndexInfo(IndexImpl.NATIVE, IndexType.NONE, null, null, null, Optional.empty(), Optional.empty());
    }

    public String generate(Optional<String> keyspace, String table, String columnName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generating index creation script for column %s in table %s of keyspace %s", columnName, table, keyspace));
        }
        switch (this.impl) {
            case NATIVE: {
                return this.generateNativeIndex(keyspace, table, columnName);
            }
            case SASI: {
                return this.generateSASI(keyspace, table, columnName);
            }
        }
        return "";
    }

    private String generateSASI(Optional<String> keyspace, String table, String columnName) {
        String template = "\nCREATE CUSTOM INDEX IF NOT EXISTS %s ON %s ( %s )  USING '%s' WITH OPTIONS = {%s};";
        String tableWithKeyspace = table;
        if (keyspace.isPresent()) {
            tableWithKeyspace = keyspace.get() + "." + table;
        }
        return String.format(template, this.name, tableWithKeyspace, columnName, this.indexClassName.get(), this.indexOptions.get());
    }

    private String generateNativeIndex(Optional<String> keyspace, String table, String columnName) {
        String indexType;
        String template = "\nCREATE %s INDEX IF NOT EXISTS %s ON %s ( %s )%s%s;";
        String tableWithKeyspace = table;
        String indexClassString = "";
        String custom = "";
        StringBuilder indexOptionsString = new StringBuilder("");
        switch (this.type) {
            case FULL: {
                indexType = "FULL(" + columnName + ")";
                break;
            }
            case MAP_ENTRY: {
                indexType = "ENTRIES(" + columnName + ")";
                break;
            }
            case MAP_KEY: {
                indexType = "KEYS(" + columnName + ")";
                break;
            }
            default: {
                indexType = columnName;
            }
        }
        if (keyspace.isPresent()) {
            tableWithKeyspace = keyspace.get() + "." + table;
        }
        if (this.indexClassName.isPresent()) {
            custom = "CUSTOM";
            indexClassString = " USING '" + this.indexClassName.get() + "'";
            this.indexOptions.ifPresent(x -> {
                if (StringUtils.isNotBlank((CharSequence)x)) {
                    indexOptionsString.append(" WITH OPTIONS = '").append((String)x).append("'");
                }
            });
        }
        return String.format(template, custom, this.name, tableWithKeyspace, indexType, indexClassString, indexOptionsString.toString());
    }
}

