/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel.functions;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import info.archinnov.achilles.internals.context.ConfigurationContext;
import info.archinnov.achilles.internals.types.OverridingOptional;
import info.archinnov.achilles.validation.Validator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class FunctionProperty {
    public final Optional<String> keyspace;
    public final String name;
    public final String returnDataType;
    public final List<String> parameterDataTypes;

    public FunctionProperty(Optional<String> keyspace, String name, String returnDataType, List<String> parameterDataTypes) {
        this.keyspace = keyspace;
        this.name = name;
        this.returnDataType = returnDataType;
        this.parameterDataTypes = parameterDataTypes;
    }

    public void validate(ConfigurationContext configContext) {
        Metadata metadata = configContext.getSession().getCluster().getMetadata();
        Optional<Optional<String>> definedKeyspace = OverridingOptional.from(this.keyspace).andThen(configContext.getCurrentKeyspace()).getOptional();
        Validator.validateTrue((boolean)definedKeyspace.isPresent(), (String)"No keyspace value defined on function '%s' annotation nor at Achilles runtime", (Object[])new Object[]{this.toString()});
        KeyspaceMetadata keyspaceMetadata = metadata.getKeyspace((String)((Object)definedKeyspace.get()));
        long matchingUDF = keyspaceMetadata.getFunctions().stream().filter(x -> x.getSimpleName().equalsIgnoreCase(this.name)).filter(x -> x.getReturnType().asFunctionParameterString().equalsIgnoreCase(this.returnDataType)).filter(x -> x.getArguments().entrySet().stream().map(entry -> ((DataType)entry.getValue()).toString()).collect(Collectors.toList()).equals(this.parameterDataTypes)).count();
        long matchingUDA = keyspaceMetadata.getAggregates().stream().filter(x -> x.getSimpleName().equalsIgnoreCase(this.name)).filter(x -> x.getReturnType().asFunctionParameterString().equalsIgnoreCase(this.returnDataType)).filter(x -> x.getArgumentTypes().stream().map(Object::toString).collect(Collectors.toList()).equals(this.parameterDataTypes)).count();
        Validator.validateBeanMappingFalse((matchingUDF > 1L && matchingUDA > 1L ? 1 : 0) != 0, (String)"Error: found an UDF and UDA with the same name and signature in keyspace '%s'", (Object[])new Object[]{definedKeyspace.get()});
        Validator.validateBeanMappingTrue((matchingUDA + matchingUDF == 1L ? 1 : 0) != 0, (String)"The declared function '%s' cannot be found in the runtime Cassandra keyspace '%s'", (Object[])new Object[]{this.toString(), definedKeyspace.get()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FunctionProperty{");
        sb.append("keyspace=").append(this.keyspace);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", returnDataType='").append(this.returnDataType).append('\'');
        sb.append(", parameterDataTypes=").append(this.parameterDataTypes);
        sb.append('}');
        return sb.toString();
    }
}

