/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel.functions;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public interface FunctionCall {
    public static final List<Object> EMPTY = new ArrayList<Object>();

    default public String functionName() {
        return null;
    }

    default public List<Object> parameters() {
        return EMPTY;
    }

    default public Object buildRecursive() {
        List transformed = this.parameters().stream().map(x -> x instanceof FunctionCall ? ((FunctionCall)x).buildRecursive() : x).collect(Collectors.toList());
        if (this.functionName().equals("cast") && transformed.size() == 1) {
            return QueryBuilder.cast((Object)QueryBuilder.raw((String)transformed.get(0).toString()), (DataType)this.targetCQLTypeName());
        }
        return QueryBuilder.fcall((String)this.functionName(), (Object[])transformed.toArray());
    }

    public boolean isFunctionCall();

    default public DataType targetCQLTypeName() {
        throw new IllegalStateException("Unexpected call. This method should only be called by system 'cast' functions");
    }

    default public void addToSelect(Select.Selection selection, String alias) {
        List<Object> parameters = this.parameters();
        if (this.functionName().equals("cast") && parameters.size() == 1) {
            selection.cast(QueryBuilder.raw((String)parameters.get(0).toString()), this.targetCQLTypeName()).as(alias);
        } else {
            selection.fcall(this.functionName(), parameters.toArray()).as(alias);
        }
    }
}

