/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel.columns;

import info.archinnov.achilles.internals.metamodel.columns.ColumnInfo;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.metamodel.index.IndexInfo;
import info.archinnov.achilles.internals.metamodel.index.IndexType;
import info.archinnov.achilles.internals.parser.accessors.Getter;
import info.archinnov.achilles.internals.parser.accessors.Setter;
import info.archinnov.achilles.internals.utils.NamingHelper;

public class FieldInfo<ENTITY, VALUEFROM> {
    public final String fieldName;
    public final String cqlColumn;
    public final String quotedCqlColumn;
    public final ColumnType columnType;
    public final ColumnInfo columnInfo;
    public final IndexInfo indexInfo;
    public final Getter<ENTITY, VALUEFROM> getter;
    public final Setter<ENTITY, VALUEFROM> setter;

    public FieldInfo(Getter<ENTITY, VALUEFROM> getter, Setter<ENTITY, VALUEFROM> setter, String fieldName, String cqlColumn, ColumnType columnType, ColumnInfo columnInfo, IndexInfo indexInfo) {
        this.fieldName = fieldName;
        this.cqlColumn = cqlColumn;
        this.quotedCqlColumn = NamingHelper.maybeQuote(cqlColumn);
        this.getter = getter;
        this.setter = setter;
        this.columnType = columnType;
        this.columnInfo = columnInfo;
        this.indexInfo = indexInfo;
    }

    private FieldInfo(String cqlColumn, String fieldName) {
        this.cqlColumn = cqlColumn;
        this.quotedCqlColumn = NamingHelper.maybeQuote(cqlColumn);
        this.fieldName = fieldName;
        this.getter = null;
        this.setter = null;
        this.columnType = null;
        this.columnInfo = null;
        this.indexInfo = null;
    }

    private FieldInfo(String cqlColumn, String fieldName, boolean frozen) {
        this.cqlColumn = cqlColumn;
        this.quotedCqlColumn = NamingHelper.maybeQuote(cqlColumn);
        this.fieldName = fieldName;
        this.getter = null;
        this.setter = null;
        this.columnType = null;
        this.columnInfo = new ColumnInfo(frozen);
        this.indexInfo = null;
    }

    public static <A, B> FieldInfo of(String cqlColumn, String fieldName) {
        return new FieldInfo(cqlColumn, fieldName);
    }

    public static <A, B> FieldInfo of(String cqlColumn, String fieldName, boolean frozen) {
        return new FieldInfo(cqlColumn, fieldName, frozen);
    }

    public boolean hasIndex() {
        return this.indexInfo.type != IndexType.NONE;
    }
}

