/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel.columns;

import com.datastax.driver.core.ClusteringOrder;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import info.archinnov.achilles.internals.metamodel.columns.ColumnInfo;
import info.archinnov.achilles.internals.metamodel.columns.KeyColumnInfo;

public class ClusteringColumnInfo
extends ColumnInfo
implements KeyColumnInfo {
    public final Integer order;
    public final ClusteringOrder clusteringOrder;
    public final SchemaBuilder.Direction direction;

    public ClusteringColumnInfo(int order, boolean frozen, ClusteringOrder clusteringOrder) {
        super(frozen);
        this.order = order;
        this.clusteringOrder = clusteringOrder;
        this.direction = ClusteringColumnInfo.mapClusteringOrder(clusteringOrder);
    }

    private static SchemaBuilder.Direction mapClusteringOrder(ClusteringOrder clusteringOrder) {
        switch (clusteringOrder) {
            case ASC: {
                return SchemaBuilder.Direction.ASC;
            }
            case DESC: {
                return SchemaBuilder.Direction.DESC;
            }
        }
        throw new IllegalArgumentException("Unknown clustering order : " + clusteringOrder.name());
    }

    @Override
    public Integer order() {
        return this.order;
    }
}

