/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.factory.TupleTypeFactory;
import info.archinnov.achilles.internals.factory.UserTypeFactory;
import info.archinnov.achilles.internals.injectable.InjectBeanFactory;
import info.archinnov.achilles.internals.injectable.InjectKeyspace;
import info.archinnov.achilles.internals.injectable.InjectUserAndTupleTypeFactory;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractUDTClassProperty;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.utils.CollectionsHelper;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.type.codec.Codec;
import info.archinnov.achilles.type.codec.CodecSignature;
import info.archinnov.achilles.type.factory.BeanFactory;
import info.archinnov.achilles.validation.Validator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDTProperty<ENTITY, UDT_META extends AbstractUDTClassProperty<A>, A>
extends AbstractProperty<ENTITY, A, UDTValue>
implements InjectUserAndTupleTypeFactory,
InjectBeanFactory,
InjectKeyspace {
    public static final TypeToken<UDTValue> UDT_VALUE_TYPE_TOKEN = new TypeToken<UDTValue>(){};
    private static final Logger LOGGER = LoggerFactory.getLogger(UDTProperty.class);
    public final Class<A> valueClass;
    public final UDT_META udtClassProperty;

    public UDTProperty(FieldInfo<ENTITY, A> fieldInfo, Class<A> valueClass, UDT_META udtClassProperty) {
        super(TypeToken.of(valueClass), UDT_VALUE_TYPE_TOKEN, fieldInfo);
        this.valueClass = valueClass;
        this.udtClassProperty = udtClassProperty;
    }

    @Override
    boolean isOptional() {
        return false;
    }

    @Override
    public void encodeToSettable(UDTValue udt, SettableData<?> settableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode '%s' UDT value %s to settable object %s", this.fieldName, udt, settableData));
        }
        settableData.setUDTValue(this.fieldInfo.quotedCqlColumn, udt);
    }

    @Override
    UDTValue encodeFromJavaInternal(A javaValue, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode from Java '%s' %s to CQL UDT type", this.fieldName, javaValue));
        }
        return ((AbstractUDTClassProperty)this.udtClassProperty).createUDTFromBean(javaValue, this.fieldInfo.columnInfo.frozen, cassandraOptions);
    }

    @Override
    UDTValue encodeFromRawInternal(Object o, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode raw '%s' object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)this.valueClass.isAssignableFrom(o.getClass()), (String)"The class of object %s to encode should be %s", (Object[])new Object[]{o, this.valueClass.getCanonicalName()});
        return (UDTValue)this.encodeFromJava(o, cassandraOptions);
    }

    @Override
    A decodeFromGettableInternal(GettableData gettableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' from gettable object %s", this.fieldName, gettableData));
        }
        return (A)this.decodeFromRaw(gettableData.getUDTValue(this.fieldInfo.quotedCqlColumn));
    }

    @Override
    A decodeFromRawInternal(Object o) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' raw object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)UDTValue.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to decode should be %s", (Object[])new Object[]{o, UDTValue.class.getCanonicalName()});
        return ((AbstractUDTClassProperty)this.udtClassProperty).createBeanFromUDT((UDTValue)o);
    }

    public UserType buildType(Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Build current '%s' UDT data type", this.fieldName));
        }
        return ((AbstractUDTClassProperty)this.udtClassProperty).buildType(this.fieldInfo.columnInfo.frozen, cassandraOptions);
    }

    @Override
    public void encodeFieldToUdt(ENTITY entity, UDTValue udtValue, Optional<CassandraOptions> cassandraOptions) {
        UDTValue valueTo = (UDTValue)this.encodeField(entity, cassandraOptions);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode '%s' %s to UDT value %s", this.fieldName, valueTo, udtValue));
        }
        udtValue.setUDTValue(this.fieldInfo.quotedCqlColumn, valueTo);
    }

    @Override
    public boolean containsUDTProperty() {
        return true;
    }

    @Override
    public List<AbstractUDTClassProperty<?>> getUDTClassProperties() {
        return CollectionsHelper.appendAll(((AbstractUDTClassProperty)this.udtClassProperty).componentsProperty.stream().flatMap(x -> x.getUDTClassProperties().stream()).collect(Collectors.toList()), Arrays.asList(this.udtClassProperty));
    }

    @Override
    public void inject(UserTypeFactory userTypeFactory, TupleTypeFactory tupleTypeFactory) {
        ((AbstractUDTClassProperty)this.udtClassProperty).inject(userTypeFactory, tupleTypeFactory);
    }

    @Override
    public void inject(BeanFactory factory) {
        ((AbstractUDTClassProperty)this.udtClassProperty).inject(factory);
    }

    @Override
    public void injectKeyspace(String keyspace) {
        ((AbstractUDTClassProperty)this.udtClassProperty).injectKeyspace(keyspace);
    }

    @Override
    public void inject(ObjectMapper mapper) {
        ((AbstractUDTClassProperty)this.udtClassProperty).inject(mapper);
    }

    @Override
    public void injectRuntimeCodecs(Map<CodecSignature<?, ?>, Codec<?, ?>> runtimeCodecs) {
        ((AbstractUDTClassProperty)this.udtClassProperty).injectRuntimeCodecs(runtimeCodecs);
    }

    @Override
    public void inject(SchemaNameProvider schemaNameProvider) {
        super.inject(schemaNameProvider);
        ((AbstractUDTClassProperty)this.udtClassProperty).inject(schemaNameProvider);
    }
}

