/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.cql.TupleExtractor;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractTupleProperty;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.type.tuples.Tuple7;
import info.archinnov.achilles.validation.Validator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tuple7Property<ENTITY, A, B, C, D, E, F, G>
extends AbstractTupleProperty<ENTITY, Tuple7<A, B, C, D, E, F, G>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tuple7.class);
    private final AbstractProperty<ENTITY, A, ?> aProperty;
    private final AbstractProperty<ENTITY, B, ?> bProperty;
    private final AbstractProperty<ENTITY, C, ?> cProperty;
    private final AbstractProperty<ENTITY, D, ?> dProperty;
    private final AbstractProperty<ENTITY, E, ?> eProperty;
    private final AbstractProperty<ENTITY, F, ?> fProperty;
    private final AbstractProperty<ENTITY, G, ?> gProperty;

    public Tuple7Property(FieldInfo<ENTITY, Tuple7<A, B, C, D, E, F, G>> fieldInfo, AbstractProperty<ENTITY, A, ?> aProperty, AbstractProperty<ENTITY, B, ?> bProperty, AbstractProperty<ENTITY, C, ?> cProperty, AbstractProperty<ENTITY, D, ?> dProperty, AbstractProperty<ENTITY, E, ?> eProperty, AbstractProperty<ENTITY, F, ?> fProperty, AbstractProperty<ENTITY, G, ?> gProperty) {
        super(new TypeToken<Tuple7<A, B, C, D, E, F, G>>(){}, fieldInfo);
        this.aProperty = aProperty;
        this.bProperty = bProperty;
        this.cProperty = cProperty;
        this.dProperty = dProperty;
        this.eProperty = eProperty;
        this.fProperty = fProperty;
        this.gProperty = gProperty;
    }

    @Override
    TupleValue encodeFromJavaInternal(Tuple7<A, B, C, D, E, F, G> tuple7, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode from Java '%s' tuple7 %s to CQL type", this.fieldName, tuple7));
        }
        return this.getRuntimeTupleType(cassandraOptions).newValue(new Object[]{this.aProperty.encodeFromRaw(tuple7._1(), cassandraOptions), this.bProperty.encodeFromRaw(tuple7._2(), cassandraOptions), this.cProperty.encodeFromRaw(tuple7._3(), cassandraOptions), this.dProperty.encodeFromRaw(tuple7._4(), cassandraOptions), this.eProperty.encodeFromRaw(tuple7._5(), cassandraOptions), this.fProperty.encodeFromRaw(tuple7._6(), cassandraOptions), this.gProperty.encodeFromRaw(tuple7._7(), cassandraOptions)});
    }

    @Override
    TupleValue encodeFromRawInternal(Object o, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode raw '%s' tuple7 object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)Tuple7.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to encode should be Tuple7", (Object[])new Object[]{o});
        return (TupleValue)this.encodeFromJava((Tuple7)o, cassandraOptions);
    }

    @Override
    Tuple7<A, B, C, D, E, F, G> decodeFromGettableInternal(GettableData gettableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' tuple7 from gettable object %s", this.fieldName, gettableData));
        }
        return (Tuple7)this.decodeFromRaw(gettableData.getTupleValue(this.fieldInfo.quotedCqlColumn));
    }

    @Override
    Tuple7<A, B, C, D, E, F, G> decodeFromRawInternal(Object o) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' tuple7 raw object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)TupleValue.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to decode should be %s", (Object[])new Object[]{o, TupleValue.class.getCanonicalName()});
        List types = this.tupleType.getComponentTypes();
        return new Tuple7(this.aProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(0), this.aProperty, 0)), this.bProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(1), this.bProperty, 1)), this.cProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(2), this.cProperty, 2)), this.dProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(3), this.dProperty, 3)), this.eProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(4), this.eProperty, 4)), this.fProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(5), this.fProperty, 5)), this.gProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(6), this.gProperty, 6)));
    }

    @Override
    public TupleType buildType(Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Build current '%s' tuple7 data type", this.fieldName));
        }
        return this.tupleTypeFactory.typeFor(this.aProperty.buildType(cassandraOptions), this.bProperty.buildType(cassandraOptions), this.cProperty.buildType(cassandraOptions), this.dProperty.buildType(cassandraOptions), this.eProperty.buildType(cassandraOptions), this.fProperty.buildType(cassandraOptions), this.gProperty.buildType(cassandraOptions));
    }

    @Override
    protected List<AbstractProperty<ENTITY, ?, ?>> componentsProperty() {
        return Arrays.asList(this.aProperty, this.bProperty, this.cProperty, this.dProperty, this.eProperty, this.fProperty, this.gProperty);
    }
}

