/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.cql.TupleExtractor;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractTupleProperty;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.type.tuples.Tuple6;
import info.archinnov.achilles.validation.Validator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tuple6Property<ENTITY, A, B, C, D, E, F>
extends AbstractTupleProperty<ENTITY, Tuple6<A, B, C, D, E, F>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tuple6.class);
    private final AbstractProperty<ENTITY, A, ?> aProperty;
    private final AbstractProperty<ENTITY, B, ?> bProperty;
    private final AbstractProperty<ENTITY, C, ?> cProperty;
    private final AbstractProperty<ENTITY, D, ?> dProperty;
    private final AbstractProperty<ENTITY, E, ?> eProperty;
    private final AbstractProperty<ENTITY, F, ?> fProperty;

    public Tuple6Property(FieldInfo<ENTITY, Tuple6<A, B, C, D, E, F>> fieldInfo, AbstractProperty<ENTITY, A, ?> aProperty, AbstractProperty<ENTITY, B, ?> bProperty, AbstractProperty<ENTITY, C, ?> cProperty, AbstractProperty<ENTITY, D, ?> dProperty, AbstractProperty<ENTITY, E, ?> eProperty, AbstractProperty<ENTITY, F, ?> fProperty) {
        super(new TypeToken<Tuple6<A, B, C, D, E, F>>(){}, fieldInfo);
        this.aProperty = aProperty;
        this.bProperty = bProperty;
        this.cProperty = cProperty;
        this.dProperty = dProperty;
        this.eProperty = eProperty;
        this.fProperty = fProperty;
    }

    @Override
    TupleValue encodeFromJavaInternal(Tuple6<A, B, C, D, E, F> tuple6, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode from Java '%s' tuple6 %s to CQL type", this.fieldName, tuple6));
        }
        return this.getRuntimeTupleType(cassandraOptions).newValue(new Object[]{this.aProperty.encodeFromRaw(tuple6._1(), cassandraOptions), this.bProperty.encodeFromRaw(tuple6._2(), cassandraOptions), this.cProperty.encodeFromRaw(tuple6._3(), cassandraOptions), this.dProperty.encodeFromRaw(tuple6._4(), cassandraOptions), this.eProperty.encodeFromRaw(tuple6._5(), cassandraOptions), this.fProperty.encodeFromRaw(tuple6._6(), cassandraOptions)});
    }

    @Override
    TupleValue encodeFromRawInternal(Object o, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode raw '%s' tuple6 object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)Tuple6.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to encode should be Tuple6", (Object[])new Object[]{o});
        return (TupleValue)this.encodeFromJava((Tuple6)o, cassandraOptions);
    }

    @Override
    Tuple6<A, B, C, D, E, F> decodeFromGettableInternal(GettableData gettableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' tuple6 from gettable object %s", this.fieldName, gettableData));
        }
        return (Tuple6)this.decodeFromRaw(gettableData.getTupleValue(this.fieldInfo.quotedCqlColumn));
    }

    @Override
    Tuple6<A, B, C, D, E, F> decodeFromRawInternal(Object o) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' tuple6 raw object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)TupleValue.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to decode should be %s", (Object[])new Object[]{o, TupleValue.class.getCanonicalName()});
        List types = this.tupleType.getComponentTypes();
        return new Tuple6(this.aProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(0), this.aProperty, 0)), this.bProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(1), this.bProperty, 1)), this.cProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(2), this.cProperty, 2)), this.dProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(3), this.dProperty, 3)), this.eProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(4), this.eProperty, 4)), this.fProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(5), this.fProperty, 5)));
    }

    @Override
    public TupleType buildType(Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Build current '%s' tuple6 data type", this.fieldName));
        }
        return this.tupleTypeFactory.typeFor(this.aProperty.buildType(cassandraOptions), this.bProperty.buildType(cassandraOptions), this.cProperty.buildType(cassandraOptions), this.dProperty.buildType(cassandraOptions), this.eProperty.buildType(cassandraOptions), this.fProperty.buildType(cassandraOptions));
    }

    @Override
    protected List<AbstractProperty<ENTITY, ?, ?>> componentsProperty() {
        return Arrays.asList(this.aProperty, this.bProperty, this.cProperty, this.dProperty, this.eProperty, this.fProperty);
    }
}

