/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.cql.TupleExtractor;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractTupleProperty;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.type.tuples.Tuple3;
import info.archinnov.achilles.validation.Validator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tuple3Property<ENTITY, A, B, C>
extends AbstractTupleProperty<ENTITY, Tuple3<A, B, C>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tuple3.class);
    private final AbstractProperty<ENTITY, A, ?> aProperty;
    private final AbstractProperty<ENTITY, B, ?> bProperty;
    private final AbstractProperty<ENTITY, C, ?> cProperty;

    public Tuple3Property(FieldInfo<ENTITY, Tuple3<A, B, C>> fieldInfo, AbstractProperty<ENTITY, A, ?> aProperty, AbstractProperty<ENTITY, B, ?> bProperty, AbstractProperty<ENTITY, C, ?> cProperty) {
        super(new TypeToken<Tuple3<A, B, C>>(){}, fieldInfo);
        this.aProperty = aProperty;
        this.bProperty = bProperty;
        this.cProperty = cProperty;
    }

    @Override
    TupleValue encodeFromJavaInternal(Tuple3<A, B, C> tuple3, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode from Java '%s' tuple3 %s to CQL type", this.fieldName, tuple3));
        }
        return this.getRuntimeTupleType(cassandraOptions).newValue(new Object[]{this.aProperty.encodeFromRaw(tuple3._1(), cassandraOptions), this.bProperty.encodeFromRaw(tuple3._2(), cassandraOptions), this.cProperty.encodeFromRaw(tuple3._3(), cassandraOptions)});
    }

    @Override
    TupleValue encodeFromRawInternal(Object o, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode raw '%s' tuple3 object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)Tuple3.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to encode should be Tuple3", (Object[])new Object[]{o});
        return (TupleValue)this.encodeFromJava((Tuple3)o, cassandraOptions);
    }

    @Override
    Tuple3<A, B, C> decodeFromGettableInternal(GettableData gettableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' tuple3 from gettable object %s", this.fieldName, gettableData));
        }
        return (Tuple3)this.decodeFromRaw(gettableData.getTupleValue(this.fieldInfo.quotedCqlColumn));
    }

    @Override
    Tuple3<A, B, C> decodeFromRawInternal(Object o) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' tuple3 raw object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)TupleValue.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to decode should be %s", (Object[])new Object[]{o, TupleValue.class.getCanonicalName()});
        List types = this.tupleType.getComponentTypes();
        return new Tuple3(this.aProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(0), this.aProperty, 0)), this.bProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(1), this.bProperty, 1)), this.cProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(2), this.cProperty, 2)));
    }

    @Override
    public TupleType buildType(Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Build current '%s' tuple3 data type", this.fieldName));
        }
        return this.tupleTypeFactory.typeFor(this.aProperty.buildType(cassandraOptions), this.bProperty.buildType(cassandraOptions), this.cProperty.buildType(cassandraOptions));
    }

    @Override
    protected List<AbstractProperty<ENTITY, ?, ?>> componentsProperty() {
        return Arrays.asList(this.aProperty, this.bProperty, this.cProperty);
    }
}

