/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.cql.TupleExtractor;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractTupleProperty;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.type.tuples.Tuple10;
import info.archinnov.achilles.validation.Validator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tuple10Property<ENTITY, A, B, C, D, E, F, G, H, I, J>
extends AbstractTupleProperty<ENTITY, Tuple10<A, B, C, D, E, F, G, H, I, J>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tuple10.class);
    private final AbstractProperty<ENTITY, A, ?> aProperty;
    private final AbstractProperty<ENTITY, B, ?> bProperty;
    private final AbstractProperty<ENTITY, C, ?> cProperty;
    private final AbstractProperty<ENTITY, D, ?> dProperty;
    private final AbstractProperty<ENTITY, E, ?> eProperty;
    private final AbstractProperty<ENTITY, F, ?> fProperty;
    private final AbstractProperty<ENTITY, G, ?> gProperty;
    private final AbstractProperty<ENTITY, H, ?> hProperty;
    private final AbstractProperty<ENTITY, I, ?> iProperty;
    private final AbstractProperty<ENTITY, J, ?> jProperty;

    public Tuple10Property(FieldInfo<ENTITY, Tuple10<A, B, C, D, E, F, G, H, I, J>> fieldInfo, AbstractProperty<ENTITY, A, ?> aProperty, AbstractProperty<ENTITY, B, ?> bProperty, AbstractProperty<ENTITY, C, ?> cProperty, AbstractProperty<ENTITY, D, ?> dProperty, AbstractProperty<ENTITY, E, ?> eProperty, AbstractProperty<ENTITY, F, ?> fProperty, AbstractProperty<ENTITY, G, ?> gProperty, AbstractProperty<ENTITY, H, ?> hProperty, AbstractProperty<ENTITY, I, ?> iProperty, AbstractProperty<ENTITY, J, ?> jProperty) {
        super(new TypeToken<Tuple10<A, B, C, D, E, F, G, H, I, J>>(){}, fieldInfo);
        this.aProperty = aProperty;
        this.bProperty = bProperty;
        this.cProperty = cProperty;
        this.dProperty = dProperty;
        this.eProperty = eProperty;
        this.fProperty = fProperty;
        this.gProperty = gProperty;
        this.hProperty = hProperty;
        this.iProperty = iProperty;
        this.jProperty = jProperty;
    }

    @Override
    TupleValue encodeFromJavaInternal(Tuple10<A, B, C, D, E, F, G, H, I, J> tuple10, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode from Java '%s' tuple10 %s to CQL type", this.fieldName, tuple10));
        }
        return this.getRuntimeTupleType(cassandraOptions).newValue(new Object[]{this.aProperty.encodeFromRaw(tuple10._1(), cassandraOptions), this.bProperty.encodeFromRaw(tuple10._2(), cassandraOptions), this.cProperty.encodeFromRaw(tuple10._3(), cassandraOptions), this.dProperty.encodeFromRaw(tuple10._4(), cassandraOptions), this.eProperty.encodeFromRaw(tuple10._5(), cassandraOptions), this.fProperty.encodeFromRaw(tuple10._6(), cassandraOptions), this.gProperty.encodeFromRaw(tuple10._7(), cassandraOptions), this.hProperty.encodeFromRaw(tuple10._8(), cassandraOptions), this.iProperty.encodeFromRaw(tuple10._9(), cassandraOptions), this.jProperty.encodeFromRaw(tuple10._10(), cassandraOptions)});
    }

    @Override
    TupleValue encodeFromRawInternal(Object o, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode raw '%s' tuple10 object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)Tuple10.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to encode should be Tuple10", (Object[])new Object[]{o});
        return (TupleValue)this.encodeFromJava((Tuple10)o, cassandraOptions);
    }

    @Override
    Tuple10<A, B, C, D, E, F, G, H, I, J> decodeFromGettableInternal(GettableData gettableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' tuple10 from gettable object %s", this.fieldName, gettableData));
        }
        return (Tuple10)this.decodeFromRaw(gettableData.getTupleValue(this.fieldInfo.quotedCqlColumn));
    }

    @Override
    Tuple10<A, B, C, D, E, F, G, H, I, J> decodeFromRawInternal(Object o) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' tuple10 raw object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)TupleValue.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to decode should be %s", (Object[])new Object[]{o, TupleValue.class.getCanonicalName()});
        List types = this.tupleType.getComponentTypes();
        return new Tuple10(this.aProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(0), this.aProperty, 0)), this.bProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(1), this.bProperty, 1)), this.cProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(2), this.cProperty, 2)), this.dProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(3), this.dProperty, 3)), this.eProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(4), this.eProperty, 4)), this.fProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(5), this.fProperty, 5)), this.gProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(6), this.gProperty, 6)), this.hProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(7), this.hProperty, 7)), this.iProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(8), this.iProperty, 7)), this.jProperty.decodeFromRaw(TupleExtractor.extractType((TupleValue)o, (DataType)types.get(9), this.jProperty, 9)));
    }

    @Override
    public TupleType buildType(Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Build current '%s' tuple10 data type", this.fieldName));
        }
        return this.tupleTypeFactory.typeFor(this.aProperty.buildType(cassandraOptions), this.bProperty.buildType(cassandraOptions), this.cProperty.buildType(cassandraOptions), this.dProperty.buildType(cassandraOptions), this.eProperty.buildType(cassandraOptions), this.fProperty.buildType(cassandraOptions), this.gProperty.buildType(cassandraOptions), this.hProperty.buildType(cassandraOptions), this.iProperty.buildType(cassandraOptions), this.jProperty.buildType(cassandraOptions));
    }

    @Override
    protected List<AbstractProperty<ENTITY, ?, ?>> componentsProperty() {
        return Arrays.asList(this.aProperty, this.bProperty, this.cProperty, this.dProperty, this.eProperty, this.fProperty, this.gProperty, this.hProperty, this.iProperty, this.jProperty);
    }
}

