/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.UDTValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.codec.JSONCodec;
import info.archinnov.achilles.internals.factory.TupleTypeFactory;
import info.archinnov.achilles.internals.factory.UserTypeFactory;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractUDTClassProperty;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.types.RuntimeCodecWrapper;
import info.archinnov.achilles.type.codec.Codec;
import info.archinnov.achilles.type.codec.CodecSignature;
import info.archinnov.achilles.type.factory.BeanFactory;
import info.archinnov.achilles.validation.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleProperty<ENTITY, VALUEFROM, VALUETO>
extends AbstractProperty<ENTITY, VALUEFROM, VALUETO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleProperty.class);
    public final Codec<VALUEFROM, VALUETO> valueCodec;
    public final Function<GettableData, VALUETO> gettable;
    public final BiConsumer<SettableData, VALUETO> settable;
    public final DataType dataTypeInternal;

    public SimpleProperty(FieldInfo<ENTITY, VALUEFROM> fieldInfo, DataType dataType, Function<GettableData, VALUETO> gettable, BiConsumer<SettableData, VALUETO> settable, TypeToken<VALUEFROM> valueFromTypeToken, TypeToken<VALUETO> valueToTypeToken, Codec<VALUEFROM, VALUETO> valueCodec) {
        super(valueFromTypeToken, valueToTypeToken, fieldInfo);
        this.dataTypeInternal = dataType;
        this.gettable = gettable;
        this.settable = settable;
        this.valueCodec = valueCodec;
    }

    @Override
    boolean isOptional() {
        return false;
    }

    @Override
    public void encodeToSettable(VALUETO valueTo, SettableData<?> settableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode '%s' value %s to settable object %s", this.fieldName, valueTo, settableData));
        }
        this.settable.accept(settableData, valueTo);
    }

    @Override
    public VALUETO encodeFromJavaInternal(VALUEFROM javaValue, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode from Java '%s'  %s to CQL type", this.fieldName, javaValue));
        }
        return (VALUETO)this.valueCodec.encode(javaValue);
    }

    @Override
    public VALUETO encodeFromRawInternal(Object o, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode raw '%s' object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)this.valueFromTypeToken.getRawType().isAssignableFrom(o.getClass()), (String)"The class of object %s to encode should be %s", (Object[])new Object[]{o, this.valueFromTypeToken});
        return this.encodeFromJava(o, cassandraOptions);
    }

    @Override
    public VALUEFROM decodeFromGettableInternal(GettableData gettableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' from gettable object %s", this.fieldName, gettableData));
        }
        return (VALUEFROM)this.valueCodec.decode(this.gettable.apply(gettableData));
    }

    @Override
    public VALUEFROM decodeFromRawInternal(Object o) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' raw object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)this.valueToTypeToken.getRawType().isAssignableFrom(o.getClass()), (String)"The class of object %s to decode should be %s", (Object[])new Object[]{o, this.valueToTypeToken});
        return (VALUEFROM)this.valueCodec.decode(o);
    }

    @Override
    public DataType buildType(Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Build current '%s' data type", this.fieldName));
        }
        return this.dataTypeInternal;
    }

    @Override
    public void encodeFieldToUdt(ENTITY entity, UDTValue udtValue, Optional<CassandraOptions> cassandraOptions) {
        Object valueTo = this.encodeField(entity, cassandraOptions);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode '%s' %s to UDT value %s", this.fieldName, valueTo, udtValue));
        }
        this.settable.accept((SettableData)udtValue, valueTo);
    }

    @Override
    public boolean containsUDTProperty() {
        return false;
    }

    @Override
    public List<AbstractUDTClassProperty<?>> getUDTClassProperties() {
        return new ArrayList();
    }

    @Override
    public void inject(UserTypeFactory userTypeFactory, TupleTypeFactory tupleTypeFactory) {
    }

    @Override
    public void inject(ObjectMapper mapper) {
        if (this.valueCodec instanceof JSONCodec) {
            ((JSONCodec)this.valueCodec).setObjectMapper(mapper);
        }
    }

    @Override
    public void inject(BeanFactory factory) {
    }

    @Override
    public void injectRuntimeCodecs(Map<CodecSignature<?, ?>, Codec<?, ?>> runtimeCodecs) {
        if (this.valueCodec instanceof RuntimeCodecWrapper) {
            ((RuntimeCodecWrapper)this.valueCodec).inject(runtimeCodecs);
        }
    }

    @Override
    public void injectKeyspace(String keyspace) {
    }
}

