/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.UDTValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.factory.TupleTypeFactory;
import info.archinnov.achilles.internals.factory.UserTypeFactory;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractUDTClassProperty;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.utils.NamingHelper;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.type.codec.Codec;
import info.archinnov.achilles.type.codec.CodecSignature;
import info.archinnov.achilles.type.factory.BeanFactory;
import info.archinnov.achilles.validation.Validator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetProperty<ENTITY, VALUEFROM, VALUETO>
extends AbstractProperty<ENTITY, Set<VALUEFROM>, Set<VALUETO>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetProperty.class);
    public final Class<?> valueToClass;
    public final AbstractProperty<ENTITY, VALUEFROM, VALUETO> valueProperty;
    public final boolean frozen;
    public final boolean emptyCollectionIfNull;

    public SetProperty(FieldInfo<ENTITY, Set<VALUEFROM>> fieldInfo, boolean frozen, boolean emptyCollectionIfNull, Class<?> valueToClass, AbstractProperty<ENTITY, VALUEFROM, VALUETO> valueProperty) {
        super(new TypeToken<Set<VALUEFROM>>(){}.where(new TypeParameter<VALUEFROM>(){}, valueProperty.valueFromTypeToken), new TypeToken<Set<VALUETO>>(){}.where(new TypeParameter<VALUETO>(){}, valueProperty.valueToTypeToken), fieldInfo);
        this.frozen = frozen;
        this.emptyCollectionIfNull = emptyCollectionIfNull;
        this.valueToClass = valueToClass;
        this.valueProperty = valueProperty;
    }

    @Override
    boolean isOptional() {
        return false;
    }

    public VALUETO encodeSingleElement(VALUEFROM javaValue) {
        return this.encodeSingleElement(javaValue, Optional.empty());
    }

    public VALUETO encodeSingleElement(VALUEFROM javaValue, Optional<CassandraOptions> cassandraOptions) {
        return this.valueProperty.encodeFromRaw(javaValue, cassandraOptions);
    }

    @Override
    public void encodeToSettable(Set<VALUETO> valueTos, SettableData<?> settableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode '%s' set value %s to settable object %s", this.fieldName, valueTos, settableData));
        }
        settableData.setSet(this.fieldInfo.quotedCqlColumn, valueTos, this.valueProperty.valueToTypeToken);
    }

    @Override
    public Set<VALUETO> encodeFromJavaInternal(Set<VALUEFROM> set, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode from Java '%s' set %s to CQL type", this.fieldName, set));
        }
        return new HashSet(set.stream().map(value -> this.valueProperty.encodeFromRaw(value, cassandraOptions)).collect(Collectors.toSet()));
    }

    @Override
    public Set<VALUETO> encodeFromRawInternal(Object o, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode raw '%s' set object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)Set.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to encode should be Set", (Object[])new Object[]{o});
        return (Set)this.encodeFromJava((Set)o, cassandraOptions);
    }

    @Override
    public Set<VALUEFROM> decodeFromGettable(GettableData gettableData) {
        if (gettableData.isNull(NamingHelper.maybeQuote(this.getColumnForSelect())) && !this.emptyCollectionIfNull) {
            return null;
        }
        return this.decodeFromGettableInternal(gettableData);
    }

    @Override
    public Set<VALUEFROM> decodeFromGettableInternal(GettableData gettableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' set from gettable object %s", this.fieldName, gettableData));
        }
        return this.decodeFromRaw(gettableData.getSet(this.fieldInfo.quotedCqlColumn, this.valueProperty.valueToTypeToken));
    }

    @Override
    public Set<VALUEFROM> decodeFromRaw(Object o) {
        return this.decodeFromRawInternal(o);
    }

    @Override
    public Set<VALUEFROM> decodeFromRawInternal(Object o) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' set raw object %s", this.fieldName, o));
        }
        if (o == null) {
            if (this.emptyCollectionIfNull) {
                return new HashSet();
            }
            return null;
        }
        Validator.validateTrue((boolean)Set.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to decode should be Set<%s>", (Object[])new Object[]{o, this.valueToClass.getCanonicalName()});
        return new HashSet(((Set)o).stream().map(valueTo -> this.valueProperty.decodeFromRaw(valueTo)).collect(Collectors.toSet()));
    }

    public VALUEFROM decodeSingleElement(VALUETO cassandraValue) {
        return this.valueProperty.decodeFromRaw(cassandraValue);
    }

    @Override
    public DataType buildType(Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Build current '%s' set data type", this.fieldName));
        }
        DataType valueType = this.valueProperty.buildType(cassandraOptions);
        if (this.frozen) {
            return DataType.frozenSet((DataType)valueType);
        }
        return DataType.set((DataType)valueType);
    }

    @Override
    public void encodeFieldToUdt(ENTITY entity, UDTValue udtValue, Optional<CassandraOptions> cassandraOptions) {
        Set valueTo = (Set)this.encodeField(entity, cassandraOptions);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode '%s' set %s to UDT value %s", this.fieldName, valueTo, udtValue));
        }
        udtValue.set(this.fieldInfo.quotedCqlColumn, (Object)valueTo, this.valueToTypeToken);
    }

    @Override
    public boolean containsUDTProperty() {
        return this.valueProperty.containsUDTProperty();
    }

    @Override
    public List<AbstractUDTClassProperty<?>> getUDTClassProperties() {
        return this.valueProperty.getUDTClassProperties();
    }

    @Override
    public void inject(UserTypeFactory userTypeFactory, TupleTypeFactory tupleTypeFactory) {
        this.valueProperty.inject(userTypeFactory, tupleTypeFactory);
    }

    @Override
    public void inject(ObjectMapper mapper) {
        this.valueProperty.inject(mapper);
    }

    @Override
    public void inject(BeanFactory factory) {
        this.valueProperty.inject(factory);
    }

    @Override
    public void injectRuntimeCodecs(Map<CodecSignature<?, ?>, Codec<?, ?>> runtimeCodecs) {
        this.valueProperty.injectRuntimeCodecs(runtimeCodecs);
    }

    @Override
    public void injectKeyspace(String keyspace) {
        this.valueProperty.injectKeyspace(keyspace);
    }

    @Override
    public void inject(SchemaNameProvider schemaNameProvider) {
        super.inject(schemaNameProvider);
        this.valueProperty.inject(schemaNameProvider);
    }
}

