/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.UDTValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import info.archinnov.achilles.internals.factory.TupleTypeFactory;
import info.archinnov.achilles.internals.factory.UserTypeFactory;
import info.archinnov.achilles.internals.injectable.InjectBeanFactory;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractUDTClassProperty;
import info.archinnov.achilles.internals.metamodel.columns.FieldInfo;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.utils.NamingHelper;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.type.codec.Codec;
import info.archinnov.achilles.type.codec.CodecSignature;
import info.archinnov.achilles.type.factory.BeanFactory;
import info.archinnov.achilles.validation.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListProperty<ENTITY, VALUEFROM, VALUETO>
extends AbstractProperty<ENTITY, List<VALUEFROM>, List<VALUETO>>
implements InjectBeanFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListProperty.class);
    public final Class<?> valueToClass;
    public final AbstractProperty<ENTITY, VALUEFROM, VALUETO> valueProperty;
    public final boolean frozen;
    public final boolean emptyCollectionIfNull;

    public ListProperty(FieldInfo<ENTITY, List<VALUEFROM>> fieldInfo, boolean frozen, boolean emptyCollectionIfNull, Class<?> valueToClass, AbstractProperty<ENTITY, VALUEFROM, VALUETO> valueProperty) {
        super(new TypeToken<List<VALUEFROM>>(){}.where(new TypeParameter<VALUEFROM>(){}, valueProperty.valueFromTypeToken), new TypeToken<List<VALUETO>>(){}.where(new TypeParameter<VALUETO>(){}, valueProperty.valueToTypeToken), fieldInfo);
        this.frozen = frozen;
        this.emptyCollectionIfNull = emptyCollectionIfNull;
        this.valueToClass = valueToClass;
        this.valueProperty = valueProperty;
    }

    public VALUETO encodeSingleElement(VALUEFROM javaValue) {
        return this.encodeSingleElement(javaValue, Optional.empty());
    }

    public VALUETO encodeSingleElement(VALUEFROM javaValue, Optional<CassandraOptions> cassandraOptions) {
        return this.valueProperty.encodeFromRaw(javaValue, cassandraOptions);
    }

    @Override
    boolean isOptional() {
        return false;
    }

    @Override
    public void encodeToSettable(List<VALUETO> valueTos, SettableData<?> settableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode list '%s' value %s to settable object %s", this.fieldName, valueTos, settableData));
        }
        settableData.setList(this.fieldInfo.quotedCqlColumn, valueTos, this.valueProperty.valueToTypeToken);
    }

    @Override
    public List<VALUETO> encodeFromJavaInternal(List<VALUEFROM> list, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode from Java '%s' list %s to CQL type", this.fieldName, list));
        }
        return new ArrayList(list.stream().map(value -> this.valueProperty.encodeFromJava(value, cassandraOptions)).collect(Collectors.toList()));
    }

    @Override
    public List<VALUETO> encodeFromRawInternal(Object o, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode raw '%s' list object %s", this.fieldName, o));
        }
        Validator.validateTrue((boolean)List.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to encode should be List", (Object[])new Object[]{o});
        return (List)this.encodeFromJava((List)o, cassandraOptions);
    }

    @Override
    public List<VALUEFROM> decodeFromGettable(GettableData gettableData) {
        if (gettableData.isNull(NamingHelper.maybeQuote(this.getColumnForSelect())) && !this.emptyCollectionIfNull) {
            return null;
        }
        return this.decodeFromGettableInternal(gettableData);
    }

    @Override
    public List<VALUEFROM> decodeFromGettableInternal(GettableData gettableData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' list from gettable object %s", this.fieldName, gettableData));
        }
        return this.decodeFromRaw(gettableData.getList(this.fieldInfo.quotedCqlColumn, this.valueProperty.valueToTypeToken));
    }

    @Override
    public List<VALUEFROM> decodeFromRaw(Object o) {
        return this.decodeFromRawInternal(o);
    }

    @Override
    public List<VALUEFROM> decodeFromRawInternal(Object o) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decode '%s' list raw object %s", this.fieldName, o));
        }
        if (o == null) {
            if (this.emptyCollectionIfNull) {
                return new ArrayList();
            }
            return null;
        }
        Validator.validateTrue((boolean)List.class.isAssignableFrom(o.getClass()), (String)"The class of object %s to decode should be List<%s>", (Object[])new Object[]{o, o});
        return new ArrayList(((List)o).stream().map(valueTo -> this.valueProperty.decodeFromRaw(valueTo)).collect(Collectors.toList()));
    }

    public VALUEFROM decodeSingleElement(VALUETO cassandraValue) {
        return this.valueProperty.decodeFromRaw(cassandraValue);
    }

    @Override
    public DataType buildType(Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Build current '%s' list data type", this.fieldName));
        }
        DataType valueType = this.valueProperty.buildType(cassandraOptions);
        if (this.frozen) {
            return DataType.frozenList((DataType)valueType);
        }
        return DataType.list((DataType)valueType);
    }

    @Override
    public void encodeFieldToUdt(ENTITY entity, UDTValue udtValue, Optional<CassandraOptions> cassandraOptions) {
        List valueTo = (List)this.encodeField(entity, cassandraOptions);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encode '%s' list %s to UDT value %s", this.fieldName, valueTo, udtValue));
        }
        udtValue.set(this.fieldInfo.quotedCqlColumn, (Object)valueTo, this.valueToTypeToken);
    }

    @Override
    public boolean containsUDTProperty() {
        return this.valueProperty.containsUDTProperty();
    }

    @Override
    public List<AbstractUDTClassProperty<?>> getUDTClassProperties() {
        return this.valueProperty.getUDTClassProperties();
    }

    @Override
    public void inject(UserTypeFactory userTypeFactory, TupleTypeFactory tupleTypeFactory) {
        this.valueProperty.inject(userTypeFactory, tupleTypeFactory);
    }

    @Override
    public void inject(ObjectMapper mapper) {
        this.valueProperty.inject(mapper);
    }

    @Override
    public void inject(BeanFactory factory) {
        this.valueProperty.inject(factory);
    }

    @Override
    public void injectRuntimeCodecs(Map<CodecSignature<?, ?>, Codec<?, ?>> runtimeCodecs) {
        this.valueProperty.injectRuntimeCodecs(runtimeCodecs);
    }

    @Override
    public void injectKeyspace(String keyspace) {
        this.valueProperty.injectKeyspace(keyspace);
    }

    @Override
    public void inject(SchemaNameProvider schemaNameProvider) {
        super.inject(schemaNameProvider);
        this.valueProperty.inject(schemaNameProvider);
    }
}

