/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.metamodel;

import com.datastax.driver.core.AbstractTableMetadata;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.BiMap;
import info.archinnov.achilles.internals.cache.StatementsCache;
import info.archinnov.achilles.internals.cassandra_version.InternalCassandraVersion;
import info.archinnov.achilles.internals.context.ConfigurationContext;
import info.archinnov.achilles.internals.factory.TupleTypeFactory;
import info.archinnov.achilles.internals.factory.UserTypeFactory;
import info.archinnov.achilles.internals.injectable.InjectBeanFactory;
import info.archinnov.achilles.internals.injectable.InjectConsistency;
import info.archinnov.achilles.internals.injectable.InjectInsertStrategy;
import info.archinnov.achilles.internals.injectable.InjectJacksonMapper;
import info.archinnov.achilles.internals.injectable.InjectKeyspace;
import info.archinnov.achilles.internals.injectable.InjectRuntimeCodecs;
import info.archinnov.achilles.internals.injectable.InjectSchemaStrategy;
import info.archinnov.achilles.internals.injectable.InjectUserAndTupleTypeFactory;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.BeanValueExtractor;
import info.archinnov.achilles.internals.schema.SchemaContext;
import info.archinnov.achilles.internals.schema.SchemaCreator;
import info.archinnov.achilles.internals.schema.SchemaValidator;
import info.archinnov.achilles.internals.statements.BoundValuesWrapper;
import info.archinnov.achilles.internals.statements.PreparedStatementGenerator;
import info.archinnov.achilles.internals.strategy.naming.InternalNamingStrategy;
import info.archinnov.achilles.internals.types.OverridingOptional;
import info.archinnov.achilles.internals.utils.CollectionsHelper;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.type.codec.Codec;
import info.archinnov.achilles.type.codec.CodecSignature;
import info.archinnov.achilles.type.factory.BeanFactory;
import info.archinnov.achilles.type.interceptor.Event;
import info.archinnov.achilles.type.interceptor.Interceptor;
import info.archinnov.achilles.type.strategy.InsertStrategy;
import info.archinnov.achilles.validation.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityProperty<T>
implements InjectBeanFactory,
InjectKeyspace,
InjectConsistency,
InjectInsertStrategy,
InjectUserAndTupleTypeFactory,
InjectJacksonMapper,
InjectSchemaStrategy,
InjectRuntimeCodecs {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEntityProperty.class);
    public final Logger entityLogger;
    public final Class<T> entityClass;
    public final Optional<String> staticKeyspace;
    public final Optional<String> staticTableOrViewName;
    public final String derivedTableOrViewName;
    public final BiMap<String, String> fieldNameToCqlColumn;
    public final boolean counterTable;
    public final Optional<ConsistencyLevel> staticReadConsistency;
    public final Optional<ConsistencyLevel> staticWriteConsistency;
    public final Optional<ConsistencyLevel> staticSerialConsistency;
    public final Optional<Integer> staticTTL;
    public final Optional<InsertStrategy> staticInsertStrategy;
    public final Optional<InternalNamingStrategy> staticNamingStrategy;
    public final List<AbstractProperty<T, ?, ?>> partitionKeys;
    public final List<AbstractProperty<T, ?, ?>> clusteringColumns;
    public final List<AbstractProperty<T, ?, ?>> staticColumns;
    public final List<AbstractProperty<T, ?, ?>> normalColumns;
    public final List<AbstractProperty<T, ?, ?>> computedColumns;
    public final List<AbstractProperty<T, ?, ?>> counterColumns;
    public final List<AbstractProperty<T, ?, ?>> constructorInjectedColumns;
    public final List<AbstractProperty<T, ?, ?>> allColumns;
    public final List<AbstractProperty<T, ?, ?>> allColumnsWithComputed;
    public final List<Interceptor<T>> interceptors = new ArrayList<Interceptor<T>>();
    protected BeanFactory beanFactory;
    protected Optional<String> keyspace = Optional.empty();
    protected ConsistencyLevel readConsistencyLevel;
    protected ConsistencyLevel writeConsistencyLevel;
    protected ConsistencyLevel serialConsistencyLevel;
    protected InsertStrategy insertStrategy;
    public Optional<SchemaNameProvider> schemaStrategy = Optional.empty();

    public AbstractEntityProperty() {
        this.entityClass = this.getEntityClass();
        this.entityLogger = LoggerFactory.getLogger(this.entityClass);
        this.staticKeyspace = this.getStaticKeyspace();
        this.staticTableOrViewName = this.getStaticTableOrViewName();
        this.derivedTableOrViewName = this.getDerivedTableOrViewName();
        this.fieldNameToCqlColumn = this.fieldNameToCqlColumn();
        this.counterTable = this.isCounterTable();
        this.staticReadConsistency = this.getStaticReadConsistency();
        this.staticWriteConsistency = this.getStaticWriteConsistency();
        this.staticSerialConsistency = this.getStaticSerialConsistency();
        this.staticTTL = this.getStaticTTL();
        this.staticInsertStrategy = this.getStaticInsertStrategy();
        this.staticNamingStrategy = this.getStaticNamingStrategy();
        this.partitionKeys = this.getPartitionKeys();
        this.clusteringColumns = this.getClusteringColumns();
        this.staticColumns = this.getStaticColumns();
        this.normalColumns = this.getNormalColumns();
        this.computedColumns = this.getComputedColumns();
        this.constructorInjectedColumns = this.getConstructorInjectedColumns();
        this.counterColumns = this.getCounterColumns();
        this.allColumns = this.getAllColumns();
        this.allColumnsWithComputed = this.getAllColumnsWithComputed();
    }

    protected abstract Class<T> getEntityClass();

    protected abstract Optional<String> getStaticKeyspace();

    protected abstract Optional<String> getStaticTableOrViewName();

    protected abstract String getDerivedTableOrViewName();

    protected abstract BiMap<String, String> fieldNameToCqlColumn();

    protected abstract boolean isCounterTable();

    protected abstract Optional<ConsistencyLevel> getStaticReadConsistency();

    protected abstract Optional<ConsistencyLevel> getStaticWriteConsistency();

    protected abstract Optional<ConsistencyLevel> getStaticSerialConsistency();

    protected abstract Optional<Integer> getStaticTTL();

    protected abstract Optional<InsertStrategy> getStaticInsertStrategy();

    protected abstract Optional<InternalNamingStrategy> getStaticNamingStrategy();

    protected abstract List<AbstractProperty<T, ?, ?>> getPartitionKeys();

    protected abstract List<AbstractProperty<T, ?, ?>> getClusteringColumns();

    protected abstract List<AbstractProperty<T, ?, ?>> getStaticColumns();

    protected abstract List<AbstractProperty<T, ?, ?>> getNormalColumns();

    protected abstract List<AbstractProperty<T, ?, ?>> getComputedColumns();

    protected abstract List<AbstractProperty<T, ?, ?>> getCounterColumns();

    protected abstract List<AbstractProperty<T, ?, ?>> getConstructorInjectedColumns();

    protected EntityType getType() {
        return EntityType.TABLE;
    }

    public ConsistencyLevel readConsistency(Optional<ConsistencyLevel> runtimeConsistency) {
        ConsistencyLevel consistencyLevel = (ConsistencyLevel)OverridingOptional.from(runtimeConsistency).defaultValue((Optional<ConsistencyLevel>)this.readConsistencyLevel).get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Determining runtime read consistency level for entity %s : %s", this.entityClass.getCanonicalName(), consistencyLevel.name()));
        }
        return consistencyLevel;
    }

    public ConsistencyLevel writeConsistency(Optional<ConsistencyLevel> runtimeConsistency) {
        ConsistencyLevel consistencyLevel = (ConsistencyLevel)OverridingOptional.from(runtimeConsistency).defaultValue((Optional<ConsistencyLevel>)this.writeConsistencyLevel).get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Determining runtime write consistency level for entity %s : %s", this.entityClass.getCanonicalName(), consistencyLevel.name()));
        }
        return consistencyLevel;
    }

    public ConsistencyLevel serialConsistency(Optional<ConsistencyLevel> runtimeConsistency) {
        ConsistencyLevel consistencyLevel = (ConsistencyLevel)OverridingOptional.from(runtimeConsistency).defaultValue((Optional<ConsistencyLevel>)this.serialConsistencyLevel).get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Determining runtime serial consistency level for entity %s : %s", this.entityClass.getCanonicalName(), consistencyLevel.name()));
        }
        return consistencyLevel;
    }

    public boolean isCounter() {
        return this.counterColumns.size() > 0;
    }

    public boolean isClustered() {
        return this.clusteringColumns.size() > 0;
    }

    public boolean hasStaticColumn() {
        return this.staticColumns.size() > 0;
    }

    public InsertStrategy insertStrategy() {
        return this.staticInsertStrategy.orElse(this.insertStrategy);
    }

    public void triggerInterceptorsForEvent(Event event, T instance) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Trigger interceptors for entity %s on event %s", instance, event.name()));
        }
        this.interceptors.stream().filter(x -> x.interceptOnEvents().contains(event)).forEach(x -> x.onEvent(instance, event));
    }

    protected abstract T newInstanceFromCustomConstructor(Row var1, List<String> var2);

    public T createEntityFrom(Row row) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Create entity of type %s from Cassandra row %s", this.entityClass.getCanonicalName(), row));
        }
        if (row != null) {
            List<String> cqlColumns = row.getColumnDefinitions().asList().stream().map(def -> def.getName()).collect(Collectors.toList());
            if (this.constructorInjectedColumns.size() == 0) {
                Object newInstance = this.beanFactory.newInstance(this.entityClass);
                this.allColumnsWithComputed.stream().filter(x -> cqlColumns.contains(x.getColumnForSelect())).forEach(x -> x.decodeField((GettableData)row, newInstance));
                return (T)newInstance;
            }
            Object newInstance = this.newInstanceFromCustomConstructor(row, cqlColumns);
            this.allColumnsWithComputed.stream().filter(x -> !this.constructorInjectedColumns.contains(x)).forEach(x -> x.decodeField((GettableData)row, newInstance));
            return newInstance;
        }
        return null;
    }

    public BoundValuesWrapper extractAllValuesFromEntity(T instance, CassandraOptions cassandraOptions) {
        return BeanValueExtractor.extractAllValues(instance, this, cassandraOptions);
    }

    public BoundValuesWrapper extractPartitionKeysAndStaticColumnsFromEntity(T instance, CassandraOptions cassandraOptions) {
        return BeanValueExtractor.extractPartitionKeysAndStaticValues(instance, this, cassandraOptions);
    }

    public Optional<String> getKeyspace() {
        Optional<Optional<String>> keyspace = OverridingOptional.from(this.staticNamingStrategy.flatMap(naming -> this.staticKeyspace.map(ks -> naming.apply((String)ks)))).andThen(this.staticKeyspace).andThen(this.schemaStrategy.map(x -> x.keyspaceFor(this.entityClass))).andThen(this.keyspace).getOptional();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Determine runtime keyspace for entity of type %s : %s", this.entityClass.getCanonicalName(), keyspace));
        }
        return keyspace;
    }

    public String getTableOrViewName() {
        String tableName = (String)OverridingOptional.from(this.staticNamingStrategy.flatMap(naming -> this.staticTableOrViewName.map(ks -> naming.apply((String)ks)))).andThen(this.staticTableOrViewName).andThen(this.schemaStrategy.map(x -> x.tableNameFor(this.entityClass))).defaultValue((Optional<String>)((Object)this.derivedTableOrViewName)).get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Determine runtime table name for entity of type %s : %s", this.entityClass.getCanonicalName(), tableName));
        }
        return tableName;
    }

    public void prepareStaticStatements(InternalCassandraVersion cassandraVersion, Session session, StatementsCache cache) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Preparing static statements for entity of type %s", this.entityClass.getCanonicalName()));
        }
        if (!this.counterTable) {
            PreparedStatementGenerator.generateStaticInsertQueries(cassandraVersion, session, cache, this);
        }
        PreparedStatementGenerator.generateStaticDeleteQueries(session, cache, this);
        PreparedStatementGenerator.generateStaticSelectQuery(session, cache, this);
    }

    protected List<AbstractProperty<T, ?, ?>> getAllColumns() {
        return CollectionsHelper.appendAll(this.partitionKeys, this.staticColumns, this.clusteringColumns, this.normalColumns, this.counterColumns);
    }

    protected List<AbstractProperty<T, ?, ?>> getAllColumnsWithComputed() {
        return CollectionsHelper.appendAll(this.partitionKeys, this.staticColumns, this.clusteringColumns, this.normalColumns, this.counterColumns, this.computedColumns);
    }

    public String generateSchema(SchemaContext context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generating DDL script for entity of type %s", this.entityClass.getCanonicalName()));
        }
        StringJoiner joiner = new StringJoiner("\n\n");
        SchemaCreator.generateTable_And_Indices(context, this).forEach(joiner::add);
        return joiner.toString();
    }

    public void validateSchema(ConfigurationContext configContext) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Validating schema for entity of type %s", this.entityClass.getCanonicalName()));
        }
        String keyspace = this.getKeyspace().orElse(null);
        Validator.validateNotBlank((String)keyspace, (String)"Current keyspace not provided neither in configuration nor on entity '%s' annotation", (Object[])new Object[]{this.entityClass.getCanonicalName()});
        KeyspaceMetadata keyspaceMetadata = configContext.getSession().getCluster().getMetadata().getKeyspace(keyspace);
        Validator.validateNotNull((Object)keyspaceMetadata, (String)"The keyspace %s defined on entity %s does not exist in Cassandra", (Object[])new Object[]{keyspace, this.entityClass.getCanonicalName()});
        String tableName = this.getTableOrViewName();
        TableMetadata tableMetadata = keyspaceMetadata.getTable(tableName);
        Validator.validateNotNull((Object)tableMetadata, (String)"The table %s defined on entity %s does not exist in Cassandra", (Object[])new Object[]{tableName, this.entityClass.getCanonicalName()});
        SchemaValidator.validateColumnType(ColumnType.PARTITION, (AbstractTableMetadata)tableMetadata, this.partitionKeys, this.entityClass);
        SchemaValidator.validateColumnType(ColumnType.CLUSTERING, (AbstractTableMetadata)tableMetadata, this.clusteringColumns, this.entityClass);
        SchemaValidator.validateColumnType(ColumnType.STATIC, (AbstractTableMetadata)tableMetadata, this.staticColumns, this.entityClass);
        SchemaValidator.validateDefaultTTL((AbstractTableMetadata)tableMetadata, this.staticTTL, this.entityClass);
        SchemaValidator.validateColumns((AbstractTableMetadata)tableMetadata, this.partitionKeys, this.entityClass);
        SchemaValidator.validateColumns((AbstractTableMetadata)tableMetadata, this.clusteringColumns, this.entityClass);
        SchemaValidator.validateColumns((AbstractTableMetadata)tableMetadata, this.staticColumns, this.entityClass);
        SchemaValidator.validateColumns((AbstractTableMetadata)tableMetadata, this.normalColumns, this.entityClass);
        SchemaValidator.validateColumns((AbstractTableMetadata)tableMetadata, this.counterColumns, this.entityClass);
    }

    @Override
    public void injectKeyspace(String keyspace) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Injecting global keyspace name %s into entity meta of %s", keyspace, this.entityClass.getCanonicalName()));
        }
        this.keyspace = Optional.of(keyspace);
        this.allColumns.stream().forEach(x -> x.injectKeyspace(keyspace));
    }

    @Override
    public void injectConsistencyLevels(Session session, ConfigurationContext configContext) {
        ConsistencyLevel clusterConsistency = session.getCluster().getConfiguration().getQueryOptions().getConsistencyLevel();
        ConsistencyLevel clusterSerialConsistency = session.getCluster().getConfiguration().getQueryOptions().getSerialConsistencyLevel();
        String tableOrViewName = this.getTableOrViewName();
        this.readConsistencyLevel = (ConsistencyLevel)OverridingOptional.from(this.staticReadConsistency).andThen((Optional<ConsistencyLevel>)configContext.getReadConsistencyLevelForTable(tableOrViewName)).andThen(configContext.getDefaultReadConsistencyLevel()).andThen((Optional<ConsistencyLevel>)clusterConsistency).defaultValue((Optional<ConsistencyLevel>)ConfigurationContext.DEFAULT_CONSISTENCY_LEVEL).get();
        this.writeConsistencyLevel = (ConsistencyLevel)OverridingOptional.from(this.staticWriteConsistency).andThen((Optional<ConsistencyLevel>)configContext.getWriteConsistencyLevelForTable(tableOrViewName)).andThen(configContext.getDefaultWriteConsistencyLevel()).andThen((Optional<ConsistencyLevel>)clusterConsistency).defaultValue((Optional<ConsistencyLevel>)ConfigurationContext.DEFAULT_CONSISTENCY_LEVEL).get();
        this.serialConsistencyLevel = (ConsistencyLevel)OverridingOptional.from(this.staticSerialConsistency).andThen((Optional<ConsistencyLevel>)configContext.getSerialConsistencyLevelForTable(tableOrViewName)).andThen((Optional<ConsistencyLevel>)clusterSerialConsistency).andThen(configContext.getDefaultSerialConsistencyLevel()).defaultValue((Optional<ConsistencyLevel>)ConfigurationContext.DEFAULT_SERIAL_CONSISTENCY_LEVEL).get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Injecting read/write/serial consistency levels %s/%s/%s into entity meta of %s", this.readConsistencyLevel.name(), this.writeConsistencyLevel.name(), this.serialConsistencyLevel.name(), this.entityClass.getCanonicalName()));
        }
    }

    @Override
    public void inject(InsertStrategy insertStrategy) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Injecting insert strategy %s into entity meta of %s", insertStrategy, this.entityClass.getCanonicalName()));
        }
        this.insertStrategy = !this.staticInsertStrategy.isPresent() ? insertStrategy : this.staticInsertStrategy.get();
    }

    @Override
    public void inject(SchemaNameProvider schemaNameProvider) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Injecting global schema name provider %s into entity meta of %s", schemaNameProvider, this.entityClass.getCanonicalName()));
        }
        this.schemaStrategy = Optional.ofNullable(schemaNameProvider);
        for (AbstractProperty<T, ?, ?> x : this.allColumns) {
            x.inject(schemaNameProvider);
        }
    }

    @Override
    public void inject(BeanFactory factory) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Injecting bean factory %s into entity meta of %s", factory, this.entityClass.getCanonicalName()));
        }
        this.beanFactory = factory;
        for (AbstractProperty<T, ?, ?> x : this.allColumns) {
            x.inject(factory);
        }
    }

    @Override
    public void inject(UserTypeFactory userTypeFactory, TupleTypeFactory tupleTypeFactory) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Injecting user type factory %s and tuple type factory %s into entity meta of %s", userTypeFactory, tupleTypeFactory, this.entityClass.getCanonicalName()));
        }
        for (AbstractProperty<T, ?, ?> x : this.allColumns) {
            x.inject(userTypeFactory, tupleTypeFactory);
        }
    }

    @Override
    public void inject(ObjectMapper jacksonMapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Injecting Jackson Object Mapper instance %s into entity meta of %s", jacksonMapper, this.entityClass.getCanonicalName()));
        }
        for (AbstractProperty<T, ?, ?> x : this.allColumns) {
            x.inject(jacksonMapper);
        }
    }

    @Override
    public void injectRuntimeCodecs(Map<CodecSignature<?, ?>, Codec<?, ?>> runtimeCodecs) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Injecting runtime codecs into entity meta of %s", this.entityClass.getCanonicalName()));
        }
        for (AbstractProperty<T, ?, ?> x : this.allColumns) {
            x.injectRuntimeCodecs(runtimeCodecs);
        }
    }

    public boolean isTable() {
        return true;
    }

    public boolean isView() {
        return false;
    }

    public static enum EntityType {
        TABLE,
        VIEW;

    }
}

