/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.interceptor;

import info.archinnov.achilles.exception.AchillesBeanValidationException;
import info.archinnov.achilles.internals.interceptor.AchillesInternalInterceptor;
import info.archinnov.achilles.type.interceptor.Event;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPreMutateBeanValidationInterceptor
implements AchillesInternalInterceptor<Object> {
    private static final String LOGGER_NAME = "info.archinnov.achilles.internals.interceptor.DefaultBeanValidatorInterceptor";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"info.archinnov.achilles.internals.interceptor.DefaultBeanValidatorInterceptor");
    private final Map<Class<?>, Boolean> constrainedClasses = new HashMap();
    private Validator validator;

    public DefaultPreMutateBeanValidationInterceptor(Validator validator) {
        this.validator = validator;
    }

    public boolean acceptEntity(Class<?> entityClass) {
        if (!this.constrainedClasses.containsKey(entityClass)) {
            this.constrainedClasses.put(entityClass, this.validator.getConstraintsForClass(entityClass).isBeanConstrained());
        }
        Boolean acceptEntity = this.constrainedClasses.get(entityClass);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Accept entity %s for bean validation ? %s", entityClass.getCanonicalName(), acceptEntity));
        }
        return acceptEntity;
    }

    public void onEvent(Object entity, Event event) {
        Set violations;
        info.archinnov.achilles.validation.Validator.validateNotNull((Object)entity, (String)"Entity passed to bean validation interceptor should not be null on event %s", (Object[])new Object[]{event.name()});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Trigger bean validation interceptor for entity of class %s and event %s", entity.getClass().getCanonicalName(), event.name()));
        }
        if ((violations = this.validator.validate(entity, new Class[0])).size() > 0) {
            StringBuilder errorMessage = new StringBuilder("Bean validation error on event '" + event.name() + "' : \n");
            for (ConstraintViolation violation : violations) {
                this.buildValidationErrorMessage(errorMessage, (ConstraintViolation<Object>)violation);
            }
            throw new AchillesBeanValidationException(errorMessage.toString());
        }
    }

    public List<Event> interceptOnEvents() {
        return Arrays.asList(Event.PRE_INSERT, Event.PRE_UPDATE);
    }

    private void buildValidationErrorMessage(StringBuilder errorMessage, ConstraintViolation<Object> violation) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Building validation error message for violation %s", violation.getMessage()));
        }
        String className = violation.getLeafBean().getClass().getCanonicalName();
        Path propertyPath = violation.getPropertyPath();
        errorMessage.append("\t");
        if (propertyPath != null && StringUtils.isNotBlank((CharSequence)propertyPath.toString())) {
            errorMessage.append("property '").append(propertyPath).append("'").append(" of class '").append(className).append("' ").append(violation.getMessage()).append("\n");
        } else {
            errorMessage.append(violation.getMessage()).append(" for class '").append(className).append("'");
        }
    }
}

