/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.factory;

import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.type.factory.BeanFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBeanFactory
implements BeanFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBeanFactory.class);

    public <T> T newInstance(Class<T> clazz) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Creating new instance of class %s", clazz.getCanonicalName()));
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AchillesException(String.format("Cannot instantiate instance of class '%s'. Did you forget to declare a default constructor ?", clazz.getCanonicalName()));
        }
    }
}

