/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.options;

import info.archinnov.achilles.internals.dsl.options.AbstractOptionsForSelect;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.types.OverridingOptional;
import info.archinnov.achilles.type.lightweighttransaction.LWTResultListener;
import info.archinnov.achilles.type.strategy.InsertStrategy;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOptionsForCRUDInsert<T extends AbstractOptionsForCRUDInsert<T>>
extends AbstractOptionsForSelect<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOptionsForCRUDInsert.class);
    protected Optional<InsertStrategy> insertStrategy = Optional.empty();
    protected Optional<Boolean> ifNotExists = Optional.empty();
    protected Optional<List<LWTResultListener>> lwtResultListeners = Optional.empty();

    public T ifNotExists(boolean ifNotExists) {
        this.ifNotExists = Optional.of(ifNotExists);
        return (T)((AbstractOptionsForCRUDInsert)this.getThis());
    }

    public T ifNotExists() {
        this.ifNotExists = Optional.of(true);
        return (T)((AbstractOptionsForCRUDInsert)this.getThis());
    }

    public T withLwtResultListeners(List<LWTResultListener> lwtResultListeners) {
        this.lwtResultListeners = Optional.of(lwtResultListeners);
        return (T)((AbstractOptionsForCRUDInsert)this.getThis());
    }

    public T withLwtResultListener(LWTResultListener lwtResultListener) {
        this.lwtResultListeners = Optional.of(Arrays.asList(lwtResultListener));
        return (T)((AbstractOptionsForCRUDInsert)this.getThis());
    }

    public T usingTimestamp(long timestamp) {
        this.getOptions().setDefaultTimestamp(Optional.of(timestamp));
        return (T)((AbstractOptionsForCRUDInsert)this.getThis());
    }

    public T usingTimeToLive(int timeToLive) {
        this.getOptions().setTimeToLive(Optional.of(timeToLive));
        return (T)((AbstractOptionsForCRUDInsert)this.getThis());
    }

    public T withInsertStrategy(InsertStrategy insertStrategy) {
        this.insertStrategy = Optional.of(insertStrategy);
        return (T)((AbstractOptionsForCRUDInsert)this.getThis());
    }

    public InsertStrategy getOverridenStrategy(AbstractEntityProperty<?> property) {
        InsertStrategy insertStrategy = (InsertStrategy)OverridingOptional.from(this.insertStrategy).defaultValue((Optional<InsertStrategy>)property.insertStrategy()).get();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Get runtime insert strategy for entity %s : %s", property.entityClass.getCanonicalName(), insertStrategy.name()));
        }
        return insertStrategy;
    }
}

