/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.crud;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import info.archinnov.achilles.internals.cache.CacheKey;
import info.archinnov.achilles.internals.dsl.LWTHelper;
import info.archinnov.achilles.internals.dsl.StatementProvider;
import info.archinnov.achilles.internals.dsl.action.MutationAction;
import info.archinnov.achilles.internals.dsl.options.AbstractOptionsForCRUDInsert;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.internals.statements.BoundValuesWrapper;
import info.archinnov.achilles.internals.statements.StatementWrapper;
import info.archinnov.achilles.type.interceptor.Event;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertWithOptions<ENTITY>
extends AbstractOptionsForCRUDInsert<InsertWithOptions<ENTITY>>
implements MutationAction,
StatementProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertWithOptions.class);
    private final AbstractEntityProperty<ENTITY> meta;
    private final RuntimeEngine rte;
    private final ENTITY instance;
    private final CassandraOptions options;
    private final boolean insertStatic;

    public InsertWithOptions(AbstractEntityProperty<ENTITY> meta, RuntimeEngine rte, ENTITY instance, boolean insertStatic, Optional<CassandraOptions> cassandraOptions) {
        this.meta = meta;
        this.rte = rte;
        this.instance = instance;
        this.insertStatic = insertStatic;
        this.options = cassandraOptions.orElse(new CassandraOptions());
    }

    @Override
    public CompletableFuture<ExecutionInfo> executeAsyncWithStats() {
        this.meta.triggerInterceptorsForEvent(Event.PRE_INSERT, this.instance);
        StatementWrapper statementWrapper = this.getInternalBoundStatementWrapper();
        String queryString = statementWrapper.getBoundStatement().preparedStatement().getQueryString();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Insert async with execution info : %s", queryString));
        }
        CompletableFuture<ResultSet> cfutureRS = this.rte.execute(statementWrapper);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)cfutureRS.thenApply(this.options::resultSetAsyncListener)).thenApply(statementWrapper::logTrace)).thenApply(x -> LWTHelper.triggerLWTListeners(this.lwtResultListeners, x, queryString))).thenApply(x -> x.getExecutionInfo())).thenApply(x -> {
            this.meta.triggerInterceptorsForEvent(Event.POST_INSERT, this.instance);
            return x;
        });
    }

    @Override
    protected CassandraOptions getOptions() {
        return this.options;
    }

    @Override
    public BoundStatement generateAndGetBoundStatement() {
        return this.getInternalBoundStatementWrapper().getBoundStatement();
    }

    @Override
    public String getStatementAsString() {
        return this.getInternalPreparedStatement().getQueryString();
    }

    @Override
    public List<Object> getBoundValues() {
        BoundValuesWrapper wrapper = this.insertStatic ? this.meta.extractPartitionKeysAndStaticColumnsFromEntity(this.instance, this.options) : this.meta.extractAllValuesFromEntity(this.instance, this.options);
        return wrapper.boundValuesInfo.stream().map(x -> x.boundValue).collect(Collectors.toList());
    }

    @Override
    public List<Object> getEncodedBoundValues() {
        BoundValuesWrapper wrapper = this.insertStatic ? this.meta.extractPartitionKeysAndStaticColumnsFromEntity(this.instance, this.options) : this.meta.extractAllValuesFromEntity(this.instance, this.options);
        return wrapper.boundValuesInfo.stream().map(x -> x.encodedValue).collect(Collectors.toList());
    }

    @Override
    protected InsertWithOptions<ENTITY> getThis() {
        return this;
    }

    private StatementWrapper getInternalBoundStatementWrapper() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Get bound statement wrapper", new Object[0]));
        }
        PreparedStatement ps = this.getInternalPreparedStatement();
        BoundValuesWrapper wrapper = this.insertStatic ? this.meta.extractPartitionKeysAndStaticColumnsFromEntity(this.instance, this.options) : this.meta.extractAllValuesFromEntity(this.instance, this.options);
        StatementWrapper statementWrapper = wrapper.bindWithInsertStrategy(ps, this.getOverridenStrategy(this.meta));
        statementWrapper.applyOptions(this.options);
        return statementWrapper;
    }

    private PreparedStatement getInternalPreparedStatement() {
        if (this.ifNotExists.isPresent() && ((Boolean)this.ifNotExists.get()).booleanValue()) {
            return this.insertStatic ? CacheKey.Operation.INSERT_STATIC_IF_NOT_EXISTS.getPreparedStatement(this.rte, this.meta, this.options) : CacheKey.Operation.INSERT_IF_NOT_EXISTS.getPreparedStatement(this.rte, this.meta, this.options);
        }
        return this.insertStatic ? CacheKey.Operation.INSERT_STATIC.getPreparedStatement(this.rte, this.meta, this.options) : CacheKey.Operation.INSERT.getPreparedStatement(this.rte, this.meta, this.options);
    }
}

