/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.crud;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import info.archinnov.achilles.internals.cache.CacheKey;
import info.archinnov.achilles.internals.dsl.LWTHelper;
import info.archinnov.achilles.internals.dsl.StatementProvider;
import info.archinnov.achilles.internals.dsl.action.MutationAction;
import info.archinnov.achilles.internals.dsl.options.AbstractOptionsForCRUDInsert;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.internals.statements.BoundStatementWrapper;
import info.archinnov.achilles.internals.statements.OperationType;
import info.archinnov.achilles.internals.statements.StatementWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertJSONWithOptions
extends AbstractOptionsForCRUDInsert<InsertJSONWithOptions>
implements MutationAction,
StatementProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertJSONWithOptions.class);
    private final AbstractEntityProperty<?> meta;
    private final RuntimeEngine rte;
    private final String json;
    private final CassandraOptions cassandraOptions;
    private final Object[] encodedBoundValues;
    private final List<Object> encodedBoundValuesAsList;

    public InsertJSONWithOptions(AbstractEntityProperty<?> meta, RuntimeEngine rte, String json, Optional<CassandraOptions> cassandraOptions) {
        this.meta = meta;
        this.rte = rte;
        this.json = json;
        this.cassandraOptions = cassandraOptions.orElse(new CassandraOptions());
        this.encodedBoundValues = new Object[]{json};
        this.encodedBoundValuesAsList = Arrays.asList(json);
    }

    @Override
    public CompletableFuture<ExecutionInfo> executeAsyncWithStats() {
        StatementWrapper statementWrapper = this.getInternalBoundStatementWrapper();
        String queryString = statementWrapper.getBoundStatement().preparedStatement().getQueryString();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Insert JSON async with execution info : %s", queryString));
        }
        CompletableFuture<ResultSet> cfutureRS = this.rte.execute(statementWrapper);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)cfutureRS.thenApply(this.getOptions()::resultSetAsyncListener)).thenApply(statementWrapper::logTrace)).thenApply(x -> LWTHelper.triggerLWTListeners(this.lwtResultListeners, x, queryString))).thenApply(x -> x.getExecutionInfo());
    }

    @Override
    protected CassandraOptions getOptions() {
        return this.cassandraOptions;
    }

    @Override
    public BoundStatement generateAndGetBoundStatement() {
        return this.getInternalBoundStatementWrapper().getBoundStatement();
    }

    @Override
    public String getStatementAsString() {
        return this.getInternalPreparedStatement().getQueryString();
    }

    @Override
    public List<Object> getBoundValues() {
        return this.encodedBoundValuesAsList;
    }

    @Override
    public List<Object> getEncodedBoundValues() {
        return this.encodedBoundValuesAsList;
    }

    @Override
    protected InsertJSONWithOptions getThis() {
        return this;
    }

    private StatementWrapper getInternalBoundStatementWrapper() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Get bound statement wrapper", new Object[0]));
        }
        PreparedStatement ps = this.getInternalPreparedStatement();
        BoundStatement bs = ps.bind(new Object[]{this.json});
        BoundStatementWrapper statementWrapper = new BoundStatementWrapper(OperationType.INSERT, this.meta, bs, this.encodedBoundValues);
        statementWrapper.applyOptions(this.getOptions());
        return statementWrapper;
    }

    private PreparedStatement getInternalPreparedStatement() {
        if (this.ifNotExists.isPresent() && ((Boolean)this.ifNotExists.get()).booleanValue()) {
            return CacheKey.Operation.INSERT_IF_NOT_EXISTS_JSON.getPreparedStatement(this.rte, this.meta, this.getOptions());
        }
        return CacheKey.Operation.INSERT_JSON.getPreparedStatement(this.rte, this.meta, this.getOptions());
    }
}

