/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.crud;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.util.concurrent.Uninterruptibles;
import info.archinnov.achilles.internals.cache.CacheKey;
import info.archinnov.achilles.internals.dsl.AsyncAware;
import info.archinnov.achilles.internals.dsl.StatementProvider;
import info.archinnov.achilles.internals.dsl.options.AbstractOptionsForSelect;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.internals.statements.BoundStatementWrapper;
import info.archinnov.achilles.internals.statements.OperationType;
import info.archinnov.achilles.internals.statements.StatementWrapper;
import info.archinnov.achilles.type.interceptor.Event;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindWithOptions<ENTITY>
extends AbstractOptionsForSelect<FindWithOptions<ENTITY>>
implements StatementProvider,
AsyncAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(FindWithOptions.class);
    private final Class<ENTITY> entityClass;
    private final AbstractEntityProperty<ENTITY> meta;
    private final RuntimeEngine rte;
    private final Object[] primaryKeyValues;
    private final Object[] encodedPrimaryKeyValues;
    private final CassandraOptions options;

    public FindWithOptions(Class<ENTITY> entityClass, AbstractEntityProperty<ENTITY> meta, RuntimeEngine rte, Object[] primaryKeyValues, Object[] encodedPrimaryKeyValues, Optional<CassandraOptions> cassandraOptions) {
        this.entityClass = entityClass;
        this.meta = meta;
        this.rte = rte;
        this.primaryKeyValues = primaryKeyValues;
        this.encodedPrimaryKeyValues = encodedPrimaryKeyValues;
        this.options = cassandraOptions.orElse(new CassandraOptions());
    }

    public ENTITY get() {
        try {
            return (ENTITY)Uninterruptibles.getUninterruptibly(this.getAsync());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    public Tuple2<ENTITY, ExecutionInfo> getWithStats() {
        try {
            return (Tuple2)Uninterruptibles.getUninterruptibly(this.getAsyncWithStats());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    public CompletableFuture<ENTITY> getAsync() {
        return this.getAsyncWithStats().thenApply(tuple2 -> tuple2._1());
    }

    public CompletableFuture<Tuple2<ENTITY, ExecutionInfo>> getAsyncWithStats() {
        StatementWrapper statementWrapper = this.getInternalBoundStatementWrapper();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Find async with execution info : %s", statementWrapper.getBoundStatement().preparedStatement().getQueryString()));
        }
        CompletableFuture<ResultSet> futureRS = this.rte.execute(statementWrapper);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)futureRS.thenApply(this.options::resultSetAsyncListener)).thenApply(x -> statementWrapper.logReturnResults((ResultSet)x, this.options.computeMaxDisplayedResults(this.rte.configContext)))).thenApply(statementWrapper::logTrace)).thenApply(rs -> {
            Row row = rs.one();
            this.options.rowAsyncListener(row);
            return Tuple2.of(this.meta.createEntityFrom(row), (Object)rs.getExecutionInfo());
        })).thenApply(tuple2 -> {
            this.meta.triggerInterceptorsForEvent(Event.POST_LOAD, tuple2._1());
            return tuple2;
        });
    }

    @Override
    protected CassandraOptions getOptions() {
        return this.options;
    }

    @Override
    public BoundStatement generateAndGetBoundStatement() {
        return this.getInternalBoundStatementWrapper().getBoundStatement();
    }

    @Override
    public String getStatementAsString() {
        return this.rte.getStaticCache(new CacheKey(this.entityClass, CacheKey.Operation.FIND)).getQueryString();
    }

    @Override
    public List<Object> getBoundValues() {
        return Arrays.asList(this.primaryKeyValues);
    }

    @Override
    public List<Object> getEncodedBoundValues() {
        return Arrays.asList(this.encodedPrimaryKeyValues);
    }

    @Override
    protected FindWithOptions<ENTITY> getThis() {
        return this;
    }

    private StatementWrapper getInternalBoundStatementWrapper() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Get bound statement wrapper", new Object[0]));
        }
        PreparedStatement ps = CacheKey.Operation.FIND.getPreparedStatement(this.rte, this.meta, this.options);
        BoundStatementWrapper statementWrapper = new BoundStatementWrapper(OperationType.SELECT, this.meta, ps, this.primaryKeyValues, this.encodedPrimaryKeyValues);
        statementWrapper.applyOptions(this.options);
        return statementWrapper;
    }
}

