/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.action;

import com.datastax.driver.core.ExecutionInfo;
import com.google.common.util.concurrent.Uninterruptibles;
import info.archinnov.achilles.internals.dsl.AsyncAware;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public interface SelectJSONAction
extends AsyncAware {
    public Iterator<String> iterator();

    public Tuple2<Iterator<String>, ExecutionInfo> iteratorWithExecutionInfo();

    default public String getJSON() {
        try {
            return (String)Uninterruptibles.getUninterruptibly(this.getJSONAsync());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    default public Tuple2<String, ExecutionInfo> getJSONWithStats() {
        try {
            return (Tuple2)Uninterruptibles.getUninterruptibly(this.getJSONAsyncWithStats());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    default public CompletableFuture<String> getJSONAsync() {
        return this.getListJSONAsync().thenApply(list -> list.size() > 0 ? (String)list.get(0) : null);
    }

    default public CompletableFuture<Tuple2<String, ExecutionInfo>> getJSONAsyncWithStats() {
        return this.getListJSONAsyncWithStats().thenApply(tuple2 -> ((List)tuple2._1()).size() > 0 ? Tuple2.of(((List)tuple2._1()).get(0), (Object)tuple2._2()) : Tuple2.of(null, (Object)tuple2._2()));
    }

    default public List<String> getListJSON() {
        try {
            return (List)Uninterruptibles.getUninterruptibly(this.getListJSONAsync());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    default public CompletableFuture<List<String>> getListJSONAsync() {
        return this.getListJSONAsyncWithStats().thenApply(Tuple2::_1);
    }

    default public Tuple2<List<String>, ExecutionInfo> getListJSONWithStats() {
        try {
            return (Tuple2)Uninterruptibles.getUninterruptibly(this.getListJSONAsyncWithStats());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    public CompletableFuture<Tuple2<List<String>, ExecutionInfo>> getListJSONAsyncWithStats();
}

