/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl.action;

import com.datastax.driver.core.ExecutionInfo;
import com.google.common.util.concurrent.Uninterruptibles;
import info.archinnov.achilles.internals.dsl.AsyncAware;
import info.archinnov.achilles.type.Empty;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public interface MutationAction
extends AsyncAware {
    default public void execute() {
        try {
            Uninterruptibles.getUninterruptibly(this.executeAsync());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    default public ExecutionInfo executeWithStats() {
        try {
            return (ExecutionInfo)Uninterruptibles.getUninterruptibly(this.executeAsyncWithStats());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    default public CompletableFuture<Empty> executeAsync() {
        return this.executeAsyncWithStats().thenApply(x -> Empty.INSTANCE);
    }

    public CompletableFuture<ExecutionInfo> executeAsyncWithStats();
}

