/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.util.concurrent.Uninterruptibles;
import info.archinnov.achilles.internals.dsl.AsyncAware;
import info.archinnov.achilles.type.TypedMap;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.IntStream;

public interface TypedMapAware
extends AsyncAware {
    public Iterator<TypedMap> typedMapIterator();

    public Tuple2<Iterator<TypedMap>, ExecutionInfo> typedMapIteratorWithExecutionInfo();

    public CompletableFuture<Tuple2<List<TypedMap>, ExecutionInfo>> getTypedMapsAsyncWithStats();

    default public CompletableFuture<List<TypedMap>> getTypedMapsAsync() {
        return this.getTypedMapsAsyncWithStats().thenApply(Tuple2::_1);
    }

    default public Tuple2<List<TypedMap>, ExecutionInfo> getTypedMapsWithStats() {
        try {
            return (Tuple2)Uninterruptibles.getUninterruptibly(this.getTypedMapsAsyncWithStats());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    default public List<TypedMap> getTypedMaps() {
        try {
            return (List)Uninterruptibles.getUninterruptibly(this.getTypedMapsAsync());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    public CompletableFuture<Tuple2<TypedMap, ExecutionInfo>> getTypedMapAsyncWithStats();

    default public CompletableFuture<TypedMap> getTypedMapAsync() {
        return this.getTypedMapAsyncWithStats().thenApply(Tuple2::_1);
    }

    default public Tuple2<TypedMap, ExecutionInfo> getTypedMapWithStats() {
        try {
            return (Tuple2)Uninterruptibles.getUninterruptibly(this.getTypedMapAsyncWithStats());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    default public TypedMap getTypedMap() {
        try {
            return (TypedMap)Uninterruptibles.getUninterruptibly(this.getTypedMapAsync());
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    default public List<TypedMap> mapResultSetToTypedMaps(ResultSet resultSet) {
        ArrayList<TypedMap> result = new ArrayList<TypedMap>();
        IntStream.range(0, resultSet.getAvailableWithoutFetching()).forEach(index -> result.add(this.mapRowToTypedMap(resultSet.one())));
        return result;
    }

    default public TypedMap mapRowToTypedMap(Row row) {
        TypedMap typedMap = new TypedMap();
        if (row != null) {
            for (ColumnDefinitions.Definition def : row.getColumnDefinitions().asList()) {
                String cqlColumn = def.getName();
                typedMap.put((Object)cqlColumn, row.getObject(cqlColumn));
            }
        }
        return typedMap;
    }
}

