/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl;

import com.datastax.driver.core.Statement;
import info.archinnov.achilles.internals.statement.StatementHelper;
import info.archinnov.achilles.internals.statements.OperationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface StatementTypeAware {
    public static final Logger LOGGER = LoggerFactory.getLogger(StatementTypeAware.class);

    default public OperationType getOperationType(Statement statement) {
        OperationType foundType = StatementHelper.isSelectStatement((Statement)statement) ? OperationType.SELECT : (StatementHelper.isInsertStatement((Statement)statement) ? OperationType.INSERT : (StatementHelper.isUpdateStatement((Statement)statement) ? OperationType.UPDATE : (StatementHelper.isBatchStatement((Statement)statement) ? OperationType.OTHER : OperationType.OTHER)));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Operation type found for statement %s : %s", statement.toString(), foundType.name()));
        }
        return foundType;
    }
}

