/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl;

import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SchemaNameAware {
    public static final Logger LOGGER = LoggerFactory.getLogger(SchemaNameAware.class);

    default public String lookupKeyspace(SchemaNameProvider provider, Class<?> entityClass) {
        String foundKeyspace = provider.keyspaceFor(entityClass);
        Validator.validateNotBlank((String)foundKeyspace, (String)"Keyspace found using schema name provider for entity class '%s' should not be blank/null", (Object[])new Object[]{entityClass.getCanonicalName()});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Lookup keyspace name for entity class %s using provider %s : %s", entityClass.getCanonicalName(), provider, foundKeyspace));
        }
        return foundKeyspace;
    }

    default public String lookupTable(SchemaNameProvider provider, Class<?> entityClass) {
        String foundTableName = provider.tableNameFor(entityClass);
        Validator.validateNotBlank((String)foundTableName, (String)"Table name found using schema name provider for entity class '%s' should not be blank/null", (Object[])new Object[]{entityClass.getCanonicalName()});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Lookup table name for entity class %s using provider %s : %s", entityClass.getCanonicalName(), provider, foundTableName));
        }
        return foundTableName;
    }
}

