/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.dsl;

import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import info.archinnov.achilles.exception.AchillesBeanValidationException;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.exception.AchillesInvalidTableException;
import info.archinnov.achilles.exception.AchillesLightWeightTransactionException;
import java.util.concurrent.ExecutionException;

public interface AsyncAware {
    default public RuntimeException extractCauseFromExecutionException(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof DriverException) {
            return ((DriverException)cause).copy();
        }
        if (cause instanceof DriverInternalError) {
            return (DriverInternalError)cause;
        }
        if (cause instanceof AchillesLightWeightTransactionException) {
            return (AchillesLightWeightTransactionException)cause;
        }
        if (cause instanceof AchillesBeanValidationException) {
            return (AchillesBeanValidationException)cause;
        }
        if (cause instanceof AchillesInvalidTableException) {
            return (AchillesInvalidTableException)cause;
        }
        if (RuntimeException.class.isAssignableFrom(cause.getClass())) {
            return (RuntimeException)cause;
        }
        if (cause instanceof AchillesException) {
            return (AchillesException)cause;
        }
        return new AchillesException(cause);
    }
}

