/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.cql;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Duration;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class TypeMapper {
    private static final Map<DataType.Name, Class<?>> cql2Java = new HashMap();

    public static Class<?> toJavaType(DataType.Name cqlType) {
        return cql2Java.get(cqlType);
    }

    static {
        cql2Java.put(DataType.Name.ASCII, String.class);
        cql2Java.put(DataType.Name.BIGINT, Long.class);
        cql2Java.put(DataType.Name.BLOB, ByteBuffer.class);
        cql2Java.put(DataType.Name.BOOLEAN, Boolean.class);
        cql2Java.put(DataType.Name.COUNTER, Long.class);
        cql2Java.put(DataType.Name.DECIMAL, BigDecimal.class);
        cql2Java.put(DataType.Name.DOUBLE, Double.class);
        cql2Java.put(DataType.Name.FLOAT, Float.class);
        cql2Java.put(DataType.Name.INET, InetAddress.class);
        cql2Java.put(DataType.Name.INT, Integer.class);
        cql2Java.put(DataType.Name.SMALLINT, Short.class);
        cql2Java.put(DataType.Name.TINYINT, Byte.class);
        cql2Java.put(DataType.Name.DATE, LocalDate.class);
        cql2Java.put(DataType.Name.TIME, Long.class);
        cql2Java.put(DataType.Name.TEXT, String.class);
        cql2Java.put(DataType.Name.TIMESTAMP, Date.class);
        cql2Java.put(DataType.Name.UUID, UUID.class);
        cql2Java.put(DataType.Name.VARCHAR, String.class);
        cql2Java.put(DataType.Name.VARINT, BigInteger.class);
        cql2Java.put(DataType.Name.TIMEUUID, UUID.class);
        cql2Java.put(DataType.Name.LIST, List.class);
        cql2Java.put(DataType.Name.SET, Set.class);
        cql2Java.put(DataType.Name.MAP, Map.class);
        cql2Java.put(DataType.Name.CUSTOM, ByteBuffer.class);
        cql2Java.put(DataType.Name.UDT, UDTValue.class);
        cql2Java.put(DataType.Name.TUPLE, TupleValue.class);
        cql2Java.put(DataType.Name.DURATION, Duration.class);
    }
}

