/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.meta;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.annotations.Strategy;
import info.archinnov.achilles.annotations.UDT;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.codegen.meta.CommonBeanMetaCodeGen;
import info.archinnov.achilles.internals.parser.FieldParser;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.EntityParsingContext;
import info.archinnov.achilles.internals.strategy.naming.InternalNamingStrategy;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang3.StringUtils;

public class UDTMetaCodeGen
implements CommonBeanMetaCodeGen {
    private final AptUtils aptUtils;

    public UDTMetaCodeGen(AptUtils aptUtils) {
        this.aptUtils = aptUtils;
    }

    public TypeSpec buildUDTClassProperty(TypeElement elm, EntityParsingContext context, List<FieldParser.FieldMetaSignature> fieldMetaSignatures, List<FieldParser.FieldMetaSignature> customConstructorFieldMetaSignatures) {
        TypeName rawBeanType = TypeName.get((TypeMirror)this.aptUtils.erasure(elm));
        Optional<Strategy> strategy = this.aptUtils.getAnnotationOnClass(elm, Strategy.class);
        String className = elm.getSimpleName() + "_AchillesMeta";
        ClassName classType = ClassName.get((String)"info.archinnov.achilles.generated.meta.udt", (String)className, (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((TypeName)TypeUtils.genericType(TypeUtils.ABSTRACT_UDT_CLASS_PROPERTY, rawBeanType)).addMethod(this.buildGetStaticKeyspace(elm)).addMethod(this.buildGetStaticUDTName(elm)).addMethod(this.buildGetStaticNamingStrategy(strategy)).addMethod(this.buildGetUdtName(elm, context)).addMethod(this.buildGetUdtClass(rawBeanType)).addMethod(this.buildGetParentEntityClass(context)).addMethod(this.buildComponentsProperty(rawBeanType, fieldMetaSignatures)).addMethod(this.buildConstructorInjectedProperties(rawBeanType, customConstructorFieldMetaSignatures)).addMethod(this.buildCreateUDTFromBeanT(rawBeanType, fieldMetaSignatures)).addMethod(this.buildNewInstanceFromCustomConstructor(rawBeanType, customConstructorFieldMetaSignatures));
        for (FieldParser.FieldMetaSignature x : fieldMetaSignatures) {
            builder.addField(x.buildPropertyAsField());
        }
        builder.addField(this.build_INSTANCE_Field((TypeName)classType));
        return builder.build();
    }

    private FieldSpec build_INSTANCE_Field(TypeName classType) {
        return FieldSpec.builder((TypeName)classType, (String)"INSTANCE", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC}).initializer("new $T()", new Object[]{classType}).build();
    }

    private MethodSpec buildGetStaticUDTName(TypeElement elm) {
        UDT udt = this.aptUtils.getAnnotationOnClass(elm, UDT.class).get();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getStaticUdtName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)TypeUtils.genericType(TypeUtils.OPTIONAL, TypeUtils.STRING));
        Optional<String> udtName = Optional.ofNullable(StringUtils.isBlank((CharSequence)udt.name()) ? null : udt.name());
        if (udtName.isPresent()) {
            return builder.addStatement("return $T.of($S)", new Object[]{TypeUtils.OPTIONAL, udtName.get()}).build();
        }
        return this.emptyOption(builder);
    }

    private MethodSpec buildGetUdtName(TypeElement elm, EntityParsingContext context) {
        UDT udt = this.aptUtils.getAnnotationOnClass(elm, UDT.class).get();
        Optional<Strategy> strategy = this.aptUtils.getAnnotationOnClass(elm, Strategy.class);
        String udtName = StringUtils.isBlank((CharSequence)udt.name()) ? InternalNamingStrategy.inferNamingStrategy(strategy, context.namingStrategy).apply(elm.getSimpleName().toString()) : udt.name();
        return MethodSpec.methodBuilder((String)"getUdtName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(String.class).addStatement("return $S", new Object[]{udtName}).build();
    }

    private MethodSpec buildGetStaticKeyspace(TypeElement elm) {
        UDT udt = this.aptUtils.getAnnotationOnClass(elm, UDT.class).get();
        CodeBlock keyspaceCodeBlock = Optional.ofNullable(StringUtils.isBlank((CharSequence)udt.keyspace()) ? null : udt.keyspace()).map(x -> CodeBlock.builder().addStatement("return $T.of($S)", new Object[]{TypeUtils.OPTIONAL, x}).build()).orElseGet(() -> CodeBlock.builder().addStatement("return $T.empty()", new Object[]{TypeUtils.OPTIONAL}).build());
        return MethodSpec.methodBuilder((String)"getStaticKeyspace").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)TypeUtils.genericType(TypeUtils.OPTIONAL, TypeUtils.STRING)).addCode(keyspaceCodeBlock).build();
    }

    private MethodSpec buildGetUdtClass(TypeName rawBeanType) {
        return MethodSpec.methodBuilder((String)"getUdtClass").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)TypeUtils.classTypeOf(rawBeanType)).addStatement("return $T.class", new Object[]{rawBeanType}).build();
    }

    private MethodSpec buildGetParentEntityClass(EntityParsingContext entityParsingContext) {
        return MethodSpec.methodBuilder((String)"getParentEntityClass").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)TypeUtils.genericType(TypeUtils.CLASS, TypeUtils.WILDCARD)).addStatement("return $T.class", new Object[]{entityParsingContext.entityType}).build();
    }

    private MethodSpec buildComponentsProperty(TypeName rawBeanType, List<FieldParser.FieldMetaSignature> parsingResults) {
        ParameterizedTypeName returnType = TypeUtils.genericType(TypeUtils.LIST, new TypeName[]{TypeUtils.genericType(TypeUtils.ABSTRACT_PROPERTY, rawBeanType, TypeUtils.WILDCARD, TypeUtils.WILDCARD)});
        StringJoiner allFields = new StringJoiner(", ");
        parsingResults.stream().map(x -> x.context.fieldName).forEach(x -> allFields.add((CharSequence)x));
        StringBuilder fieldList = new StringBuilder();
        fieldList.append("return $T.asList(").append(allFields.toString()).append(")");
        return MethodSpec.methodBuilder((String)"getComponentsProperty").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)returnType).addStatement(fieldList.toString(), new Object[]{TypeUtils.ARRAYS}).build();
    }

    private MethodSpec buildConstructorInjectedProperties(TypeName rawBeanType, List<FieldParser.FieldMetaSignature> constructorInjectedProperties) {
        ParameterizedTypeName returnType = TypeUtils.genericType(TypeUtils.LIST, new TypeName[]{TypeUtils.genericType(TypeUtils.ABSTRACT_PROPERTY, rawBeanType, TypeUtils.WILDCARD, TypeUtils.WILDCARD)});
        StringJoiner allFields = new StringJoiner(", ");
        constructorInjectedProperties.stream().map(x -> x.context.fieldName).forEach(x -> allFields.add((CharSequence)x));
        StringBuilder fieldList = new StringBuilder();
        fieldList.append("return $T.asList(").append(allFields.toString()).append(")");
        return MethodSpec.methodBuilder((String)"getConstructorInjectedProperty").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)returnType).addStatement(fieldList.toString(), new Object[]{TypeUtils.ARRAYS}).build();
    }

    private MethodSpec buildCreateUDTFromBeanT(TypeName rawBeanType, List<FieldParser.FieldMetaSignature> parsingResults) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"createUDTFromBean").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(rawBeanType, "instance", new Modifier[0]).addParameter(TypeName.BOOLEAN, "frozen", new Modifier[0]).addParameter((TypeName)TypeUtils.genericType(TypeUtils.OPTIONAL, new TypeName[]{TypeUtils.OPTIONS}), "cassandraOptions", new Modifier[0]).returns((TypeName)TypeUtils.JAVA_DRIVER_UDT_VALUE_TYPE).addStatement("final $T dynamicUserType = this.getUserType($N, $N)", new Object[]{TypeUtils.JAVA_DRIVER_USER_TYPE, "frozen", "cassandraOptions"}).addStatement("final $T udtValue = dynamicUserType.newValue()", new Object[]{TypeUtils.JAVA_DRIVER_UDT_VALUE_TYPE});
        for (FieldParser.FieldMetaSignature x : parsingResults) {
            builder.addStatement("$L.encodeFieldToUdt(instance, udtValue, cassandraOptions)", new Object[]{x.context.fieldName});
        }
        builder.addStatement("return udtValue", new Object[0]);
        return builder.build();
    }

    private MethodSpec buildNewInstanceFromCustomConstructor(TypeName rawBeanType, List<FieldParser.FieldMetaSignature> customConstructorFieldMetaSignatures) {
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"newInstanceFromCustomConstructor").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)TypeUtils.JAVA_DRIVER_UDT_VALUE_TYPE, "udtValue", new Modifier[0]).returns(rawBeanType);
        if (customConstructorFieldMetaSignatures.size() > 0) {
            customConstructorFieldMetaSignatures.forEach(field -> methodSpec.addStatement("final $T $L_value = $L.decodeFromGettable(udtValue)", new Object[]{field.sourceType.box(), field.context.fieldName, field.context.fieldName}));
            methodSpec.addStatement(customConstructorFieldMetaSignatures.stream().map(fieldMeta -> fieldMeta.context.fieldName + "_value").collect(Collectors.joining(",", "return new $T(", ")")), new Object[]{rawBeanType});
        } else {
            String errorMessage = "Cannot instantiate entity '" + rawBeanType.toString() + "' using custom constructor because no custom constructor (@EntityCreator) is defined";
            methodSpec.addStatement("throw new $T($S)", new Object[]{TypeName.get(UnsupportedOperationException.class), errorMessage});
        }
        return methodSpec.build();
    }
}

