/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.index;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.internals.codegen.dsl.AbstractDSLCodeGen;
import info.archinnov.achilles.internals.codegen.dsl.BaseSingleColumnRestriction;
import info.archinnov.achilles.internals.codegen.dsl.MultiColumnsSliceRestrictionCodeGen;
import info.archinnov.achilles.internals.codegen.dsl.select.SelectWhereDSLCodeGen;
import info.archinnov.achilles.internals.codegen.meta.EntityMetaCodeGen;
import info.archinnov.achilles.internals.metamodel.index.IndexImpl;
import info.archinnov.achilles.internals.metamodel.index.IndexType;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import info.archinnov.achilles.internals.utils.NamingHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public abstract class IndexSelectWhereDSLCodeGen
extends SelectWhereDSLCodeGen
implements BaseSingleColumnRestriction,
MultiColumnsSliceRestrictionCodeGen {
    public abstract void buildSASIIndexRelation(TypeSpec.Builder var1, EntityMetaCodeGen.EntityMetaSignature var2, String var3, AbstractDSLCodeGen.ClassSignatureInfo var4, AbstractDSLCodeGen.ReturnType var5);

    public abstract void buildDSESearchIndexRelation(TypeSpec.Builder var1, EntityMetaCodeGen.EntityMetaSignature var2, String var3, AbstractDSLCodeGen.ClassSignatureInfo var4, AbstractDSLCodeGen.ReturnType var5);

    @Override
    public List<TypeSpec> buildWhereClasses(GlobalParsingContext context, EntityMetaCodeGen.EntityMetaSignature signature) {
        AbstractDSLCodeGen.ClassSignatureParams classSignatureParams = AbstractDSLCodeGen.ClassSignatureParams.of("_SelectIndex", "W", "E", TypeUtils.ABSTRACT_SELECT_WHERE_PARTITION, TypeUtils.ABSTRACT_INDEX_SELECT_WHERE);
        AbstractDSLCodeGen.ClassSignatureParams typedMapClassSignatureParams = AbstractDSLCodeGen.ClassSignatureParams.of("_SelectIndex", "W_TM", "E_TM", TypeUtils.ABSTRACT_SELECT_WHERE_PARTITION_TYPED_MAP, TypeUtils.ABSTRACT_INDEX_SELECT_WHERE_TYPED_MAP);
        List<TypeSpec> typeSpecs = this.buildWhereClassesInternal(signature, classSignatureParams);
        typeSpecs.addAll(this.buildWhereClassesInternal(signature, typedMapClassSignatureParams));
        typeSpecs.addAll(this.generateExtraWhereClasses(context, signature, this.getPartitionKeysSignatureInfo(signature.fieldMetaSignatures), this.getClusteringColsSignatureInfo(signature.fieldMetaSignatures)));
        return typeSpecs;
    }

    public List<TypeSpec> buildWhereClassesInternal(EntityMetaCodeGen.EntityMetaSignature signature, AbstractDSLCodeGen.ClassSignatureParams classSignatureParams) {
        ArrayList<TypeSpec> typeSpecs = new ArrayList<TypeSpec>();
        String indexSelectWhereClassName = classSignatureParams.whereDslSuffix;
        TypeSpec.Builder indexSelectWhereBuilder = TypeSpec.classBuilder((String)indexSelectWhereClassName).superclass((TypeName)classSignatureParams.abstractWherePartitionType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildWhereConstructorWithOptions(TypeUtils.SELECT_DOT_WHERE));
        String endClassName = signature.endClassName(classSignatureParams.endDslSuffix);
        ClassName endTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)endClassName, (String[])new String[0]);
        ClassName endReturnTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)signature.endReturnType(classSignatureParams.dslSuffix, classSignatureParams.endDslSuffix), (String[])new String[0]);
        ParameterizedTypeName abstractEndType = TypeUtils.genericType(classSignatureParams.abstractWhereType, new TypeName[]{endReturnTypeName, signature.entityRawClass});
        AbstractDSLCodeGen.ClassSignatureInfo lastSignature = AbstractDSLCodeGen.ClassSignatureInfo.of((TypeName)endTypeName, (TypeName)endReturnTypeName, (TypeName)abstractEndType, endClassName, null, null);
        String parentClassName = signature.indexSelectClassName() + "." + classSignatureParams.whereDslSuffix;
        List<AbstractDSLCodeGen.IndexFieldSignatureInfo> nativeIndexCols = this.getIndexedColsSignatureInfo(IndexImpl.NATIVE, signature.fieldMetaSignatures);
        nativeIndexCols.forEach(x -> this.buildNativeIndexRelation(indexSelectWhereBuilder, (AbstractDSLCodeGen.IndexFieldSignatureInfo)x, parentClassName, lastSignature, AbstractDSLCodeGen.ReturnType.NEW));
        this.buildSASIIndexRelation(indexSelectWhereBuilder, signature, parentClassName, lastSignature, AbstractDSLCodeGen.ReturnType.NEW);
        this.buildDSESearchIndexRelation(indexSelectWhereBuilder, signature, parentClassName, lastSignature, AbstractDSLCodeGen.ReturnType.NEW);
        typeSpecs.add(indexSelectWhereBuilder.build());
        typeSpecs.add(this.buildSelectEndClass(signature, lastSignature, classSignatureParams));
        return typeSpecs;
    }

    public TypeSpec buildSelectEndClass(EntityMetaCodeGen.EntityMetaSignature signature, AbstractDSLCodeGen.ClassSignatureInfo lastSignature, AbstractDSLCodeGen.ClassSignatureParams classSignatureParams) {
        Optional<AbstractDSLCodeGen.FieldSignatureInfo> firstClustering = this.getClusteringColsSignatureInfo(signature.fieldMetaSignatures).stream().limit(1L).findFirst();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)lastSignature.className).superclass(lastSignature.superType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildWhereConstructorWithOptions(TypeUtils.SELECT_DOT_WHERE)).addMethod(this.buildGetEntityClass(signature)).addMethod(this.buildGetMetaInternal(signature.entityRawClass)).addMethod(this.buildGetRte()).addMethod(this.buildGetOptions()).addMethod(this.buildGetBoundValuesInternal()).addMethod(this.buildGetEncodedBoundValuesInternal()).addMethod(this.buildLimit(lastSignature)).addMethod(this.buildGetThis(lastSignature.returnClassType));
        this.augmentSelectEndClass(builder, lastSignature);
        List<AbstractDSLCodeGen.FieldSignatureInfo> partitionKeys = this.getPartitionKeysSignatureInfo(signature.fieldMetaSignatures);
        List<AbstractDSLCodeGen.FieldSignatureInfo> clusteringCols = this.getClusteringColsSignatureInfo(signature.fieldMetaSignatures);
        List<AbstractDSLCodeGen.IndexFieldSignatureInfo> nativeIndexCols = this.getIndexedColsSignatureInfo(IndexImpl.NATIVE, signature.fieldMetaSignatures);
        partitionKeys.forEach(x -> this.buildPartitionKeyRelation(builder, signature, (AbstractDSLCodeGen.FieldSignatureInfo)x, lastSignature, classSignatureParams));
        clusteringCols.forEach(x -> this.buildClusteringColumnRelation(builder, signature, (AbstractDSLCodeGen.FieldSignatureInfo)x, lastSignature, classSignatureParams));
        String parentClassName = signature.indexSelectClassName() + "." + classSignatureParams.endDslSuffix;
        nativeIndexCols.forEach(x -> this.buildNativeIndexRelation(builder, (AbstractDSLCodeGen.IndexFieldSignatureInfo)x, parentClassName, lastSignature, AbstractDSLCodeGen.ReturnType.THIS));
        this.buildSASIIndexRelation(builder, signature, parentClassName, lastSignature, AbstractDSLCodeGen.ReturnType.THIS);
        this.buildDSESearchIndexRelation(builder, signature, parentClassName, lastSignature, AbstractDSLCodeGen.ReturnType.THIS);
        this.addMultipleColumnsSliceRestrictions(builder, parentClassName, clusteringCols, lastSignature, AbstractDSLCodeGen.ReturnType.THIS);
        this.maybeBuildOrderingBy(lastSignature, firstClustering, builder);
        return builder.build();
    }

    public void buildNativeIndexRelation(TypeSpec.Builder indexSelectWhereBuilder, AbstractDSLCodeGen.IndexFieldSignatureInfo indexFieldInfo, String parentClassName, AbstractDSLCodeGen.ClassSignatureInfo lastSignature, AbstractDSLCodeGen.ReturnType returnType) {
        String relationClassName = "Indexed_" + NamingHelper.upperCaseFirst(indexFieldInfo.fieldName);
        ClassName relationClassTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(parentClassName + "." + relationClassName), (String[])new String[0]);
        TypeSpec.Builder relationClassBuilder = TypeSpec.classBuilder((String)relationClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        IndexType indexType = indexFieldInfo.indexInfo.type;
        switch (indexType) {
            case COLLECTION: {
                relationClassBuilder.addMethod(this.buildIndexRelationForCollection(indexFieldInfo, lastSignature.returnClassType, returnType));
                break;
            }
            case MAP_KEY: {
                relationClassBuilder.addMethod(this.buildIndexRelationForMapKey(indexFieldInfo, lastSignature.returnClassType, returnType));
                break;
            }
            case MAP_VALUE: {
                relationClassBuilder.addMethod(this.buildIndexRelationForMapValue(indexFieldInfo, lastSignature.returnClassType, returnType));
                break;
            }
            case MAP_ENTRY: {
                relationClassBuilder.addMethod(this.buildIndexRelationForMapEntry(indexFieldInfo, lastSignature.returnClassType, returnType));
                break;
            }
            case FULL: 
            case NORMAL: {
                relationClassBuilder.addMethod(this.buildColumnRelation("eq", lastSignature.returnClassType, indexFieldInfo, returnType));
                break;
            }
        }
        this.augmentRelationClassForWhereClause(relationClassBuilder, indexFieldInfo, lastSignature, returnType);
        indexSelectWhereBuilder.addType(relationClassBuilder.build());
        indexSelectWhereBuilder.addMethod(IndexSelectWhereDSLCodeGen.buildIndexedRelationMethod(indexFieldInfo.fieldName, (TypeName)relationClassTypeName));
    }

    public static MethodSpec buildIndexedRelationMethod(String fieldName, TypeName relationClassTypeName) {
        return MethodSpec.methodBuilder((String)("indexed_" + fieldName)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T()", new Object[]{relationClassTypeName}).returns(relationClassTypeName).build();
    }

    public MethodSpec buildIndexRelationForMapEntry(AbstractDSLCodeGen.IndexFieldSignatureInfo indexFieldInfo, TypeName returnClassType, AbstractDSLCodeGen.ReturnType returnType) {
        String paramKey = indexFieldInfo.fieldName + "_key";
        String paramValue = indexFieldInfo.fieldName + "_value";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"ContainsEntry").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L[?] = ?</strong>", new Object[]{indexFieldInfo.quotedCqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(indexFieldInfo.indexMetaSignature.mapKeyType, paramKey, new Modifier[0]).addParameter(indexFieldInfo.indexMetaSignature.mapValueType, paramValue, new Modifier[0]).addStatement("where.and($T.of($S, $T.bindMarker($S), $T.bindMarker($S)))", new Object[]{TypeUtils.MAP_ENTRY_CLAUSE, indexFieldInfo.quotedCqlColumn, TypeUtils.QUERY_BUILDER, paramKey, TypeUtils.QUERY_BUILDER, paramValue}).addStatement("boundValues.add($N)", new Object[]{paramKey}).addStatement("boundValues.add($N)", new Object[]{paramValue}).addStatement("encodedValues.add(meta.$L.encodeSingleKeyElement($N, $T.of(cassandraOptions)))", new Object[]{indexFieldInfo.fieldName, paramKey, TypeUtils.OPTIONAL}).addStatement("encodedValues.add(meta.$L.encodeSingleValueElement($N, $T.of(cassandraOptions)))", new Object[]{indexFieldInfo.fieldName, paramValue, TypeUtils.OPTIONAL}).returns(returnClassType);
        if (returnType == AbstractDSLCodeGen.ReturnType.THIS) {
            return builder.addStatement("return $T.this", new Object[]{returnClassType}).build();
        }
        return builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{returnClassType}).build();
    }

    protected MethodSpec buildIndexRelationForMapKey(AbstractDSLCodeGen.IndexFieldSignatureInfo indexFieldInfo, TypeName returnClassType, AbstractDSLCodeGen.ReturnType returnType) {
        String param = indexFieldInfo.fieldName + "_key";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"ContainsKey").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L CONTAINS KEY ?</strong>", new Object[]{indexFieldInfo.quotedCqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(indexFieldInfo.indexMetaSignature.mapKeyType, param, new Modifier[0]).addStatement("where.and($T.containsKey($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, indexFieldInfo.quotedCqlColumn, TypeUtils.QUERY_BUILDER, indexFieldInfo.quotedCqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add(meta.$L.encodeSingleKeyElement($N, $T.of(cassandraOptions)))", new Object[]{indexFieldInfo.fieldName, param, TypeUtils.OPTIONAL}).returns(returnClassType);
        if (returnType == AbstractDSLCodeGen.ReturnType.THIS) {
            return builder.addStatement("return $T.this", new Object[]{returnClassType}).build();
        }
        return builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{returnClassType}).build();
    }

    protected MethodSpec buildIndexRelationForMapValue(AbstractDSLCodeGen.IndexFieldSignatureInfo indexFieldInfo, TypeName returnClassType, AbstractDSLCodeGen.ReturnType returnType) {
        String param = indexFieldInfo.fieldName + "_value";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"ContainsValue").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L CONTAINS ?</strong>", new Object[]{indexFieldInfo.quotedCqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(indexFieldInfo.indexMetaSignature.mapValueType, param, new Modifier[0]).addStatement("where.and($T.contains($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, indexFieldInfo.quotedCqlColumn, TypeUtils.QUERY_BUILDER, indexFieldInfo.quotedCqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add(meta.$L.encodeSingleValueElement($N, $T.of(cassandraOptions)))", new Object[]{indexFieldInfo.fieldName, param, TypeUtils.OPTIONAL}).returns(returnClassType);
        if (returnType == AbstractDSLCodeGen.ReturnType.THIS) {
            return builder.addStatement("return $T.this", new Object[]{returnClassType}).build();
        }
        return builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{returnClassType}).build();
    }

    protected MethodSpec buildIndexRelationForCollection(AbstractDSLCodeGen.IndexFieldSignatureInfo indexFieldInfo, TypeName returnClassType, AbstractDSLCodeGen.ReturnType returnType) {
        String param = indexFieldInfo.fieldName + "_element";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"Contains").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L CONTAINS ?</strong>", new Object[]{indexFieldInfo.quotedCqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(indexFieldInfo.indexMetaSignature.collectionElementType, param, new Modifier[0]).addStatement("where.and($T.contains($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, indexFieldInfo.quotedCqlColumn, TypeUtils.QUERY_BUILDER, indexFieldInfo.quotedCqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add(meta.$L.encodeSingleElement($N, $T.of(cassandraOptions)))", new Object[]{indexFieldInfo.fieldName, param, TypeUtils.OPTIONAL}).returns(returnClassType);
        if (returnType == AbstractDSLCodeGen.ReturnType.THIS) {
            return builder.addStatement("return $T.this", new Object[]{returnClassType}).build();
        }
        return builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{returnClassType}).build();
    }

    protected void buildPartitionKeyRelation(TypeSpec.Builder builder, EntityMetaCodeGen.EntityMetaSignature signature, AbstractDSLCodeGen.FieldSignatureInfo partitionInfo, AbstractDSLCodeGen.ClassSignatureInfo lastSignature, AbstractDSLCodeGen.ClassSignatureParams classSignatureParams) {
        String relationClassName = NamingHelper.upperCaseFirst(partitionInfo.fieldName);
        ClassName relationClassTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(signature.indexSelectClassName() + "." + classSignatureParams.endDslSuffix + "." + relationClassName), (String[])new String[0]);
        TypeSpec.Builder relationClassBuilder = TypeSpec.classBuilder((String)relationClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildColumnRelation("eq", lastSignature.returnClassType, partitionInfo, AbstractDSLCodeGen.ReturnType.THIS)).addMethod(this.buildColumnInVarargs(lastSignature.returnClassType, partitionInfo, AbstractDSLCodeGen.ReturnType.THIS));
        this.augmentRelationClassForWhereClause(relationClassBuilder, partitionInfo, lastSignature, AbstractDSLCodeGen.ReturnType.NEW);
        builder.addType(relationClassBuilder.build()).addMethod(IndexSelectWhereDSLCodeGen.buildRelationMethod(partitionInfo.fieldName, (TypeName)relationClassTypeName));
    }

    protected void buildClusteringColumnRelation(TypeSpec.Builder builder, EntityMetaCodeGen.EntityMetaSignature signature, AbstractDSLCodeGen.FieldSignatureInfo clusteringColumnInfo, AbstractDSLCodeGen.ClassSignatureInfo lastSignature, AbstractDSLCodeGen.ClassSignatureParams classSignatureParams) {
        String relationClassName = NamingHelper.upperCaseFirst(clusteringColumnInfo.fieldName);
        ClassName relationClassTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(signature.indexSelectClassName() + "." + classSignatureParams.endDslSuffix + "." + relationClassName), (String[])new String[0]);
        TypeSpec.Builder relationClassBuilder = TypeSpec.classBuilder((String)relationClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildColumnRelation("eq", lastSignature.returnClassType, clusteringColumnInfo, AbstractDSLCodeGen.ReturnType.THIS));
        this.addSingleColumnSliceRestrictions(relationClassBuilder, clusteringColumnInfo, lastSignature, lastSignature, AbstractDSLCodeGen.ReturnType.THIS);
        this.augmentRelationClassForWhereClause(relationClassBuilder, clusteringColumnInfo, lastSignature, AbstractDSLCodeGen.ReturnType.NEW);
        builder.addType(relationClassBuilder.build()).addMethod(IndexSelectWhereDSLCodeGen.buildRelationMethod(clusteringColumnInfo.fieldName, (TypeName)relationClassTypeName));
    }
}

