/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.index;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.internals.codegen.dsl.AbstractDSLCodeGen;
import info.archinnov.achilles.internals.codegen.meta.EntityMetaCodeGen;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.DSESearchInfoContext;
import info.archinnov.achilles.internals.utils.NamingHelper;
import java.util.List;
import javax.lang.model.element.Modifier;

public interface DSESearchSupport {
    default public void buildDSESearchIndexRelation(EntityMetaCodeGen.EntityMetaSignature signature, TypeSpec.Builder indexSelectWhereBuilder, AugmentRelationClassForWhereClauseLambda augmentRelationClassForWhereClauseLambda, String parentClassName, AbstractDSLCodeGen.ClassSignatureInfo lastSignature, AbstractDSLCodeGen.ReturnType returnType) {
        List<AbstractDSLCodeGen.IndexFieldSignatureInfo> dseSearchColumns = AbstractDSLCodeGen.getDSESearchColsSignatureInfo(signature.fieldMetaSignatures);
        dseSearchColumns.forEach(fieldInfo -> {
            String relationClassName = "Indexed_" + NamingHelper.upperCaseFirst(fieldInfo.fieldName);
            ClassName relationClassTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(parentClassName + "." + relationClassName), (String[])new String[0]);
            TypeSpec.Builder relationClassBuilder = TypeSpec.classBuilder((String)relationClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            TypeName targetType = fieldInfo.typeName;
            DSESearchInfoContext dseSearchInfoContext = fieldInfo.indexInfo.dseSearchInfoContext.get();
            if (targetType.equals((Object)TypeUtils.STRING)) {
                if (dseSearchInfoContext.fullTextSearchEnabled) {
                    relationClassBuilder.addMethod(this.buildDSETextStartWith(lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                    relationClassBuilder.addMethod(this.buildDSETextEndWith(lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                    relationClassBuilder.addMethod(this.buildDSETextContains(lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                }
                relationClassBuilder.addMethod(this.buildDSESingleRelation("eq", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
            } else if (targetType.equals((Object)TypeUtils.JAVA_UTIL_DATE)) {
                relationClassBuilder.addMethod(this.buildDSESingleDateRelation("eq", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSESingleDateRelation("gt", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSESingleDateRelation("gte", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSESingleDateRelation("lt", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSESingleDateRelation("lte", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSEDoubleDateRelation("gt", "lt", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSEDoubleDateRelation("gt", "lte", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSEDoubleDateRelation("gte", "lt", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSEDoubleDateRelation("gte", "lte", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
            } else {
                relationClassBuilder.addMethod(this.buildDSESingleRelation("eq", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSESingleRelation("gt", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSESingleRelation("gte", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSESingleRelation("lt", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSESingleRelation("lte", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSEDoubleRelation("gt", "lt", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSEDoubleRelation("gt", "lte", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSEDoubleRelation("gte", "lt", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
                relationClassBuilder.addMethod(this.buildDSEDoubleRelation("gte", "lte", lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
            }
            relationClassBuilder.addMethod(this.buildDSERawPredicate(lastSignature.returnClassType, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, returnType));
            augmentRelationClassForWhereClauseLambda.augmentRelationClassForWhereClause(relationClassBuilder, (AbstractDSLCodeGen.FieldSignatureInfo)fieldInfo, lastSignature, returnType);
            indexSelectWhereBuilder.addType(relationClassBuilder.build());
            indexSelectWhereBuilder.addMethod(DSESearchSupport.buildSearchRelationMethod(fieldInfo.fieldName, (TypeName)relationClassTypeName));
        });
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            indexSelectWhereBuilder.addMethod(this.buildDSERawSolrQuery(lastSignature.returnClassType));
        }
    }

    default public MethodSpec buildDSETextStartWith(TypeName nextType, AbstractDSLCodeGen.FieldSignatureInfo fieldInfo, AbstractDSLCodeGen.ReturnType returnType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"StartWith").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>solr_query='$L:?*'</strong>", new Object[]{fieldInfo.quotedCqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.STRING, fieldInfo.fieldName, new Modifier[0]).beginControlFlow("if(!cassandraOptions.hasSolrQuery())", new Object[0]).addStatement("where.and($T.eq($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, "solr_query", TypeUtils.QUERY_BUILDER, "solr_query"}).endControlFlow().addStatement("cassandraOptions.appendToSolrQuery($S + $N + $S)", new Object[]{fieldInfo.quotedCqlColumn + ":", fieldInfo.fieldName, "*"}).returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }

    default public MethodSpec buildDSETextEndWith(TypeName nextType, AbstractDSLCodeGen.FieldSignatureInfo fieldInfo, AbstractDSLCodeGen.ReturnType returnType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"EndWith").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>solr_query='$L:*?'</strong>", new Object[]{fieldInfo.quotedCqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.STRING, fieldInfo.fieldName, new Modifier[0]).beginControlFlow("if(!cassandraOptions.hasSolrQuery())", new Object[0]).addStatement("where.and($T.eq($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, "solr_query", TypeUtils.QUERY_BUILDER, "solr_query"}).endControlFlow().addStatement("cassandraOptions.appendToSolrQuery($S + $N)", new Object[]{fieldInfo.quotedCqlColumn + ":*", fieldInfo.fieldName}).returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }

    default public MethodSpec buildDSETextContains(TypeName nextType, AbstractDSLCodeGen.FieldSignatureInfo fieldInfo, AbstractDSLCodeGen.ReturnType returnType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"Contains").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>solr_query='$L:*?*'</strong>", new Object[]{fieldInfo.quotedCqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.STRING, fieldInfo.fieldName, new Modifier[0]).beginControlFlow("if(!cassandraOptions.hasSolrQuery())", new Object[0]).addStatement("where.and($T.eq($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, "solr_query", TypeUtils.QUERY_BUILDER, "solr_query"}).endControlFlow().addStatement("cassandraOptions.appendToSolrQuery($S + $N + $S)", new Object[]{fieldInfo.quotedCqlColumn + ":*", fieldInfo.fieldName, "*"}).returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }

    default public MethodSpec buildDSESingleRelation(String relation, TypeName nextType, AbstractDSLCodeGen.FieldSignatureInfo fieldInfo, AbstractDSLCodeGen.ReturnType returnType) {
        String param = fieldInfo.fieldName;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)NamingHelper.upperCaseFirst(relation)).addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>solr_query='$L:$S'</strong>", new Object[]{fieldInfo.quotedCqlColumn, this.relationToSolrSyntaxForJavadoc(relation)}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(fieldInfo.typeName, param, new Modifier[0]).beginControlFlow("if(!cassandraOptions.hasSolrQuery())", new Object[0]).addStatement("where.and($T.eq($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, "solr_query", TypeUtils.QUERY_BUILDER, "solr_query"}).endControlFlow().addStatement("cassandraOptions.appendToSolrQuery($T.format($S, $S, meta.$L.encodeFromJava($N, $T.of(cassandraOptions))))", new Object[]{TypeUtils.STRING, this.relationToSolrSyntaxForQuery(relation), fieldInfo.quotedCqlColumn, fieldInfo.fieldName, param, TypeUtils.OPTIONAL}).returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }

    default public MethodSpec buildDSESingleDateRelation(String relation, TypeName nextType, AbstractDSLCodeGen.FieldSignatureInfo fieldInfo, AbstractDSLCodeGen.ReturnType returnType) {
        String param = fieldInfo.fieldName;
        String queryString = relation.equals("eq") ? "%s:\"%s\"" : this.relationToSolrSyntaxForQuery(relation);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)NamingHelper.upperCaseFirst(relation)).addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>solr_query='$L:$S'</strong>", new Object[]{fieldInfo.quotedCqlColumn, this.relationToSolrSyntaxForJavadoc(relation)}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(fieldInfo.typeName, param, new Modifier[0]).addStatement("$T dateFormat = new $T($T.SOLR_DATE_FORMAT)", new Object[]{TypeUtils.SIMPLE_DATE_FORMAT, TypeUtils.SIMPLE_DATE_FORMAT, TypeUtils.DSE_SEARCH_ANNOT}).beginControlFlow("if(!cassandraOptions.hasSolrQuery())", new Object[0]).addStatement("where.and($T.eq($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, "solr_query", TypeUtils.QUERY_BUILDER, "solr_query"}).endControlFlow().addStatement("cassandraOptions.appendToSolrQuery($T.format($S, $S, dateFormat.format(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))))", new Object[]{TypeUtils.STRING, queryString, fieldInfo.quotedCqlColumn, fieldInfo.fieldName, param, TypeUtils.OPTIONAL}).returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }

    default public MethodSpec buildDSEDoubleRelation(String relation1, String relation2, TypeName nextType, AbstractDSLCodeGen.FieldSignatureInfo fieldInfo, AbstractDSLCodeGen.ReturnType returnType) {
        String param1 = fieldInfo.fieldName + "_" + relation1;
        String param2 = fieldInfo.fieldName + "_" + relation2;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(NamingHelper.upperCaseFirst(relation1) + "_And_" + NamingHelper.upperCaseFirst(relation2))).addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>solr_query='$L:$S'</strong>", new Object[]{fieldInfo.quotedCqlColumn, this.relationToSolrSyntaxForJavadoc(relation1, relation2)}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(fieldInfo.typeName, param1, new Modifier[0]).addParameter(fieldInfo.typeName, param2, new Modifier[0]).beginControlFlow("if(!cassandraOptions.hasSolrQuery())", new Object[0]).addStatement("where.and($T.eq($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, "solr_query", TypeUtils.QUERY_BUILDER, "solr_query"}).endControlFlow().addStatement("cassandraOptions.appendToSolrQuery($T.format($S, $S, meta.$L.encodeFromJava($N, $T.of(cassandraOptions)), meta.$L.encodeFromJava($N, $T.of(cassandraOptions))))", new Object[]{TypeUtils.STRING, this.relationToSolrSyntaxForQuery(relation1, relation2), fieldInfo.quotedCqlColumn, fieldInfo.fieldName, param1, TypeUtils.OPTIONAL, fieldInfo.fieldName, param2, TypeUtils.OPTIONAL}).returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }

    default public MethodSpec buildDSEDoubleDateRelation(String relation1, String relation2, TypeName nextType, AbstractDSLCodeGen.FieldSignatureInfo fieldInfo, AbstractDSLCodeGen.ReturnType returnType) {
        String param1 = fieldInfo.fieldName + "_" + relation1;
        String param2 = fieldInfo.fieldName + "_" + relation2;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(NamingHelper.upperCaseFirst(relation1) + "_And_" + NamingHelper.upperCaseFirst(relation2))).addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>solr_query='$L:$S'</strong>", new Object[]{fieldInfo.quotedCqlColumn, this.relationToSolrSyntaxForJavadoc(relation1, relation2)}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(fieldInfo.typeName, param1, new Modifier[0]).addParameter(fieldInfo.typeName, param2, new Modifier[0]).addStatement("$T dateFormat = new $T($T.SOLR_DATE_FORMAT)", new Object[]{TypeUtils.SIMPLE_DATE_FORMAT, TypeUtils.SIMPLE_DATE_FORMAT, TypeUtils.DSE_SEARCH_ANNOT}).beginControlFlow("if(!cassandraOptions.hasSolrQuery())", new Object[0]).addStatement("where.and($T.eq($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, "solr_query", TypeUtils.QUERY_BUILDER, "solr_query"}).endControlFlow().addStatement("cassandraOptions.appendToSolrQuery($T.format($S, $S, dateFormat.format(meta.$L.encodeFromJava($N, $T.of(cassandraOptions))), dateFormat.format(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))))", new Object[]{TypeUtils.STRING, this.relationToSolrSyntaxForQuery(relation1, relation2), fieldInfo.quotedCqlColumn, fieldInfo.fieldName, param1, TypeUtils.OPTIONAL, fieldInfo.fieldName, param2, TypeUtils.OPTIONAL}).returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }

    default public MethodSpec buildDSERawPredicate(TypeName nextType, AbstractDSLCodeGen.FieldSignatureInfo fieldInfo, AbstractDSLCodeGen.ReturnType returnType) {
        String param = "rawSolrPredicate";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"RawPredicate").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>solr_query='$L:?'</strong>", new Object[]{fieldInfo.quotedCqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.STRING, "rawSolrPredicate", new Modifier[0]).beginControlFlow("if(!cassandraOptions.hasSolrQuery())", new Object[0]).addStatement("where.and($T.eq($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, "solr_query", TypeUtils.QUERY_BUILDER, "solr_query"}).endControlFlow().addStatement("cassandraOptions.appendToSolrQuery($T.format($S, $S, $N))", new Object[]{TypeUtils.STRING, "%s:%s", fieldInfo.quotedCqlColumn, "rawSolrPredicate"}).returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }

    default public MethodSpec buildDSERawSolrQuery(TypeName nextType) {
        String param = "solr_query";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"rawSolrQuery").addJavadoc("Inject a raw Solr query string for DSE Search. Example <em>...where().RawSolrQuery(\"(firstname:John* OR lastname:John*) AND age:[30 TO 40]\").getList();</em>", new Object[0]).addJavadoc("<br/>", new Object[0]).addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>solr_query='?'</strong>", new Object[0]).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.STRING, "solr_query", new Modifier[0]).beginControlFlow("if(!cassandraOptions.hasSolrQuery())", new Object[0]).addStatement("where.and($T.eq($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, "solr_query", TypeUtils.QUERY_BUILDER, "solr_query"}).endControlFlow().addStatement("cassandraOptions.rawSolrQuery($N)", new Object[]{"solr_query"}).returns(nextType);
        builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        return builder.build();
    }

    default public String relationToSolrSyntaxForJavadoc(String relation) {
        switch (relation) {
            case "eq": {
                return "?";
            }
            case "lt": {
                return "[* TO ?}";
            }
            case "lte": {
                return "[* TO ?]";
            }
            case "gt": {
                return "{? TO *]";
            }
            case "gte": {
                return "[? TO *]";
            }
        }
        return " ??? ";
    }

    default public String relationToSolrSyntaxForJavadoc(String relation1, String relation2) {
        if (relation1.equals("gt") && relation2.equals("lt")) {
            return "{? TO ?}";
        }
        if (relation1.equals("gt") && relation2.equals("lte")) {
            return "{? TO ?]";
        }
        if (relation1.equals("gte") && relation2.equals("lt")) {
            return "[? TO ?}";
        }
        if (relation1.equals("gte") && relation2.equals("lte")) {
            return "[? TO ?]";
        }
        return "???";
    }

    default public String relationToSolrSyntaxForQuery(String relation) {
        switch (relation) {
            case "eq": {
                return "%s:%s";
            }
            case "lt": {
                return "%s:[* TO %s}";
            }
            case "lte": {
                return "%s:[* TO %s]";
            }
            case "gt": {
                return "%s:{%s TO *]";
            }
            case "gte": {
                return "%s:[%s TO *]";
            }
        }
        return " ??? ";
    }

    default public String relationToSolrSyntaxForQuery(String relation1, String relation2) {
        if (relation1.equals("gt") && relation2.equals("lt")) {
            return "%s:{%s TO %s}";
        }
        if (relation1.equals("gt") && relation2.equals("lte")) {
            return "%s:{%s TO %s]";
        }
        if (relation1.equals("gte") && relation2.equals("lt")) {
            return "%s:[%s TO %s}";
        }
        if (relation1.equals("gte") && relation2.equals("lte")) {
            return "%s:[%s TO %s]";
        }
        return "???";
    }

    public static MethodSpec buildSearchRelationMethod(String fieldName, TypeName relationClassTypeName) {
        return MethodSpec.methodBuilder((String)("search_on_" + fieldName)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T()", new Object[]{relationClassTypeName}).returns(relationClassTypeName).build();
    }

    @FunctionalInterface
    public static interface AugmentRelationClassForWhereClauseLambda {
        public void augmentRelationClassForWhereClause(TypeSpec.Builder var1, AbstractDSLCodeGen.FieldSignatureInfo var2, AbstractDSLCodeGen.ClassSignatureInfo var3, AbstractDSLCodeGen.ReturnType var4);
    }
}

