/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.function.cassandra3_2;

import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.internals.codegen.function.InternalSystemFunctionRegistry;
import info.archinnov.achilles.internals.codegen.function.cassandra2_2.FunctionsRegistryCodeGen2_2;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.FunctionSignature;
import info.archinnov.achilles.internals.utils.NamingHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public class FunctionsRegistryCodeGen3_2
extends FunctionsRegistryCodeGen2_2 {
    @Override
    public TypeSpec generateFunctionsRegistryClass(String className, List<FunctionSignature> functionSignatures) {
        ArrayList<FunctionSignature> copyOfFunctionSignatures = new ArrayList<FunctionSignature>(functionSignatures);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
        if (className.equals("SystemFunctions")) {
            this.addNewSystemFunctions(copyOfFunctionSignatures);
            builder.addJavadoc("This class is the common registry for all system functions", new Object[0]);
            this.buildAcceptAllMethodsForSystemFunction().forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        } else {
            builder.addJavadoc("This class is the common registry for all registered user-defined functions", new Object[0]);
        }
        copyOfFunctionSignatures.forEach(signature -> builder.addMethod(super.buildMethodForFunction((FunctionSignature)signature)));
        return builder.build();
    }

    private void addNewSystemFunctions(List<FunctionSignature> functionSignatures) {
        InternalSystemFunctionRegistry.NUMERIC_TYPES.stream().forEach(targetType -> {
            String name = NamingHelper.upperCaseFirst(targetType.toString().replaceAll(InternalSystemFunctionRegistry.FQCN_PATTERN, "$1".intern()));
            InternalSystemFunctionRegistry.NUMERIC_TYPES.stream().filter(x -> !x.equals(targetType)).forEach(sourceType -> {
                String targetCQLDataType = TypeUtils.DRIVER_TYPES_FUNCTION_PARAM_MAPPING.get(targetType);
                FunctionSignature.FunctionParamSignature returnTypeSignature = new FunctionSignature.FunctionParamSignature("returnType", (TypeName)targetType, (TypeName)targetType, targetCQLDataType);
                functionSignatures.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "cast", "castAs" + name, returnTypeSignature, Arrays.asList(new FunctionSignature.FunctionParamSignature("input", (TypeName)sourceType, (TypeName)sourceType, targetCQLDataType))));
            });
            String targetCQLDataType = TypeUtils.DRIVER_TYPES_FUNCTION_PARAM_MAPPING.get(targetType);
            functionSignatures.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "cast", "castAsText", new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.STRING, TypeUtils.STRING, "text"), Arrays.asList(new FunctionSignature.FunctionParamSignature("input", (TypeName)targetType, (TypeName)targetType, targetCQLDataType))));
        });
        FunctionSignature.FunctionParamSignature stringReturnSignature = new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.STRING, TypeUtils.STRING, "text");
        FunctionSignature.FunctionParamSignature timestampReturnSignature = new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.JAVA_UTIL_DATE, TypeUtils.JAVA_UTIL_DATE, "timestamp");
        FunctionSignature.FunctionParamSignature dateReturnSignature = new FunctionSignature.FunctionParamSignature("returnType", TypeUtils.JAVA_DRIVER_LOCAL_DATE, TypeUtils.JAVA_DRIVER_LOCAL_DATE, "date");
        FunctionSignature.FunctionParamSignature timestampInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.JAVA_UTIL_DATE, TypeUtils.JAVA_UTIL_DATE, "timestamp");
        FunctionSignature.FunctionParamSignature uuidInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.UUID, TypeUtils.UUID, "uuid");
        FunctionSignature.FunctionParamSignature timeUuidInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.UUID, TypeUtils.UUID, "timeuuid");
        FunctionSignature.FunctionParamSignature dateInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.JAVA_DRIVER_LOCAL_DATE, TypeUtils.JAVA_DRIVER_LOCAL_DATE, "date");
        FunctionSignature.FunctionParamSignature inetInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.INET_ADDRESS, TypeUtils.INET_ADDRESS, "inet");
        FunctionSignature.FunctionParamSignature booleanInput = new FunctionSignature.FunctionParamSignature("input", TypeUtils.OBJECT_BOOLEAN, TypeUtils.OBJECT_BOOLEAN, "boolean");
        functionSignatures.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "cast", "castAsText", stringReturnSignature, Arrays.asList(booleanInput)));
        functionSignatures.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "cast", "castAsText", stringReturnSignature, Arrays.asList(inetInput)));
        functionSignatures.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "cast", "castAsText", stringReturnSignature, Arrays.asList(uuidInput)));
        functionSignatures.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "cast", "castAsText", stringReturnSignature, Arrays.asList(timestampInput)));
        functionSignatures.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "cast", "castAsText", stringReturnSignature, Arrays.asList(dateInput)));
        functionSignatures.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "cast", "castAsTimestamp", timestampReturnSignature, Arrays.asList(timestampInput)));
        functionSignatures.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "cast", "castAsTimestamp", timestampReturnSignature, Arrays.asList(timeUuidInput)));
        functionSignatures.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "cast", "castAsDate", dateReturnSignature, Arrays.asList(timestampInput)));
        functionSignatures.add(new FunctionSignature(Optional.empty(), TypeUtils.SYSTEM_FUNCTION_REGISTRY, "cast", "castAsDate", dateReturnSignature, Arrays.asList(timeUuidInput)));
    }
}

