/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.dsl.update;

import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.codegen.dsl.AbstractDSLCodeGen;
import info.archinnov.achilles.internals.codegen.dsl.update.UpdateWhereDSLCodeGen;
import info.archinnov.achilles.internals.codegen.meta.EntityMetaCodeGen;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.metamodel.columns.PartitionKeyInfo;
import info.archinnov.achilles.internals.parser.FieldParser;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public abstract class UpdateDSLCodeGen
extends AbstractDSLCodeGen {
    public static final Comparator<Tuple2<String, PartitionKeyInfo>> PARTITION_KEY_SORTER = (o1, o2) -> ((PartitionKeyInfo)o1._2()).order.compareTo(((PartitionKeyInfo)o2._2()).order);

    protected abstract void augmentUpdateRelationClass(ParentSignature var1, FieldParser.FieldMetaSignature var2, TypeName var3, AbstractDSLCodeGen.ReturnType var4);

    public TypeSpec buildUpdateClass(AptUtils aptUtils, EntityMetaCodeGen.EntityMetaSignature signature, UpdateWhereDSLCodeGen updateWhereDSLCodeGen) {
        String firstPartitionKey = signature.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.PARTITION).map(x -> Tuple2.of((Object)x.context.fieldName, (Object)((PartitionKeyInfo)x.context.columnInfo))).sorted(PARTITION_KEY_SORTER).map(Tuple2::_1).findFirst().get();
        String updateClassName = signature.updateClassName();
        ClassName updateFromTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)signature.updateFromReturnType(), (String[])new String[0]);
        ClassName updateColumnsTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)signature.updateColumnsReturnType(), (String[])new String[0]);
        ClassName updateWhereTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)signature.updateWhereReturnType(firstPartitionKey), (String[])new String[0]);
        List<ColumnType> candidateColumns = Arrays.asList(ColumnType.NORMAL, ColumnType.STATIC, ColumnType.COUNTER, ColumnType.STATIC_COUNTER);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)updateClassName).superclass((TypeName)TypeUtils.ABSTRACT_UPDATE).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildUpdateConstructor(signature)).addField(this.buildExactEntityMetaField(signature)).addField(this.buildEntityClassField(signature)).addMethod(this.buildFromBaseTableMethod((TypeName)updateFromTypeName)).addMethod(this.buildFromSchemaProviderMethod((TypeName)updateFromTypeName)).addType(this.buildUpdateColumns(aptUtils, signature, "Cols", (TypeName)updateColumnsTypeName, (TypeName)updateWhereTypeName, candidateColumns)).addType(this.buildUpdateFrom(aptUtils, signature, "F", (TypeName)updateColumnsTypeName, candidateColumns));
        updateWhereDSLCodeGen.buildWhereClasses(signature).forEach(arg_0 -> ((TypeSpec.Builder)builder).addType(arg_0));
        return builder.build();
    }

    public TypeSpec buildUpdateStaticClass(AptUtils aptUtils, EntityMetaCodeGen.EntityMetaSignature signature, UpdateWhereDSLCodeGen updateWhereDSLCodeGen) {
        String firstPartitionKey = signature.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.PARTITION).map(x -> Tuple2.of((Object)x.context.fieldName, (Object)((PartitionKeyInfo)x.context.columnInfo))).sorted(PARTITION_KEY_SORTER).map(Tuple2::_1).findFirst().get();
        String updateStaticClassName = signature.updateStaticClassName();
        ClassName updateStaticFromTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)signature.updateStaticFromReturnType(), (String[])new String[0]);
        ClassName updateStaticColumnsTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)signature.updateStaticColumnsReturnType(), (String[])new String[0]);
        ClassName updateStaticWhereTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)signature.updateStaticWhereReturnType(firstPartitionKey), (String[])new String[0]);
        List<ColumnType> candidateColumns = Arrays.asList(ColumnType.STATIC, ColumnType.STATIC_COUNTER);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)updateStaticClassName).superclass((TypeName)TypeUtils.ABSTRACT_UPDATE).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildUpdateConstructor(signature)).addField(this.buildExactEntityMetaField(signature)).addField(this.buildEntityClassField(signature)).addMethod(this.buildFromBaseTableMethod((TypeName)updateStaticFromTypeName)).addMethod(this.buildFromSchemaProviderMethod((TypeName)updateStaticFromTypeName)).addType(this.buildUpdateColumns(aptUtils, signature, "Cols", (TypeName)updateStaticColumnsTypeName, (TypeName)updateStaticWhereTypeName, candidateColumns)).addType(this.buildUpdateFrom(aptUtils, signature, "F", (TypeName)updateStaticColumnsTypeName, candidateColumns));
        updateWhereDSLCodeGen.buildWhereClassesForStatic(signature).forEach(arg_0 -> ((TypeSpec.Builder)builder).addType(arg_0));
        return builder.build();
    }

    public MethodSpec buildUpdateConstructor(EntityMetaCodeGen.EntityMetaSignature signature) {
        String metaClassName = signature.className + "_AchillesMeta";
        ClassName metaClassType = ClassName.get((String)"info.archinnov.achilles.generated.meta.entity", (String)metaClassName, (String[])new String[0]);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeUtils.RUNTIME_ENGINE, "rte", new Modifier[0]).addParameter((TypeName)metaClassType, "meta", new Modifier[0]).addStatement("super(rte)", new Object[0]).addStatement("this.meta = meta", new Object[0]).build();
    }

    public MethodSpec buildFromSchemaProviderMethod(TypeName updateFromTypeName) {
        return MethodSpec.methodBuilder((String)"from").addJavadoc("Generate an UPDATE <strong>FROM</strong> ... using the given SchemaNameProvider", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)TypeUtils.SCHEMA_NAME_PROVIDER, "schemaNameProvider", new Modifier[]{Modifier.FINAL}).addStatement("final String currentKeyspace = lookupKeyspace(schemaNameProvider, meta.entityClass)", new Object[0]).addStatement("final String currentTable = lookupTable(schemaNameProvider, meta.entityClass)", new Object[0]).addStatement("final $T where = $T.update(currentKeyspace, currentTable).where()", new Object[]{TypeUtils.UPDATE_DOT_WHERE, TypeUtils.QUERY_BUILDER}).addStatement("return new $T(where, $T.withSchemaNameProvider(schemaNameProvider))", new Object[]{updateFromTypeName, TypeUtils.OPTIONS}).returns(updateFromTypeName).build();
    }

    public MethodSpec buildFromBaseTableMethod(TypeName updateFromTypeName) {
        return MethodSpec.methodBuilder((String)"fromBaseTable").addJavadoc("Generate an UPDATE <strong>FROM</strong> ...", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("final String currentKeyspace = meta.getKeyspace().orElse($S + meta.entityClass.getCanonicalName())", new Object[]{"unknown_keyspace_for_"}).addStatement("final $T where = $T.update(currentKeyspace, meta.getTableOrViewName()).where()", new Object[]{TypeUtils.UPDATE_DOT_WHERE, TypeUtils.QUERY_BUILDER}).addStatement("return new $T(where, new $T())", new Object[]{updateFromTypeName, TypeUtils.OPTIONS}).returns(updateFromTypeName).build();
    }

    public TypeSpec buildUpdateFrom(AptUtils aptUtils, EntityMetaCodeGen.EntityMetaSignature signature, String updateFromClassName, TypeName updateColumnsTypeName, List<ColumnType> candidateColumns) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)updateFromClassName).superclass((TypeName)TypeUtils.ABSTRACT_UPDATE_FROM).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(MethodSpec.constructorBuilder().addParameter(TypeUtils.UPDATE_DOT_WHERE, "where", new Modifier[0]).addParameter((TypeName)TypeUtils.OPTIONS, "cassandraOptions", new Modifier[0]).addStatement("super(where, cassandraOptions)", new Object[0]).build());
        signature.fieldMetaSignatures.stream().filter(x -> candidateColumns.contains((Object)x.context.columnType)).forEach(x -> this.buildUpdateColumnMethods(ParentSignature.of(aptUtils, builder, updateFromClassName, Optional.empty(), Optional.empty()), updateColumnsTypeName, (FieldParser.FieldMetaSignature)x, AbstractDSLCodeGen.ReturnType.NEW));
        return builder.build();
    }

    public TypeSpec buildUpdateColumns(AptUtils aptUtils, EntityMetaCodeGen.EntityMetaSignature signature, String updateColumnsClassName, TypeName updateColumnsTypeName, TypeName updateWhereTypeName, List<ColumnType> candidateColumns) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)updateColumnsClassName).superclass((TypeName)TypeUtils.ABSTRACT_UPDATE_COLUMNS).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(MethodSpec.constructorBuilder().addParameter(TypeUtils.UPDATE_DOT_WHERE, "where", new Modifier[0]).addParameter((TypeName)TypeUtils.OPTIONS, "cassandraOptions", new Modifier[0]).addStatement("super(where, cassandraOptions)", new Object[0]).build());
        signature.fieldMetaSignatures.stream().filter(x -> candidateColumns.contains((Object)x.context.columnType)).forEach(x -> this.buildUpdateColumnMethods(ParentSignature.of(aptUtils, builder, updateColumnsClassName, Optional.empty(), Optional.empty()), updateColumnsTypeName, (FieldParser.FieldMetaSignature)x, AbstractDSLCodeGen.ReturnType.THIS));
        builder.addMethod(MethodSpec.methodBuilder((String)"where").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T(where, cassandraOptions)", new Object[]{updateWhereTypeName}).returns(updateWhereTypeName).build());
        return builder.build();
    }

    public void buildUpdateColumnMethods(ParentSignature parentSignature, TypeName nextTypeName, FieldParser.FieldMetaSignature fieldMeta, AbstractDSLCodeGen.ReturnType returnType) {
        boolean isCounterColumn;
        ColumnType columnType = fieldMeta.context.columnType;
        boolean bl = isCounterColumn = columnType == ColumnType.COUNTER || columnType == ColumnType.STATIC_COUNTER;
        if (fieldMeta.isList()) {
            this.buildMethodsForListUpdate(parentSignature, nextTypeName, fieldMeta, returnType);
        } else if (fieldMeta.isSet()) {
            this.buildMethodsForSetUpdate(parentSignature, nextTypeName, fieldMeta, returnType);
        } else if (fieldMeta.isMap()) {
            this.buildMethodsForMapUpdate(parentSignature, nextTypeName, fieldMeta, returnType);
        } else if (isCounterColumn) {
            this.buildMethodsForCounterUpdate(parentSignature, nextTypeName, fieldMeta, returnType);
        } else {
            this.buildMethodForSimpleUpdate(parentSignature, nextTypeName, fieldMeta, returnType);
        }
    }

    public void buildMethodForSimpleUpdate(ParentSignature parentSignature, TypeName newTypeName, FieldParser.FieldMetaSignature parsingResult, AbstractDSLCodeGen.ReturnType returnType) {
        String fieldName = parentSignature.parentFieldName.map(x -> String.format("%s.udtClassProperty.%s", x, parsingResult.context.fieldName)).orElse(parsingResult.context.fieldName);
        String param = parentSignature.parentFieldName.map(x -> x + "_" + parsingResult.context.fieldName).orElse(parsingResult.context.fieldName);
        String cqlColumn = parentSignature.parentQuotedCQLColumn.map(x -> x + "." + parsingResult.context.quotedCqlColumn).orElse(parsingResult.context.quotedCqlColumn);
        TypeName sourceType = parsingResult.sourceType;
        QueryBuilder.update((String)"").with().and(QueryBuilder.set((String)"", (Object)""));
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"Set").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = ?</strong>", new Object[]{cqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(sourceType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.of($S, $T.bindMarker($S)))", new Object[]{TypeUtils.NON_ESCAPING_ASSIGNMENT, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
        } else {
            builder.addStatement("return $T.this", new Object[]{newTypeName});
        }
        this.createRelationClassForColumn(parentSignature, parsingResult, newTypeName, returnType, Arrays.asList(builder.build()));
    }

    public void buildMethodsForListUpdate(ParentSignature parentSignature, TypeName newTypeName, FieldParser.FieldMetaSignature fieldMetaSignature, AbstractDSLCodeGen.ReturnType returnType) {
        String fieldName = parentSignature.parentFieldName.map(x -> String.format("%s.udtClassProperty.%s", x, fieldMetaSignature.context.fieldName)).orElse(fieldMetaSignature.context.fieldName);
        String param = parentSignature.parentFieldName.map(x -> x + "_" + fieldMetaSignature.context.fieldName + "_element").orElse(fieldMetaSignature.context.fieldName + "_element");
        String cqlColumn = parentSignature.parentQuotedCQLColumn.map(x -> x + "." + fieldMetaSignature.context.quotedCqlColumn).orElse(fieldMetaSignature.context.quotedCqlColumn);
        TypeName sourceType = fieldMetaSignature.sourceType;
        TypeName nestedType = parentSignature.aptUtils.extractTypeArgument(sourceType, 0);
        ArrayList<MethodSpec> updateMethods = new ArrayList<MethodSpec>();
        MethodSpec.Builder appendTo = MethodSpec.methodBuilder((String)"AppendTo").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = $L + [?]</strong>", new Object[]{cqlColumn, cqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(nestedType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.appendAll($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($T.asList($N))", new Object[]{TypeUtils.ARRAYS, param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($T.asList($N), $T.of(cassandraOptions)))", new Object[]{fieldName, TypeUtils.ARRAYS, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        MethodSpec.Builder appendAllTo = MethodSpec.methodBuilder((String)"AppendAllTo").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = $L + ?</strong>", new Object[]{fieldName, fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(sourceType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.appendAll($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        MethodSpec.Builder prependTo = MethodSpec.methodBuilder((String)"PrependTo").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = [?] + $L</strong>", new Object[]{fieldName, fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(nestedType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.prependAll($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($T.asList($N))", new Object[]{TypeUtils.ARRAYS, param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($T.asList($N), $T.of(cassandraOptions)))", new Object[]{fieldName, TypeUtils.ARRAYS, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        MethodSpec.Builder prependAllTo = MethodSpec.methodBuilder((String)"PrependAllTo").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = ? + $L</strong>", new Object[]{fieldName, fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(sourceType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.prependAll($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        MethodSpec.Builder setAtIndex = MethodSpec.methodBuilder((String)"SetAtIndex").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L[index] = ?</strong>", new Object[]{fieldName}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeName.INT, "index", new Modifier[]{Modifier.FINAL}).addParameter(nestedType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.setIdx($S, index, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add(meta.$L.valueProperty.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        MethodSpec.Builder removeAtIndex = MethodSpec.methodBuilder((String)"RemoveAtIndex").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L[index] = null</strong>", new Object[]{fieldName}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeName.INT, "index", new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.setIdx($S, index, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add(null)", new Object[0]).addStatement("encodedValues.add(null)", new Object[0]).returns(newTypeName);
        MethodSpec.Builder removeFrom = MethodSpec.methodBuilder((String)"RemoveFrom").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = $L - [?]</strong>", new Object[]{fieldName, fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(nestedType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.discardAll($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($T.asList($N))", new Object[]{TypeUtils.ARRAYS, param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($T.asList($N), $T.of(cassandraOptions)))", new Object[]{fieldName, TypeUtils.ARRAYS, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        MethodSpec.Builder removeAllFrom = MethodSpec.methodBuilder((String)"RemoveAllFrom").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = $L - ?</strong>", new Object[]{fieldName, fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(sourceType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.discardAll($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        MethodSpec.Builder set = MethodSpec.methodBuilder((String)"Set").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = ?</strong>", new Object[]{fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(sourceType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.of($S, $T.bindMarker($S)))", new Object[]{TypeUtils.NON_ESCAPING_ASSIGNMENT, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            appendTo.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            appendAllTo.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            prependTo.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            prependAllTo.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            setAtIndex.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            removeAtIndex.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            removeFrom.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            removeAllFrom.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            set.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
        } else {
            appendTo.addStatement("return $T.this", new Object[]{newTypeName});
            appendAllTo.addStatement("return $T.this", new Object[]{newTypeName});
            prependTo.addStatement("return $T.this", new Object[]{newTypeName});
            prependAllTo.addStatement("return $T.this", new Object[]{newTypeName});
            setAtIndex.addStatement("return $T.this", new Object[]{newTypeName});
            removeAtIndex.addStatement("return $T.this", new Object[]{newTypeName});
            removeFrom.addStatement("return $T.this", new Object[]{newTypeName});
            removeAllFrom.addStatement("return $T.this", new Object[]{newTypeName});
            set.addStatement("return $T.this", new Object[]{newTypeName});
        }
        if (!fieldMetaSignature.context.columnInfo.frozen) {
            updateMethods.add(appendTo.build());
            updateMethods.add(appendAllTo.build());
            updateMethods.add(prependTo.build());
            updateMethods.add(prependAllTo.build());
            updateMethods.add(setAtIndex.build());
            updateMethods.add(removeAtIndex.build());
            updateMethods.add(removeFrom.build());
            updateMethods.add(removeAllFrom.build());
        }
        updateMethods.add(set.build());
        this.createRelationClassForColumn(parentSignature, fieldMetaSignature, newTypeName, returnType, updateMethods);
    }

    public void buildMethodsForSetUpdate(ParentSignature parentSignature, TypeName newTypeName, FieldParser.FieldMetaSignature fieldMetaSignature, AbstractDSLCodeGen.ReturnType returnType) {
        String fieldName = parentSignature.parentFieldName.map(x -> String.format("%s.udtClassProperty.%s", x, fieldMetaSignature.context.fieldName)).orElse(fieldMetaSignature.context.fieldName);
        String param = parentSignature.parentFieldName.map(x -> x + "_" + fieldMetaSignature.context.fieldName + "_element").orElse(fieldMetaSignature.context.fieldName + "_element");
        String cqlColumn = parentSignature.parentQuotedCQLColumn.map(x -> x + "." + fieldMetaSignature.context.quotedCqlColumn).orElse(fieldMetaSignature.context.quotedCqlColumn);
        TypeName sourceType = fieldMetaSignature.sourceType;
        TypeName nestedType = parentSignature.aptUtils.extractTypeArgument(sourceType, 0);
        ArrayList<MethodSpec> updateMethods = new ArrayList<MethodSpec>();
        MethodSpec.Builder addTo = MethodSpec.methodBuilder((String)"AddTo").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = $L + {?}</strong>", new Object[]{cqlColumn, cqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(nestedType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.addAll($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($T.newHashSet($N))", new Object[]{TypeUtils.SETS, param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($T.newHashSet($N), $T.of(cassandraOptions)))", new Object[]{fieldName, TypeUtils.SETS, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        MethodSpec.Builder addAllTo = MethodSpec.methodBuilder((String)"AddAllTo").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = $L + ?</strong>", new Object[]{fieldName, fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(sourceType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.addAll($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        MethodSpec.Builder removeFrom = MethodSpec.methodBuilder((String)"RemoveFrom").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = $L - {?}</strong>", new Object[]{fieldName, fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(nestedType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.removeAll($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($T.newHashSet($N))", new Object[]{TypeUtils.SETS, param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($T.newHashSet($N), $T.of(cassandraOptions)))", new Object[]{fieldName, TypeUtils.SETS, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        MethodSpec.Builder removeAllFrom = MethodSpec.methodBuilder((String)"RemoveAllFrom").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = $L - ?</strong>", new Object[]{fieldName, fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(sourceType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.removeAll($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        MethodSpec.Builder set = MethodSpec.methodBuilder((String)"Set").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = ?</strong>", new Object[]{fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(sourceType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.of($S, $T.bindMarker($S)))", new Object[]{TypeUtils.NON_ESCAPING_ASSIGNMENT, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            addTo.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            addAllTo.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            removeFrom.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            removeAllFrom.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            set.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
        } else {
            addTo.addStatement("return $T.this", new Object[]{newTypeName});
            addAllTo.addStatement("return $T.this", new Object[]{newTypeName});
            removeFrom.addStatement("return $T.this", new Object[]{newTypeName});
            removeAllFrom.addStatement("return $T.this", new Object[]{newTypeName});
            set.addStatement("return $T.this", new Object[]{newTypeName});
        }
        if (!fieldMetaSignature.context.columnInfo.frozen) {
            updateMethods.add(addTo.build());
            updateMethods.add(addAllTo.build());
            updateMethods.add(removeFrom.build());
            updateMethods.add(removeAllFrom.build());
        }
        updateMethods.add(set.build());
        this.createRelationClassForColumn(parentSignature, fieldMetaSignature, newTypeName, returnType, updateMethods);
    }

    public void buildMethodsForMapUpdate(ParentSignature parentSignature, TypeName newTypeName, FieldParser.FieldMetaSignature fieldMetaSignature, AbstractDSLCodeGen.ReturnType returnType) {
        String fieldName = parentSignature.parentFieldName.map(x -> String.format("%s.udtClassProperty.%s", x, fieldMetaSignature.context.fieldName)).orElse(fieldMetaSignature.context.fieldName);
        String paramKey = parentSignature.parentFieldName.map(x -> x + "_" + fieldMetaSignature.context.fieldName + "_key").orElse(fieldMetaSignature.context.fieldName + "_key");
        String paramValue = parentSignature.parentFieldName.map(x -> x + "_" + fieldMetaSignature.context.fieldName + "_value").orElse(fieldMetaSignature.context.fieldName + "_value");
        String param = parentSignature.parentFieldName.map(x -> x + "_" + fieldMetaSignature.context.fieldName).orElse(fieldMetaSignature.context.fieldName);
        String cqlColumn = parentSignature.parentQuotedCQLColumn.map(x -> x + "." + fieldMetaSignature.context.quotedCqlColumn).orElse(fieldMetaSignature.context.quotedCqlColumn);
        TypeName sourceType = fieldMetaSignature.sourceType;
        TypeName nestedKeyType = parentSignature.aptUtils.extractTypeArgument(sourceType, 0);
        TypeName nestedValueType = parentSignature.aptUtils.extractTypeArgument(sourceType, 1);
        ArrayList<MethodSpec> updateMethods = new ArrayList<MethodSpec>();
        MethodSpec.Builder putTo = MethodSpec.methodBuilder((String)"PutTo").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L[?] = ?</strong>", new Object[]{cqlColumn}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(nestedKeyType, paramKey, new Modifier[]{Modifier.FINAL}).addParameter(nestedValueType, paramValue, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.put($S, $T.bindMarker($S), $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, paramKey, TypeUtils.QUERY_BUILDER, paramValue}).addStatement("boundValues.add($N)", new Object[]{paramKey}).addStatement("boundValues.add($N)", new Object[]{paramValue}).addStatement("encodedValues.add(meta.$L.keyProperty.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, paramKey, TypeUtils.OPTIONAL}).addStatement("encodedValues.add(meta.$L.valueProperty.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, paramValue, TypeUtils.OPTIONAL}).returns(newTypeName);
        MethodSpec.Builder addAllTo = MethodSpec.methodBuilder((String)"AddAllTo").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = $L + ?</strong>", new Object[]{fieldName, fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(sourceType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.addAll($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        MethodSpec.Builder removeByKey = MethodSpec.methodBuilder((String)"RemoveByKey").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addJavadoc("Generate an UPDATE FROM ... <strong>SET $L[?] = null</strong>", new Object[]{fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addParameter(nestedKeyType, paramKey, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.put($S, $T.bindMarker($S), $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, paramKey, TypeUtils.QUERY_BUILDER, paramValue}).addStatement("boundValues.add($N)", new Object[]{paramKey}).addStatement("boundValues.add(null)", new Object[0]).addStatement("encodedValues.add(meta.$L.keyProperty.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, paramKey, TypeUtils.OPTIONAL}).addStatement("encodedValues.add(null)", new Object[0]).returns(newTypeName);
        MethodSpec.Builder set = MethodSpec.methodBuilder((String)"Set").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = ?", new Object[]{fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(sourceType, param, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.of($S, $T.bindMarker($S)))", new Object[]{TypeUtils.NON_ESCAPING_ASSIGNMENT, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($N)", new Object[]{param}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, param, TypeUtils.OPTIONAL}).returns(newTypeName);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            putTo.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            addAllTo.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            removeByKey.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            set.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
        } else {
            putTo.addStatement("return $T.this", new Object[]{newTypeName});
            addAllTo.addStatement("return $T.this", new Object[]{newTypeName});
            removeByKey.addStatement("return $T.this", new Object[]{newTypeName});
            set.addStatement("return $T.this", new Object[]{newTypeName});
        }
        if (!fieldMetaSignature.context.columnInfo.frozen) {
            updateMethods.add(putTo.build());
            updateMethods.add(addAllTo.build());
            updateMethods.add(removeByKey.build());
        }
        updateMethods.add(set.build());
        this.createRelationClassForColumn(parentSignature, fieldMetaSignature, newTypeName, returnType, updateMethods);
    }

    public void buildMethodsForCounterUpdate(ParentSignature parentSignature, TypeName newTypeName, FieldParser.FieldMetaSignature parsingResult, AbstractDSLCodeGen.ReturnType returnType) {
        String fieldName = parsingResult.context.fieldName;
        String paramIncr = parsingResult.context.fieldName + "_increment";
        String paramDecr = parsingResult.context.fieldName + "_decrement";
        String cqlColumn = parsingResult.context.quotedCqlColumn;
        TypeName sourceType = parsingResult.sourceType;
        ArrayList<MethodSpec> updateMethods = new ArrayList<MethodSpec>();
        MethodSpec.Builder incrOne = MethodSpec.methodBuilder((String)"Incr").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = $L + 1</strong>", new Object[]{cqlColumn, cqlColumn}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("where.with($T.incr($S))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn}).returns(newTypeName);
        MethodSpec.Builder incr = MethodSpec.methodBuilder((String)"Incr").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = $L + ?</strong>", new Object[]{fieldName, fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(sourceType, paramIncr, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.incr($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($N)", new Object[]{paramIncr}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, paramIncr, TypeUtils.OPTIONAL}).returns(newTypeName);
        MethodSpec.Builder decrOne = MethodSpec.methodBuilder((String)"Decr").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = $L - 1</strong>", new Object[]{fieldName, fieldName}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("where.with($T.decr($S))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn}).returns(newTypeName);
        MethodSpec.Builder decr = MethodSpec.methodBuilder((String)"Decr").addJavadoc("Generate an UPDATE FROM ... <strong>SET $L = $L - ?</strong>", new Object[]{fieldName, fieldName}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(sourceType, paramDecr, new Modifier[]{Modifier.FINAL}).addStatement("where.with($T.decr($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, cqlColumn, TypeUtils.QUERY_BUILDER, cqlColumn}).addStatement("boundValues.add($N)", new Object[]{paramDecr}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldName, paramDecr, TypeUtils.OPTIONAL}).returns(newTypeName);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            incrOne.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            incr.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            decrOne.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
            decr.addStatement("return new $T(where, cassandraOptions)", new Object[]{newTypeName});
        } else {
            incrOne.addStatement("return $T.this", new Object[]{newTypeName});
            incr.addStatement("return $T.this", new Object[]{newTypeName});
            decrOne.addStatement("return $T.this", new Object[]{newTypeName});
            decr.addStatement("return $T.this", new Object[]{newTypeName});
        }
        updateMethods.add(incrOne.build());
        updateMethods.add(incr.build());
        updateMethods.add(decrOne.build());
        updateMethods.add(decr.build());
        this.createRelationClassForColumn(parentSignature, parsingResult, newTypeName, returnType, updateMethods);
    }

    public void createRelationClassForColumn(ParentSignature parentSignature, FieldParser.FieldMetaSignature fieldSignature, TypeName newTypeName, AbstractDSLCodeGen.ReturnType returnType, List<MethodSpec> methods) {
        AptUtils aptUtils = parentSignature.aptUtils;
        String parentClassName = parentSignature.parentClassName;
        TypeSpec.Builder parentBuilder = parentSignature.parentBuilder;
        ClassName relationClassTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(parentClassName + "." + fieldSignature.relationClassnameForUpdate()), (String[])new String[0]);
        String fieldName = fieldSignature.context.fieldName;
        TypeSpec.Builder relationClassBuilder = TypeSpec.classBuilder((String)fieldSignature.relationClassnameForUpdate()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        methods.forEach(arg_0 -> ((TypeSpec.Builder)relationClassBuilder).addMethod(arg_0));
        this.augmentUpdateRelationClass(ParentSignature.of(aptUtils, relationClassBuilder, parentClassName + "." + fieldSignature.relationClassnameForUpdate(), parentSignature.parentQuotedCQLColumn, parentSignature.parentFieldName), fieldSignature, newTypeName, returnType);
        TypeSpec relationClass = relationClassBuilder.build();
        parentBuilder.addType(relationClass);
        parentBuilder.addMethod(MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T()", new Object[]{relationClassTypeName}).returns((TypeName)relationClassTypeName).build());
    }

    public static class ParentSignature {
        public final AptUtils aptUtils;
        public final TypeSpec.Builder parentBuilder;
        public final String parentClassName;
        public final Optional<String> parentQuotedCQLColumn;
        public final Optional<String> parentFieldName;

        private ParentSignature(AptUtils aptUtils, TypeSpec.Builder parentBuilder, String parentClassName, Optional<String> parentQuotedCQLColumn, Optional<String> parentFieldName) {
            this.aptUtils = aptUtils;
            this.parentBuilder = parentBuilder;
            this.parentClassName = parentClassName;
            this.parentQuotedCQLColumn = parentQuotedCQLColumn;
            this.parentFieldName = parentFieldName;
        }

        public static ParentSignature of(AptUtils aptUtils, TypeSpec.Builder parentBuilder, String parentClassName, Optional<String> parentQuotedCQLColumn, Optional<String> parentFieldName) {
            return new ParentSignature(aptUtils, parentBuilder, parentClassName, parentQuotedCQLColumn, parentFieldName);
        }
    }
}

