/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.dsl.select;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.internals.codegen.dsl.AbstractDSLCodeGen;
import info.archinnov.achilles.internals.codegen.dsl.BaseSingleColumnRestriction;
import info.archinnov.achilles.internals.codegen.dsl.MultiColumnsSliceRestrictionCodeGen;
import info.archinnov.achilles.internals.codegen.meta.EntityMetaCodeGen;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import info.archinnov.achilles.internals.utils.NamingHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public abstract class SelectWhereDSLCodeGen
extends AbstractDSLCodeGen
implements BaseSingleColumnRestriction,
MultiColumnsSliceRestrictionCodeGen {
    public abstract void augmentSelectEndClass(TypeSpec.Builder var1, AbstractDSLCodeGen.ClassSignatureInfo var2);

    public abstract List<TypeSpec> generateExtraWhereClasses(GlobalParsingContext var1, EntityMetaCodeGen.EntityMetaSignature var2, List<AbstractDSLCodeGen.FieldSignatureInfo> var3, List<AbstractDSLCodeGen.FieldSignatureInfo> var4);

    public abstract void augmentRelationClassForWhereClause(TypeSpec.Builder var1, AbstractDSLCodeGen.FieldSignatureInfo var2, AbstractDSLCodeGen.ClassSignatureInfo var3, AbstractDSLCodeGen.ReturnType var4);

    public List<TypeSpec> buildWhereClasses(GlobalParsingContext context, EntityMetaCodeGen.EntityMetaSignature signature) {
        SelectWhereDSLCodeGen selectWhereDSLCodeGen = context.selectWhereDSLCodeGen();
        List<AbstractDSLCodeGen.FieldSignatureInfo> partitionKeys = this.getPartitionKeysSignatureInfo(signature.fieldMetaSignatures);
        List<AbstractDSLCodeGen.FieldSignatureInfo> clusteringCols = this.getClusteringColsSignatureInfo(signature.fieldMetaSignatures);
        AbstractDSLCodeGen.ClassSignatureParams classSignatureParams = AbstractDSLCodeGen.ClassSignatureParams.of("_Select", "W", "E", TypeUtils.ABSTRACT_SELECT_WHERE_PARTITION, TypeUtils.ABSTRACT_SELECT_WHERE);
        AbstractDSLCodeGen.ClassSignatureParams typedMapClassSignatureParams = AbstractDSLCodeGen.ClassSignatureParams.of("_Select", "W_TM", "E_TM", TypeUtils.ABSTRACT_SELECT_WHERE_PARTITION_TYPED_MAP, TypeUtils.ABSTRACT_SELECT_WHERE_TYPED_MAP);
        List<TypeSpec> partitionKeysWhereClasses = this.buildWhereClassesInternal(signature, selectWhereDSLCodeGen, partitionKeys, clusteringCols, classSignatureParams);
        List<TypeSpec> partitionKeysWhereTypedMapClasses = this.buildWhereClassesInternal(signature, selectWhereDSLCodeGen, partitionKeys, clusteringCols, typedMapClassSignatureParams);
        partitionKeysWhereClasses.addAll(partitionKeysWhereTypedMapClasses);
        partitionKeysWhereClasses.addAll(this.generateExtraWhereClasses(context, signature, partitionKeys, clusteringCols));
        return partitionKeysWhereClasses;
    }

    public List<TypeSpec> buildWhereClassesInternal(EntityMetaCodeGen.EntityMetaSignature signature, SelectWhereDSLCodeGen selectWhereDSLCodeGen, List<AbstractDSLCodeGen.FieldSignatureInfo> partitionKeys, List<AbstractDSLCodeGen.FieldSignatureInfo> clusteringCols, AbstractDSLCodeGen.ClassSignatureParams classSignatureParams) {
        List<AbstractDSLCodeGen.ClassSignatureInfo> classesSignature = selectWhereDSLCodeGen.buildClassesSignatureForWhereClause(signature, classSignatureParams, partitionKeys, clusteringCols, AbstractDSLCodeGen.WhereClauseFor.NORMAL);
        Optional<AbstractDSLCodeGen.ClassSignatureInfo> firstClusteringClassSignature = classesSignature.stream().filter(x -> x.columnType == ColumnType.CLUSTERING).findFirst();
        AbstractDSLCodeGen.ClassSignatureInfo lastSignature = classesSignature.get(classesSignature.size() - 1);
        List<TypeSpec> partitionKeysWhereClasses = this.buildWhereClassesForPartitionKeys(signature.selectClassName(), true, lastSignature, classesSignature);
        List<TypeSpec> clusteringColsWhereClasses = this.buildWhereClassesForClusteringColumns(signature, firstClusteringClassSignature, classesSignature, lastSignature);
        TypeSpec selectEndClass = this.buildSelectEndClass(signature, lastSignature, firstClusteringClassSignature);
        partitionKeysWhereClasses.addAll(clusteringColsWhereClasses);
        partitionKeysWhereClasses.add(selectEndClass);
        return partitionKeysWhereClasses;
    }

    public TypeSpec buildSelectEndClass(EntityMetaCodeGen.EntityMetaSignature signature, AbstractDSLCodeGen.ClassSignatureInfo lastSignature, Optional<AbstractDSLCodeGen.ClassSignatureInfo> firstClusteringClassSignature) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)lastSignature.className).superclass(lastSignature.superType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildWhereConstructorWithOptions(TypeUtils.SELECT_DOT_WHERE)).addMethod(this.buildGetEntityClass(signature)).addMethod(this.buildGetMetaInternal(signature.entityRawClass)).addMethod(this.buildGetRte()).addMethod(this.buildGetOptions()).addMethod(this.buildGetBoundValuesInternal()).addMethod(this.buildGetEncodedBoundValuesInternal()).addMethod(this.buildLimit(lastSignature)).addMethod(this.buildGetThis(lastSignature.returnClassType));
        this.augmentSelectEndClass(builder, lastSignature);
        this.maybeBuildOrderingBy(lastSignature, firstClusteringClassSignature.map(x -> x.fieldSignatureInfo), builder);
        return builder.build();
    }

    public void maybeBuildOrderingBy(AbstractDSLCodeGen.ClassSignatureInfo lastSignature, Optional<AbstractDSLCodeGen.FieldSignatureInfo> fieldSignatureInfoOptional, TypeSpec.Builder builder) {
        if (fieldSignatureInfoOptional.isPresent()) {
            AbstractDSLCodeGen.FieldSignatureInfo fieldSignatureInfo = fieldSignatureInfoOptional.get();
            MethodSpec orderByAsc = MethodSpec.methodBuilder((String)("orderBy" + NamingHelper.upperCaseFirst(fieldSignatureInfo.fieldName) + "Ascending")).addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY $L ASC</strong>", new Object[]{fieldSignatureInfo.cqlColumn}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(lastSignature.returnClassType).addStatement("where.orderBy($T.asc($S))", new Object[]{TypeUtils.QUERY_BUILDER, fieldSignatureInfo.cqlColumn}).addStatement("return this", new Object[0]).build();
            MethodSpec orderByDesc = MethodSpec.methodBuilder((String)("orderBy" + NamingHelper.upperCaseFirst(fieldSignatureInfo.fieldName) + "Descending")).addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>ORDER BY $L DESC</strong>", new Object[]{fieldSignatureInfo.cqlColumn}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(lastSignature.returnClassType).addStatement("where.orderBy($T.desc($S))", new Object[]{TypeUtils.QUERY_BUILDER, fieldSignatureInfo.cqlColumn}).addStatement("return this", new Object[0]).build();
            builder.addMethod(orderByAsc).addMethod(orderByDesc);
        }
    }

    public MethodSpec buildLimit(AbstractDSLCodeGen.ClassSignatureInfo lastSignature) {
        return MethodSpec.methodBuilder((String)"limit").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>LIMIT :limit</strong>", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeName.INT.box(), "limit", new Modifier[]{Modifier.FINAL}).returns(lastSignature.returnClassType).addStatement("where.limit($T.bindMarker($S))", new Object[]{TypeUtils.QUERY_BUILDER, "lim"}).addStatement("boundValues.add($N)", new Object[]{"limit"}).addStatement("encodedValues.add($N)", new Object[]{"limit"}).addStatement("return this", new Object[0]).build();
    }

    public List<TypeSpec> buildWhereClassesForPartitionKeys(String rootClassName, boolean buildTokenFunction, AbstractDSLCodeGen.ClassSignatureInfo lastSignature, List<AbstractDSLCodeGen.ClassSignatureInfo> classesSignature) {
        TypeSpec typeSpec;
        ColumnType columnType = classesSignature.get((int)0).columnType;
        if (columnType == ColumnType.CLUSTERING || columnType == null) {
            return new ArrayList<TypeSpec>();
        }
        AbstractDSLCodeGen.ClassSignatureInfo classSignature = classesSignature.remove(0);
        TypeSpec.Builder builder = this.buildSelectWhereForPartitionKey(rootClassName, classSignature, classesSignature.get(0));
        if (buildTokenFunction) {
            ArrayList<String> partitionKeyColumns = new ArrayList<String>(classesSignature.stream().filter(x -> x.columnType == ColumnType.PARTITION).map(x -> x.fieldSignatureInfo.quotedCqlColumn).collect(Collectors.toList()));
            partitionKeyColumns.add(0, classSignature.fieldSignatureInfo.quotedCqlColumn);
            typeSpec = this.augmentWithTokenValueRelationClass(rootClassName, builder, lastSignature, classSignature, partitionKeyColumns);
        } else {
            typeSpec = builder.build();
        }
        List<TypeSpec> typeSpecs = this.buildWhereClassesForPartitionKeys(rootClassName, false, lastSignature, classesSignature);
        typeSpecs.add(0, typeSpec);
        return typeSpecs;
    }

    public TypeSpec augmentWithTokenValueRelationClass(String rootClassName, TypeSpec.Builder builder, AbstractDSLCodeGen.ClassSignatureInfo nextClassSignatureForTokenFunction, AbstractDSLCodeGen.ClassSignatureInfo classSignature, List<String> partitionKeyColumns) {
        ClassName relationClassTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(rootClassName + "." + classSignature.className + "." + "Token"), (String[])new String[0]);
        TypeSpec tokenClass = TypeSpec.classBuilder((String)"Token").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildTokenValueRelation("eq", nextClassSignatureForTokenFunction.returnClassType, partitionKeyColumns, AbstractDSLCodeGen.ReturnType.NEW)).addMethod(this.buildTokenValueRelation("gt", nextClassSignatureForTokenFunction.returnClassType, partitionKeyColumns, AbstractDSLCodeGen.ReturnType.NEW)).addMethod(this.buildTokenValueRelation("gte", nextClassSignatureForTokenFunction.returnClassType, partitionKeyColumns, AbstractDSLCodeGen.ReturnType.NEW)).addMethod(this.buildTokenValueRelation("lt", nextClassSignatureForTokenFunction.returnClassType, partitionKeyColumns, AbstractDSLCodeGen.ReturnType.NEW)).addMethod(this.buildTokenValueRelation("lte", nextClassSignatureForTokenFunction.returnClassType, partitionKeyColumns, AbstractDSLCodeGen.ReturnType.NEW)).addMethod(this.buildDoubleTokenValueRelation("gt", "lt", nextClassSignatureForTokenFunction.returnClassType, partitionKeyColumns, AbstractDSLCodeGen.ReturnType.NEW)).addMethod(this.buildDoubleTokenValueRelation("gt", "lte", nextClassSignatureForTokenFunction.returnClassType, partitionKeyColumns, AbstractDSLCodeGen.ReturnType.NEW)).addMethod(this.buildDoubleTokenValueRelation("gte", "lt", nextClassSignatureForTokenFunction.returnClassType, partitionKeyColumns, AbstractDSLCodeGen.ReturnType.NEW)).addMethod(this.buildDoubleTokenValueRelation("gte", "lte", nextClassSignatureForTokenFunction.returnClassType, partitionKeyColumns, AbstractDSLCodeGen.ReturnType.NEW)).build();
        String methodName = partitionKeyColumns.stream().collect(Collectors.joining("_", "tokenValueOf_", "")).replaceAll("\"", "");
        return builder.addType(tokenClass).addMethod(SelectWhereDSLCodeGen.buildRelationMethod(methodName, (TypeName)relationClassTypeName)).build();
    }

    public TypeSpec.Builder buildSelectWhereForPartitionKey(String rootClassName, AbstractDSLCodeGen.ClassSignatureInfo classSignature, AbstractDSLCodeGen.ClassSignatureInfo nextSignature) {
        AbstractDSLCodeGen.FieldSignatureInfo partitionInfo = classSignature.fieldSignatureInfo;
        ClassName relationClassTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(rootClassName + "." + classSignature.className + "." + "Relation"), (String[])new String[0]);
        TypeSpec.Builder relationClassBuilder = TypeSpec.classBuilder((String)"Relation").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildColumnRelation("eq", nextSignature.returnClassType, partitionInfo, AbstractDSLCodeGen.ReturnType.NEW)).addMethod(this.buildColumnInVarargs(nextSignature.returnClassType, partitionInfo, AbstractDSLCodeGen.ReturnType.NEW));
        this.augmentRelationClassForWhereClause(relationClassBuilder, partitionInfo, nextSignature, AbstractDSLCodeGen.ReturnType.NEW);
        return TypeSpec.classBuilder((String)classSignature.className).superclass(classSignature.superType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildWhereConstructorWithOptions(TypeUtils.SELECT_DOT_WHERE)).addType(relationClassBuilder.build()).addMethod(SelectWhereDSLCodeGen.buildRelationMethod(partitionInfo.fieldName, (TypeName)relationClassTypeName));
    }

    public List<TypeSpec> buildWhereClassesForClusteringColumns(EntityMetaCodeGen.EntityMetaSignature signature, Optional<AbstractDSLCodeGen.ClassSignatureInfo> firstClusteringClassSignature, List<AbstractDSLCodeGen.ClassSignatureInfo> classesSignature, AbstractDSLCodeGen.ClassSignatureInfo lastSignature) {
        if (classesSignature.get((int)0).columnType == null) {
            return new ArrayList<TypeSpec>();
        }
        ArrayList<AbstractDSLCodeGen.ClassSignatureInfo> copyClassesSignature = new ArrayList<AbstractDSLCodeGen.ClassSignatureInfo>(classesSignature);
        classesSignature.remove(0);
        TypeSpec currentType = this.buildSelectWhereForClusteringColumn(signature, firstClusteringClassSignature, copyClassesSignature, lastSignature).build();
        List<TypeSpec> typeSpecs = this.buildWhereClassesForClusteringColumns(signature, firstClusteringClassSignature, classesSignature, lastSignature);
        typeSpecs.add(0, currentType);
        return typeSpecs;
    }

    public TypeSpec.Builder buildSelectWhereForClusteringColumn(EntityMetaCodeGen.EntityMetaSignature signature, Optional<AbstractDSLCodeGen.ClassSignatureInfo> firstClusteringClassSignature, List<AbstractDSLCodeGen.ClassSignatureInfo> classesSignature, AbstractDSLCodeGen.ClassSignatureInfo lastSignature) {
        String rootClassName = signature.selectClassName();
        AbstractDSLCodeGen.ClassSignatureInfo classSignature = classesSignature.get(0);
        AbstractDSLCodeGen.ClassSignatureInfo nextSignature = classesSignature.get(1);
        AbstractDSLCodeGen.FieldSignatureInfo clusteringColumnInfo = classSignature.fieldSignatureInfo;
        ClassName relationClassTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(rootClassName + "." + classSignature.className + "." + "Relation"), (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)classSignature.className).superclass(classSignature.superType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildWhereConstructorWithOptions(TypeUtils.SELECT_DOT_WHERE)).addMethod(this.buildGetThis(classSignature.returnClassType)).addMethod(this.buildGetMetaInternal(signature.entityRawClass)).addMethod(this.buildGetEntityClass(signature)).addMethod(this.buildGetRte()).addMethod(this.buildGetOptions()).addMethod(this.buildGetBoundValuesInternal()).addMethod(this.buildGetEncodedBoundValuesInternal()).addMethod(this.buildLimit(classSignature));
        TypeSpec.Builder relationClassBuilder = TypeSpec.classBuilder((String)"Relation").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(this.buildColumnRelation("eq", nextSignature.returnClassType, clusteringColumnInfo, AbstractDSLCodeGen.ReturnType.NEW));
        this.addSingleColumnSliceRestrictions(relationClassBuilder, clusteringColumnInfo, nextSignature, lastSignature, AbstractDSLCodeGen.ReturnType.NEW);
        this.augmentRelationClassForWhereClause(relationClassBuilder, clusteringColumnInfo, nextSignature, AbstractDSLCodeGen.ReturnType.NEW);
        builder.addType(relationClassBuilder.build());
        builder.addMethod(SelectWhereDSLCodeGen.buildRelationMethod(clusteringColumnInfo.fieldName, (TypeName)relationClassTypeName));
        String parentClassName = signature.selectClassName() + "." + classesSignature.get((int)0).className;
        ArrayList<AbstractDSLCodeGen.ClassSignatureInfo> classesSignatureCopy = new ArrayList<AbstractDSLCodeGen.ClassSignatureInfo>(classesSignature);
        classesSignatureCopy.remove(lastSignature);
        this.addMultipleColumnsSliceRestrictions(builder, parentClassName, classesSignatureCopy.stream().map(x -> x.fieldSignatureInfo).collect(Collectors.toList()), lastSignature, AbstractDSLCodeGen.ReturnType.NEW);
        this.maybeBuildOrderingBy(classSignature, firstClusteringClassSignature.map(x -> x.fieldSignatureInfo), builder);
        return builder;
    }
}

