/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.dsl;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.internals.codegen.dsl.AbstractDSLCodeGen;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.utils.NamingHelper;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public interface BaseSingleColumnRestriction {
    default public MethodSpec buildColumnRelation(String relation, TypeName nextType, AbstractDSLCodeGen.FieldSignatureInfo fieldInfo, AbstractDSLCodeGen.ReturnType returnType) {
        String methodName = NamingHelper.upperCaseFirst(relation);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L $L ?</strong>", new Object[]{fieldInfo.quotedCqlColumn, AbstractDSLCodeGen.relationToSymbolForJavaDoc(relation)}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(fieldInfo.typeName, fieldInfo.fieldName, new Modifier[0]).addStatement("where.and($T.$L($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, relation, fieldInfo.quotedCqlColumn, TypeUtils.QUERY_BUILDER, fieldInfo.quotedCqlColumn}).addStatement("boundValues.add($N)", new Object[]{fieldInfo.fieldName}).addStatement("encodedValues.add(meta.$L.encodeFromJava($N, $T.of(cassandraOptions)))", new Object[]{fieldInfo.fieldName, fieldInfo.fieldName, TypeUtils.OPTIONAL}).returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }

    default public MethodSpec buildColumnInVarargs(TypeName nextType, AbstractDSLCodeGen.FieldSignatureInfo fieldInfo, AbstractDSLCodeGen.ReturnType returnType) {
        String methodName = "IN";
        String param = fieldInfo.fieldName;
        TypeName paramTypeName = fieldInfo.typeName;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"IN").addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L IN ?</strong>", new Object[]{fieldInfo.quotedCqlColumn}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)ArrayTypeName.of((TypeName)paramTypeName), param, new Modifier[0]).varargs().addStatement("$T.validateTrue($T.isNotEmpty($L), \"Varargs for field '%s' should not be null/empty\", $S)", new Object[]{TypeUtils.VALIDATOR, TypeUtils.ARRAYS_UTILS, fieldInfo.fieldName, fieldInfo.fieldName}).addStatement("where.and($T.in($S,$T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, fieldInfo.quotedCqlColumn, TypeUtils.QUERY_BUILDER, fieldInfo.quotedCqlColumn});
        if (paramTypeName.isPrimitive()) {
            builder.addStatement("final $T varargs = $T.<Object>asList(($T[])$L)", new Object[]{TypeUtils.LIST_OBJECT, TypeUtils.ARRAYS, paramTypeName, param}).addStatement("final $T encodedVarargs = new $T<>($L.length);", new Object[]{TypeUtils.LIST_OBJECT, TypeUtils.ARRAY_LIST, param}).beginControlFlow("for($T $L_element : $L)", new Object[]{paramTypeName, param, param}).addStatement("encodedVarargs.add(meta.$L.encodeFromJava($L_element, $T.of(cassandraOptions)))", new Object[]{param, param, TypeUtils.OPTIONAL}).endControlFlow();
        } else {
            builder.addStatement("final $T varargs = $T.<Object>asList((Object[])$L)", new Object[]{TypeUtils.LIST_OBJECT, TypeUtils.ARRAYS, param}).addStatement("final $T encodedVarargs = $T.<$T>stream(($T[])$L).map(x -> meta.$L.encodeFromJava(x, $T.of(cassandraOptions))).collect($T.toList())", new Object[]{TypeUtils.LIST_OBJECT, TypeUtils.ARRAYS, paramTypeName, paramTypeName, param, param, TypeUtils.OPTIONAL, TypeUtils.COLLECTORS});
        }
        builder.addStatement("boundValues.add(varargs)", new Object[0]).addStatement("encodedValues.add(encodedVarargs)", new Object[0]).returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }

    default public MethodSpec buildTokenValueRelation(String relation, TypeName nextType, List<String> partitionKeyColumns, AbstractDSLCodeGen.ReturnType returnType) {
        String fcall = partitionKeyColumns.stream().collect(Collectors.joining(",", "token(", ")"));
        String methodName = NamingHelper.upperCaseFirst(relation);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addJavadoc("Generate a SELECT ... FROM ... WHERE ... <strong>$L $L ?</strong>", new Object[]{fcall, AbstractDSLCodeGen.relationToSymbolForJavaDoc(relation)}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"static-access"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.OBJECT_LONG, "tokenValue", new Modifier[0]).addStatement("where.and($T.$L($S, $T.bindMarker($S)))", new Object[]{TypeUtils.QUERY_BUILDER, relation, fcall, TypeUtils.QUERY_BUILDER, "tokenValue"}).addStatement("boundValues.add($N)", new Object[]{"tokenValue"}).addStatement("encodedValues.add($N)", new Object[]{"tokenValue"}).returns(nextType);
        if (returnType == AbstractDSLCodeGen.ReturnType.NEW) {
            builder.addStatement("return new $T(where, cassandraOptions)", new Object[]{nextType});
        } else {
            builder.addStatement("return $T.this", new Object[]{nextType});
        }
        return builder.build();
    }
}

