/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen.crud;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.internals.codegen.meta.EntityMetaCodeGen;
import info.archinnov.achilles.internals.metamodel.columns.ClusteringColumnInfo;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.metamodel.columns.PartitionKeyInfo;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.type.tuples.Tuple3;
import java.util.Comparator;
import javax.lang.model.element.Modifier;

public abstract class CrudAPICodeGen {
    public static final Comparator<Tuple3<String, TypeName, PartitionKeyInfo>> PARTITION_KEY_SORTER = (o1, o2) -> ((PartitionKeyInfo)o1._3()).order.compareTo(((PartitionKeyInfo)o2._3()).order);
    public static final Comparator<Tuple3<String, TypeName, ClusteringColumnInfo>> CLUSTERING_COLUMN_SORTER = (o1, o2) -> ((ClusteringColumnInfo)o1._3()).order.compareTo(((ClusteringColumnInfo)o2._3()).order);

    protected abstract void augmentCRUDClass(EntityMetaCodeGen.EntityMetaSignature var1, TypeSpec.Builder var2);

    public TypeSpec buildCRUDClass(EntityMetaCodeGen.EntityMetaSignature signature) {
        TypeSpec.Builder crudClass = TypeSpec.classBuilder((String)(signature.className + "_CRUD")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addField(FieldSpec.builder((TypeName)TypeUtils.genericType(TypeUtils.OPTIONAL, new TypeName[]{TypeUtils.OPTIONS}), (String)"cassandraOptions", (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer(CodeBlock.builder().addStatement("$T.empty()", new Object[]{TypeUtils.OPTIONAL}).build()).build()).addMethod(CrudAPICodeGen.buildWithSchemaNameProvider(signature)).addMethod(CrudAPICodeGen.buildFind(signature));
        if (signature.isTable()) {
            crudClass.addMethod(CrudAPICodeGen.buildDeleteInstance(signature)).addMethod(CrudAPICodeGen.buildDeleteByKeys(signature));
            if (!signature.isCounterEntity()) {
                crudClass.addMethod(CrudAPICodeGen.buildInsert(signature));
                crudClass.addMethod(CrudAPICodeGen.buildUpdate(signature));
                if (signature.hasStatic()) {
                    crudClass.addMethod(CrudAPICodeGen.buildInsertStatic(signature));
                    crudClass.addMethod(CrudAPICodeGen.buildUpdateStatic(signature));
                }
            }
            if (signature.hasClustering()) {
                crudClass.addMethod(CrudAPICodeGen.buildDeleteByPartition(signature));
            }
        }
        this.augmentCRUDClass(signature, crudClass);
        return crudClass.build();
    }

    private static MethodSpec buildWithSchemaNameProvider(EntityMetaCodeGen.EntityMetaSignature signature) {
        ClassName crudClass = ClassName.get((String)"info.archinnov.achilles.generated.manager", (String)(signature.className + "_Manager" + "." + signature.className + "_CRUD"), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"withSchemaNameProvider").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeUtils.SCHEMA_NAME_PROVIDER, "schemaNameProvider", new Modifier[]{Modifier.FINAL}).addStatement("$T.validateNotNull($N,$S)", new Object[]{TypeUtils.VALIDATOR, "schemaNameProvider", "The provided schemaNameProvider should not be null"}).addStatement("this.cassandraOptions = $T.of($T.withSchemaNameProvider($N))", new Object[]{TypeUtils.OPTIONAL, TypeUtils.OPTIONS, "schemaNameProvider"}).addStatement("return this", new Object[0]).returns((TypeName)crudClass).build();
    }

    private static MethodSpec buildFind(EntityMetaCodeGen.EntityMetaSignature signature) {
        ParameterizedTypeName returnType = TypeUtils.genericType(TypeUtils.FIND_WITH_OPTIONS, signature.entityRawClass);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"findById").addJavadoc("Find an entity by its complete primary key", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$T keys = new $T<>()", new Object[]{TypeUtils.LIST_OBJECT, TypeUtils.ARRAY_LIST}).addStatement("$T encodedKeys = new $T<>()", new Object[]{TypeUtils.LIST_OBJECT, TypeUtils.ARRAY_LIST});
        signature.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.PARTITION).map(x -> Tuple3.of((Object)x.context.fieldName, (Object)x.sourceType, (Object)((PartitionKeyInfo)x.context.columnInfo))).sorted(PARTITION_KEY_SORTER).forEach(tuple -> builder.addJavadoc("@param $L partition key '$L'", new Object[]{tuple._1(), tuple._1()}).addParameter((TypeName)tuple._2(), (String)tuple._1(), new Modifier[]{Modifier.FINAL}).addStatement("$T.validateNotNull($L, $S, $S)", new Object[]{TypeUtils.VALIDATOR, tuple._1(), "Partition key '%s' should not be null", tuple._1()}).addStatement("keys.add($L)", new Object[]{tuple._1()}).addStatement("encodedKeys.add($L.$L.encodeFromJava($N, cassandraOptions))", new Object[]{signature.className + "_AchillesMeta", tuple._1(), tuple._1()}));
        signature.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.CLUSTERING).map(x -> Tuple3.of((Object)x.context.fieldName, (Object)x.sourceType, (Object)((ClusteringColumnInfo)x.context.columnInfo))).sorted(CLUSTERING_COLUMN_SORTER).forEach(tuple -> builder.addJavadoc("@param $L clustering column '$L'", new Object[]{tuple._1(), tuple._1()}).addParameter((TypeName)tuple._2(), (String)tuple._1(), new Modifier[]{Modifier.FINAL}).addStatement("$T.validateNotNull($L, $S, $S)", new Object[]{TypeUtils.VALIDATOR, tuple._1(), "Partition key '%s' should not be null", tuple._1()}).addStatement("keys.add($L)", new Object[]{tuple._1()}).addStatement("encodedKeys.add($L.$L.encodeFromJava($N, cassandraOptions))", new Object[]{signature.className + "_AchillesMeta", tuple._1(), tuple._1()}));
        builder.addJavadoc("@return FindWithOptions<$T>", new Object[]{signature.entityRawClass});
        builder.addStatement("final Object[] primaryKeyValues = keys.toArray()", new Object[0]).addStatement("final Object[] encodedPrimaryKeyValues = encodedKeys.toArray()", new Object[0]).addStatement("return new $T(entityClass, meta, rte, primaryKeyValues, encodedPrimaryKeyValues, cassandraOptions)", new Object[]{returnType}).returns((TypeName)returnType);
        return builder.build();
    }

    private static MethodSpec buildInsert(EntityMetaCodeGen.EntityMetaSignature signature) {
        return MethodSpec.methodBuilder((String)"insert").addJavadoc("Insert this entity\n\n", new Object[0]).addJavadoc("@param instance an instance of $T\n", new Object[]{signature.entityRawClass}).addJavadoc("@return $T<$T>", new Object[]{TypeUtils.INSERT_WITH_OPTIONS, signature.entityRawClass}).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).addParameter(signature.entityRawClass, "instance", new Modifier[]{Modifier.FINAL}).addStatement("return insertInternal(instance, false, cassandraOptions)", new Object[0]).returns((TypeName)TypeUtils.genericType(TypeUtils.INSERT_WITH_OPTIONS, signature.entityRawClass)).build();
    }

    private static MethodSpec buildUpdate(EntityMetaCodeGen.EntityMetaSignature signature) {
        return MethodSpec.methodBuilder((String)"update").addJavadoc("Update the cassandra table with <strong>NOT NULL</strong> fields extracted from this entity\n\n", new Object[0]).addJavadoc("@param instance an instance of $T\n", new Object[]{signature.entityRawClass}).addJavadoc("@return $T<$T>", new Object[]{TypeUtils.INSERT_WITH_OPTIONS, signature.entityRawClass}).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).addParameter(signature.entityRawClass, "instance", new Modifier[]{Modifier.FINAL}).addStatement("return updateInternal(instance, false, cassandraOptions)", new Object[0]).returns((TypeName)TypeUtils.genericType(TypeUtils.UPDATE_WITH_OPTIONS, signature.entityRawClass)).build();
    }

    private static MethodSpec buildInsertStatic(EntityMetaCodeGen.EntityMetaSignature signature) {
        return MethodSpec.methodBuilder((String)"insertStatic").addJavadoc("Insert only partition key(s) and static column(s).\n\n", new Object[0]).addJavadoc("<strong>All clustering column(s) values will be ignored and not inserted</strong>\n\n", new Object[0]).addJavadoc("@param instance an instance of $T\n", new Object[]{signature.entityRawClass}).addJavadoc("@return $T<$T>", new Object[]{TypeUtils.INSERT_WITH_OPTIONS, signature.entityRawClass}).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).addParameter(signature.entityRawClass, "instance", new Modifier[]{Modifier.FINAL}).addStatement("return insertInternal(instance, true, cassandraOptions)", new Object[0]).returns((TypeName)TypeUtils.genericType(TypeUtils.INSERT_WITH_OPTIONS, signature.entityRawClass)).build();
    }

    private static MethodSpec buildUpdateStatic(EntityMetaCodeGen.EntityMetaSignature signature) {
        return MethodSpec.methodBuilder((String)"updateStatic").addJavadoc("Update only static columns of the cassandra table with <strong>NOT NULL</strong> fields extracted from this entity\n\n", new Object[0]).addJavadoc("<strong>All non-static column(s) values will be ignored and not updated</strong>\n\n", new Object[0]).addJavadoc("@param instance an instance of $T\n", new Object[]{signature.entityRawClass}).addJavadoc("@return $T<$T>", new Object[]{TypeUtils.INSERT_WITH_OPTIONS, signature.entityRawClass}).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).addParameter(signature.entityRawClass, "instance", new Modifier[]{Modifier.FINAL}).addStatement("return updateInternal(instance, true, cassandraOptions)", new Object[0]).returns((TypeName)TypeUtils.genericType(TypeUtils.UPDATE_WITH_OPTIONS, signature.entityRawClass)).build();
    }

    private static MethodSpec buildDeleteByKeys(EntityMetaCodeGen.EntityMetaSignature signature) {
        ParameterizedTypeName returnType = TypeUtils.genericType(TypeUtils.DELETE_WITH_OPTIONS, signature.entityRawClass);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"deleteById").addJavadoc("Delete an entity using its complete primary key", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$T keys = new $T<>()", new Object[]{TypeUtils.LIST_OBJECT, TypeUtils.ARRAY_LIST}).addStatement("$T encodedKeys = new $T<>()", new Object[]{TypeUtils.LIST_OBJECT, TypeUtils.ARRAY_LIST});
        signature.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.PARTITION).map(x -> Tuple3.of((Object)x.context.fieldName, (Object)x.sourceType, (Object)((PartitionKeyInfo)x.context.columnInfo))).sorted(PARTITION_KEY_SORTER).forEach(tuple -> builder.addJavadoc("@param $L partition key '$L'", new Object[]{tuple._1(), tuple._1()}).addParameter((TypeName)tuple._2(), (String)tuple._1(), new Modifier[]{Modifier.FINAL}).addStatement("$T.validateNotNull($L, $S, $S)", new Object[]{TypeUtils.VALIDATOR, tuple._1(), "Partition key '%s' should not be null", tuple._1()}).addStatement("keys.add($L)", new Object[]{tuple._1()}).addStatement("encodedKeys.add($L.$L.encodeFromJava($N, cassandraOptions))", new Object[]{signature.className + "_AchillesMeta", tuple._1(), tuple._1()}));
        signature.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.CLUSTERING).map(x -> Tuple3.of((Object)x.context.fieldName, (Object)x.sourceType, (Object)((ClusteringColumnInfo)x.context.columnInfo))).sorted(CLUSTERING_COLUMN_SORTER).forEach(tuple -> builder.addJavadoc("@param $L clustering column '$L'", new Object[]{tuple._1(), tuple._1()}).addParameter((TypeName)tuple._2(), (String)tuple._1(), new Modifier[]{Modifier.FINAL}).addStatement("$T.validateNotNull($L, $S, $S)", new Object[]{TypeUtils.VALIDATOR, tuple._1(), "Partition key '%s' should not be null", tuple._1()}).addStatement("keys.add($L)", new Object[]{tuple._1()}).addStatement("encodedKeys.add($L.$L.encodeFromJava($N, cassandraOptions))", new Object[]{signature.className + "_AchillesMeta", tuple._1(), tuple._1()}));
        builder.addJavadoc("@return DeleteWithOptions<$T>", new Object[]{signature.entityRawClass});
        builder.addStatement("final Object[] partitionKeysValues = keys.toArray()", new Object[0]).addStatement("final Object[] encodedPartitionKeyValues = encodedKeys.toArray()", new Object[0]).addStatement("return new $T(entityClass, meta, rte, partitionKeysValues, encodedPartitionKeyValues, $T.empty(), cassandraOptions)", new Object[]{returnType, TypeUtils.OPTIONAL}).returns((TypeName)returnType);
        return builder.build();
    }

    private static MethodSpec buildDeleteInstance(EntityMetaCodeGen.EntityMetaSignature signature) {
        return MethodSpec.methodBuilder((String)"delete").addJavadoc("Delete an entity instance by extracting its primary key", new Object[0]).addJavadoc("Remark: <strong>Achilles will throw an exception if any column being part of the primary key is NULL</strong>", new Object[0]).addJavadoc("@param an instance of $T to be delete", new Object[]{signature.entityRawClass}).addJavadoc("@return DeleteWithOptions<$T>", new Object[]{signature.entityRawClass}).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(signature.entityRawClass, "instance", new Modifier[]{Modifier.FINAL}).addStatement("return deleteInternal($N, cassandraOptions)", new Object[]{"instance"}).returns((TypeName)TypeUtils.genericType(TypeUtils.DELETE_WITH_OPTIONS, signature.entityRawClass)).build();
    }

    private static MethodSpec buildDeleteByPartition(EntityMetaCodeGen.EntityMetaSignature signature) {
        ParameterizedTypeName returnType = TypeUtils.genericType(TypeUtils.DELETE_BY_PARTITION_WITH_OPTIONS, signature.entityRawClass);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"deleteByPartitionKeys").addJavadoc("Delete a whole partition using the partition key", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$T keys = new $T<>()", new Object[]{TypeUtils.LIST_OBJECT, TypeUtils.ARRAY_LIST}).addStatement("$T encodedKeys = new $T<>()", new Object[]{TypeUtils.LIST_OBJECT, TypeUtils.ARRAY_LIST});
        signature.fieldMetaSignatures.stream().filter(x -> x.context.columnType == ColumnType.PARTITION).map(x -> Tuple3.of((Object)x.context.fieldName, (Object)x.sourceType, (Object)((PartitionKeyInfo)x.context.columnInfo))).sorted(PARTITION_KEY_SORTER).forEach(tuple -> builder.addJavadoc("@param $L partition key '$L'", new Object[]{tuple._1(), tuple._1()}).addParameter((TypeName)tuple._2(), (String)tuple._1(), new Modifier[]{Modifier.FINAL}).addStatement("$T.validateNotNull($L, $S, $S)", new Object[]{TypeUtils.VALIDATOR, tuple._1(), "Partition key '%s' should not be null", tuple._1()}).addStatement("keys.add($L)", new Object[]{tuple._1()}).addStatement("encodedKeys.add($L.$L.encodeFromJava($N, cassandraOptions))", new Object[]{signature.className + "_AchillesMeta", tuple._1(), tuple._1()}));
        builder.addJavadoc("@return DeleteByPartitionWithOptions<$T>", new Object[]{signature.entityRawClass});
        builder.addStatement("final Object[] partitionKeys = keys.toArray()", new Object[0]).addStatement("final Object[] encodedPartitionKeys = encodedKeys.toArray()", new Object[0]).addStatement("return new $T(meta, rte, partitionKeys, encodedPartitionKeys, cassandraOptions)", new Object[]{returnType}).returns((TypeName)returnType);
        return builder.build();
    }
}

