/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codegen;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.codegen.meta.EntityMetaCodeGen;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;

public class ManagerCodeGen {
    static ManagerAndDSLClasses buildManager(GlobalParsingContext context, AptUtils aptUtils, EntityMetaCodeGen.EntityMetaSignature signature) {
        ArrayList<TypeSpec> classes = new ArrayList<TypeSpec>();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(signature.className + "_Manager")).superclass((TypeName)TypeUtils.genericType(TypeUtils.ABSTRACT_MANAGER, signature.entityRawClass)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(ManagerCodeGen.buildConstructor(signature)).addMethod(ManagerCodeGen.buildCRUD(signature)).addMethod(ManagerCodeGen.buildDSL(signature)).addMethod(ManagerCodeGen.buildRawQuery(signature)).addField(ManagerCodeGen.buildExactEntityMetaField(signature));
        TypeSpec crudClass = context.crudAPICodeGen().buildCRUDClass(signature);
        TypeSpec.Builder dslClass = TypeSpec.classBuilder((String)(signature.className + "_DSL")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(ManagerCodeGen.buildSelectMethod(signature, "_Select"));
        classes.add(context.selectDSLCodeGen().buildSelectClass(context, signature));
        if (signature.isTable()) {
            dslClass.addMethod(ManagerCodeGen.buildDeleteMethod(signature)).addMethod(ManagerCodeGen.buildUpdateMethod(signature));
            classes.add(context.deleteDSLCodeGen().buildDeleteClass(signature, context.deleteWhereDSLCodeGen()));
            classes.add(context.updateDSLCodeGen().buildUpdateClass(aptUtils, signature, context.updateWhereDSLCodeGen()));
            if (signature.hasStatic()) {
                classes.add(context.deleteDSLCodeGen().buildDeleteStaticClass(signature, context.deleteWhereDSLCodeGen()));
                classes.add(context.updateDSLCodeGen().buildUpdateStaticClass(aptUtils, signature, context.updateWhereDSLCodeGen()));
                dslClass.addMethod(ManagerCodeGen.buildDeleteStaticMethod(signature));
                dslClass.addMethod(ManagerCodeGen.buildUpdateStaticMethod(signature));
            }
        }
        if (signature.hasIndex() && signature.isTable()) {
            builder.addMethod(ManagerCodeGen.buildINDEX(signature));
            TypeSpec.Builder indexClass = TypeSpec.classBuilder((String)(signature.className + "_INDEX")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(ManagerCodeGen.buildSelectMethod(signature, "_SelectIndex"));
            builder.addType(indexClass.build());
            classes.add(context.indexSelectDSLCodeGen().buildSelectClass(context, signature));
        }
        TypeSpec.Builder queryClass = TypeSpec.classBuilder((String)(signature.className + "_RAW_QUERY")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        ManagerCodeGen.buildRawQueryMethods(signature).forEach(arg_0 -> ((TypeSpec.Builder)queryClass).addMethod(arg_0));
        builder.addType(crudClass);
        builder.addType(dslClass.build());
        builder.addType(queryClass.build());
        return new ManagerAndDSLClasses(builder.build(), classes);
    }

    private static MethodSpec buildConstructor(EntityMetaCodeGen.EntityMetaSignature signature) {
        String entityMetaClassName = signature.className + "_AchillesMeta";
        ClassName entityMetaExactType = ClassName.get((String)"info.archinnov.achilles.generated.meta.entity", (String)entityMetaClassName, (String[])new String[0]);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeUtils.classTypeOf(signature.entityRawClass), "entityClass", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)entityMetaExactType, "meta", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)TypeUtils.RUNTIME_ENGINE, "rte", new Modifier[]{Modifier.FINAL}).addStatement("super($N, $N, $N)", new Object[]{"entityClass", "meta", "rte"}).addStatement("this.meta = meta", new Object[0]).build();
    }

    private static MethodSpec buildCRUD(EntityMetaCodeGen.EntityMetaSignature signature) {
        ClassName crudClass = ClassName.get((String)"info.archinnov.achilles.generated.manager", (String)(signature.className + "_Manager"), (String[])new String[]{signature.className + "_CRUD"});
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"crud").addJavadoc("Provide CRUD operations: <br/>\n", new Object[0]).addJavadoc("<ul>\n", new Object[0]).addJavadoc("   <li>FIND BY ID</li>\n", new Object[0]);
        if (signature.isTable()) {
            builder.addJavadoc("   <li>INSERT</li>\n", new Object[0]).addJavadoc("   <li>INSERT STATIC</li>\n", new Object[0]).addJavadoc("   <li>INSERT IF NOT EXISTS</li>\n", new Object[0]).addJavadoc("   <li>DELETE BY ID</li>\n", new Object[0]).addJavadoc("   <li>DELETE BY ID IF NOT EXISTS</li>\n", new Object[0]).addJavadoc("   <li>DELETE BY PARTITION</li>\n", new Object[0]);
        }
        builder.addJavadoc("</ul>\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T()", new Object[]{crudClass}).returns((TypeName)crudClass);
        return builder.build();
    }

    private static MethodSpec buildDSL(EntityMetaCodeGen.EntityMetaSignature signature) {
        ClassName dslClass = ClassName.get((String)"info.archinnov.achilles.generated.manager", (String)(signature.className + "_Manager"), (String[])new String[]{signature.className + "_DSL"});
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"dsl").addJavadoc("Provide DSL methods: <br/>\n", new Object[0]).addJavadoc("<ul>\n", new Object[0]).addJavadoc("   <li>SELECT</li>\n", new Object[0]).addJavadoc("   <li>ITERATION ON SELECT</li>\n", new Object[0]);
        if (signature.isTable()) {
            builder.addJavadoc("   <li>UPDATE</li>\n", new Object[0]).addJavadoc("   <li>DELETE</li>\n", new Object[0]);
        }
        builder.addJavadoc("</ul>\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T()", new Object[]{dslClass}).returns((TypeName)dslClass);
        return builder.build();
    }

    private static MethodSpec buildINDEX(EntityMetaCodeGen.EntityMetaSignature signature) {
        ClassName indexDslClass = ClassName.get((String)"info.archinnov.achilles.generated.manager", (String)(signature.className + "_Manager"), (String[])new String[]{signature.className + "_INDEX"});
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"indexed").addJavadoc("Provide INDEX query methods: <br/>\n", new Object[0]).addJavadoc("<ul>\n", new Object[0]).addJavadoc("   <li>SELECT</li>\n", new Object[0]).addJavadoc("   <li>ITERATION ON SELECT</li>\n", new Object[0]);
        builder.addJavadoc("</ul>\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T()", new Object[]{indexDslClass}).returns((TypeName)indexDslClass);
        return builder.build();
    }

    private static MethodSpec buildRawQuery(EntityMetaCodeGen.EntityMetaSignature signature) {
        ClassName dslClass = ClassName.get((String)"info.archinnov.achilles.generated.manager", (String)(signature.className + "_Manager"), (String[])new String[]{signature.className + "_RAW_QUERY"});
        return MethodSpec.methodBuilder((String)"raw").addJavadoc("Provide Raw query methods: <br/>\n", new Object[0]).addJavadoc("<ul>\n", new Object[0]).addJavadoc("   <li>Typed Queries (for SELECT only)</li>\n", new Object[0]).addJavadoc("   <li>Native Queries (for any kind of statement)</li>\n", new Object[0]).addJavadoc("</ul>\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T()", new Object[]{dslClass}).returns((TypeName)dslClass).build();
    }

    private static MethodSpec buildSelectMethod(EntityMetaCodeGen.EntityMetaSignature signature, String suffix) {
        ClassName selectTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(signature.className + suffix), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"select").addJavadoc("Generate a <strong>SELECT</strong> statement", new Object[0]).addJavadoc("@return $T", new Object[]{selectTypeName}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T(rte, meta)", new Object[]{selectTypeName}).returns((TypeName)selectTypeName).build();
    }

    private static MethodSpec buildDeleteMethod(EntityMetaCodeGen.EntityMetaSignature signature) {
        ClassName deleteTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(signature.className + "_Delete"), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"delete").addJavadoc("Generate a <strong>DELETE</strong> statement", new Object[0]).addJavadoc("@return $T", new Object[]{deleteTypeName}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T(rte, meta)", new Object[]{deleteTypeName}).returns((TypeName)deleteTypeName).build();
    }

    private static MethodSpec buildDeleteStaticMethod(EntityMetaCodeGen.EntityMetaSignature signature) {
        ClassName deleteStaticTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(signature.className + "_DeleteStatic"), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"deleteStatic").addJavadoc("Generate a <strong>DELETE</strong> statement for <strong>static</strong> columns only", new Object[0]).addJavadoc("(requiring only partition key(s))", new Object[0]).addJavadoc("@return $T", new Object[]{deleteStaticTypeName}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T(rte, meta)", new Object[]{deleteStaticTypeName}).returns((TypeName)deleteStaticTypeName).build();
    }

    private static MethodSpec buildUpdateMethod(EntityMetaCodeGen.EntityMetaSignature signature) {
        ClassName updateTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(signature.className + "_Update"), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"update").addJavadoc("Generate an <strong>UPDATE</strong> statement", new Object[0]).addJavadoc("@return $T", new Object[]{updateTypeName}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T(rte, meta)", new Object[]{updateTypeName}).returns((TypeName)updateTypeName).build();
    }

    private static MethodSpec buildUpdateStaticMethod(EntityMetaCodeGen.EntityMetaSignature signature) {
        ClassName updateStaticTypeName = ClassName.get((String)"info.archinnov.achilles.generated.dsl", (String)(signature.className + "_UpdateStatic"), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"updateStatic").addJavadoc("Generate an <strong>UPDATE</strong> statement for <strong>static</strong> columns only", new Object[0]).addJavadoc("(requiring only partition key(s))", new Object[0]).addJavadoc("@return $T", new Object[]{updateStaticTypeName}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return new $T(rte, meta)", new Object[]{updateStaticTypeName}).returns((TypeName)updateStaticTypeName).build();
    }

    private static List<MethodSpec> buildRawQueryMethods(EntityMetaCodeGen.EntityMetaSignature signature) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(MethodSpec.methodBuilder((String)"typedQueryForSelect").addJavadoc("Execute the bound statement and map the result back into an instance of $T <br/>\n", new Object[]{signature.entityRawClass}).addJavadoc("Remark: the bound statement should be a <strong>SELECT</strong> statement", new Object[0]).addJavadoc("@param boundStatement a bound statement", new Object[0]).addJavadoc("@return $T", new Object[]{TypeUtils.genericType(TypeUtils.TYPED_QUERY, signature.entityRawClass)}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.BOUND_STATEMENT, "boundStatement", new Modifier[0]).addStatement("return typedQueryForSelectInternal($N)", new Object[]{"boundStatement"}).returns((TypeName)TypeUtils.genericType(TypeUtils.TYPED_QUERY, signature.entityRawClass)).build());
        methods.add(MethodSpec.methodBuilder((String)"typedQueryForSelect").addJavadoc("Execute the prepared statement and map the result back into an instance of $T <br/>\n", new Object[]{signature.entityRawClass}).addJavadoc("Remark: the prepared statement should be a <strong>SELECT</strong> statement", new Object[0]).addJavadoc("@param preparedStatement a prepared statement", new Object[0]).addJavadoc("@return $T", new Object[]{TypeUtils.genericType(TypeUtils.TYPED_QUERY, signature.entityRawClass)}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.PREPARED_STATEMENT, "preparedStatement", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of((TypeName)TypeName.OBJECT), "encodedBoundValues", new Modifier[0]).varargs().addStatement("return typedQueryForSelectInternal($N, $N)", new Object[]{"preparedStatement", "encodedBoundValues"}).returns((TypeName)TypeUtils.genericType(TypeUtils.TYPED_QUERY, signature.entityRawClass)).build());
        methods.add(MethodSpec.methodBuilder((String)"typedQueryForSelect").addJavadoc("Execute the regular statement and map the result back into an instance of $T <br/>\n", new Object[]{signature.entityRawClass}).addJavadoc("Remark: the regular statement should be a <strong>SELECT</strong> statement", new Object[0]).addJavadoc("@param regularStatement a regular statement", new Object[0]).addJavadoc("@return $T", new Object[]{TypeUtils.genericType(TypeUtils.TYPED_QUERY, signature.entityRawClass)}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.REGULAR_STATEMENT, "regularStatement", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of((TypeName)TypeName.OBJECT), "encodedBoundValues", new Modifier[0]).varargs().addStatement("return typedQueryForSelectInternal($N, $N)", new Object[]{"regularStatement", "encodedBoundValues"}).returns((TypeName)TypeUtils.genericType(TypeUtils.TYPED_QUERY, signature.entityRawClass)).build());
        methods.add(MethodSpec.methodBuilder((String)"nativeQuery").addJavadoc("Execute the native bound statement", new Object[0]).addJavadoc("@param boundStatement a bound statement", new Object[0]).addJavadoc("@return $T", new Object[]{TypeUtils.NATIVE_QUERY}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.BOUND_STATEMENT, "boundStatement", new Modifier[0]).addStatement("return nativeQueryInternal($N)", new Object[]{"boundStatement"}).returns((TypeName)TypeUtils.NATIVE_QUERY).build());
        methods.add(MethodSpec.methodBuilder((String)"nativeQuery").addJavadoc("Execute the native prepared statement", new Object[0]).addJavadoc("@param preparedStatement a prepared statement", new Object[0]).addJavadoc("@return $T", new Object[]{TypeUtils.NATIVE_QUERY}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.PREPARED_STATEMENT, "preparedStatement", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of((TypeName)TypeName.OBJECT), "encodedBoundValues", new Modifier[0]).varargs().addStatement("return nativeQueryInternal($N, $N)", new Object[]{"preparedStatement", "encodedBoundValues"}).returns((TypeName)TypeUtils.NATIVE_QUERY).build());
        methods.add(MethodSpec.methodBuilder((String)"nativeQuery").addJavadoc("Execute the native regular statement", new Object[0]).addJavadoc("@param regularStatement a regular statement", new Object[0]).addJavadoc("@return $T", new Object[]{TypeUtils.NATIVE_QUERY}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeUtils.REGULAR_STATEMENT, "regularStatement", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of((TypeName)TypeName.OBJECT), "encodedBoundValues", new Modifier[0]).varargs().addStatement("return nativeQueryInternal($N, $N)", new Object[]{"regularStatement", "encodedBoundValues"}).returns((TypeName)TypeUtils.NATIVE_QUERY).build());
        return methods;
    }

    private static FieldSpec buildExactEntityMetaField(EntityMetaCodeGen.EntityMetaSignature signature) {
        String entityMetaClassName = signature.className + "_AchillesMeta";
        ClassName entityMetaExactType = ClassName.get((String)"info.archinnov.achilles.generated.meta.entity", (String)entityMetaClassName, (String[])new String[0]);
        return FieldSpec.builder((TypeName)entityMetaExactType, (String)"meta", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).build();
    }

    public static class ManagerAndDSLClasses {
        public final TypeSpec managerClass;
        public final List<TypeSpec> dslClasses;

        public ManagerAndDSLClasses(TypeSpec managerClass, List<TypeSpec> dslClasses) {
            this.managerClass = managerClass;
            this.dslClasses = dslClasses;
        }
    }
}

