/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import info.archinnov.achilles.exception.AchillesTranscodingException;
import info.archinnov.achilles.type.codec.Codec;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONCodec<TYPE>
implements Codec<TYPE, String> {
    public static final TypeFactory TYPE_FACTORY_INSTANCE = TypeFactory.defaultInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONCodec.class);
    private final Class<?> sourceType;
    private final JavaType exactType;
    private ObjectMapper objectMapper;

    public JSONCodec(Class<?> sourceType, JavaType exactType) {
        this.sourceType = sourceType;
        this.exactType = exactType;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Class<TYPE> sourceType() {
        return this.sourceType;
    }

    public Class<String> targetType() {
        return String.class;
    }

    public String encode(TYPE fromJava) throws AchillesTranscodingException {
        if (fromJava == null) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encoding object %s to JSON", fromJava));
        }
        try {
            return this.objectMapper.writeValueAsString(fromJava);
        }
        catch (JsonProcessingException e) {
            throw new AchillesTranscodingException((Throwable)e);
        }
    }

    public TYPE decode(String fromCassandra) throws AchillesTranscodingException {
        if (fromCassandra == null) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decoding object type %s from JSON %s", this.exactType, fromCassandra));
        }
        try {
            return (TYPE)this.objectMapper.readValue(fromCassandra, this.exactType);
        }
        catch (IOException e) {
            throw new AchillesTranscodingException((Throwable)e);
        }
    }
}

