/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.codec;

import com.datastax.driver.core.utils.Bytes;
import info.archinnov.achilles.exception.AchillesTranscodingException;
import info.archinnov.achilles.type.codec.Codec;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayCodec
implements Codec<Byte[], ByteBuffer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteArrayCodec.class);

    public Class<Byte[]> sourceType() {
        return Byte[].class;
    }

    public Class<ByteBuffer> targetType() {
        return ByteBuffer.class;
    }

    public ByteBuffer encode(Byte[] fromJava) throws AchillesTranscodingException {
        if (fromJava == null) {
            return null;
        }
        byte[] bytesPrimitive = new byte[fromJava.length];
        int i = 0;
        Byte[] byteArray = fromJava;
        int n = byteArray.length;
        for (int j = 0; j < n; ++j) {
            byte b = byteArray[j];
            bytesPrimitive[i++] = b;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Encoding Byte[] '%s' to ByteBuffer", Bytes.toHexString((ByteBuffer)ByteBuffer.wrap(bytesPrimitive).duplicate())));
        }
        return ByteBuffer.wrap(bytesPrimitive);
    }

    public Byte[] decode(ByteBuffer fromCassandra) {
        if (fromCassandra == null) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Decoding ByteBuffer '%s' to Byte[]", Bytes.toHexString((ByteBuffer)fromCassandra.duplicate())));
        }
        return this.readByteBuffer(fromCassandra);
    }

    private Byte[] readByteBuffer(Object fromCassandra) {
        ByteBuffer byteBuffer = (ByteBuffer)fromCassandra;
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        Byte[] byteObjects = new Byte[bytes.length];
        int i = 0;
        for (byte b : bytes) {
            byteObjects[i++] = b;
        }
        return byteObjects;
    }
}

