/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.cache;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internals.cache.CacheKey;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementsCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementsCache.class);
    private final Cache<String, PreparedStatement> dynamicCache;
    private final Cache<CacheKey, PreparedStatement> staticCache;
    private final int maxLRUCacheSize;

    public StatementsCache(int maxLRUCacheSize) {
        this.maxLRUCacheSize = maxLRUCacheSize;
        this.dynamicCache = CacheBuilder.newBuilder().maximumSize((long)maxLRUCacheSize).build();
        this.staticCache = CacheBuilder.newBuilder().build();
    }

    public void putStaticCache(CacheKey cacheKey, Callable<PreparedStatement> psSupplier) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Putting static cache for key %s", cacheKey));
            }
            this.staticCache.get((Object)cacheKey, psSupplier);
        }
        catch (ExecutionException e) {
            throw new AchillesException((Throwable)e);
        }
    }

    public PreparedStatement getStaticCache(CacheKey cacheKey) {
        PreparedStatement preparedStatement = (PreparedStatement)this.staticCache.getIfPresent((Object)cacheKey);
        if (preparedStatement == null) {
            throw new AchillesException(String.format("Cannot find static cached prepared statement for cache key %s", cacheKey));
        }
        return preparedStatement;
    }

    public PreparedStatement getDynamicCache(String queryString, Session session) {
        AtomicBoolean displayStats = new AtomicBoolean(false);
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.dynamicCache.get((Object)queryString, () -> {
                displayStats.getAndSet(true);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Preparing dynamic query : " + queryString);
                }
                return session.prepare(queryString);
            });
            if (displayStats.get()) {
                this.displayCacheStatistics();
            }
            return preparedStatement;
        }
        catch (ExecutionException e) {
            throw new AchillesException((Throwable)e);
        }
    }

    private void displayCacheStatistics() {
        long cacheSize = this.dynamicCache.size();
        CacheStats cacheStats = this.dynamicCache.stats();
        LOGGER.info("Total LRU cache size {}", (Object)cacheSize);
        if ((double)cacheSize > (double)this.maxLRUCacheSize * 0.8) {
            LOGGER.warn("Warning, the LRU prepared statements cache is over 80% full");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cache statistics :");
            LOGGER.debug("\t\t- hits count : {}", (Object)cacheStats.hitCount());
            LOGGER.debug("\t\t- hits rate : {}", (Object)cacheStats.hitRate());
            LOGGER.debug("\t\t- miss count : {}", (Object)cacheStats.missCount());
            LOGGER.debug("\t\t- miss rate : {}", (Object)cacheStats.missRate());
            LOGGER.debug("\t\t- eviction count : {}", (Object)cacheStats.evictionCount());
            LOGGER.debug("\t\t- load count : {}", (Object)cacheStats.loadCount());
            LOGGER.debug("\t\t- load success count : {}", (Object)cacheStats.loadSuccessCount());
            LOGGER.debug("\t\t- load exception count : {}", (Object)cacheStats.loadExceptionCount());
            LOGGER.debug("\t\t- total load time : {}", (Object)cacheStats.totalLoadTime());
            LOGGER.debug("\t\t- average load penalty : {}", (Object)cacheStats.averageLoadPenalty());
            LOGGER.debug("");
            LOGGER.debug("");
        }
    }
}

