/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.apt.processors.meta;

import com.google.auto.service.AutoService;
import com.google.common.collect.Sets;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import info.archinnov.achilles.annotations.CodecRegistry;
import info.archinnov.achilles.annotations.CompileTimeConfig;
import info.archinnov.achilles.annotations.FunctionRegistry;
import info.archinnov.achilles.annotations.MaterializedView;
import info.archinnov.achilles.annotations.Table;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.cassandra_version.CassandraFeature;
import info.archinnov.achilles.internals.cassandra_version.InternalCassandraVersion;
import info.archinnov.achilles.internals.codegen.ManagerFactoryBuilderCodeGen;
import info.archinnov.achilles.internals.codegen.ManagerFactoryCodeGen;
import info.archinnov.achilles.internals.codegen.function.InternalSystemFunctionRegistry;
import info.archinnov.achilles.internals.codegen.meta.EntityMetaCodeGen;
import info.archinnov.achilles.internals.parser.CodecRegistryParser;
import info.archinnov.achilles.internals.parser.EntityParser;
import info.archinnov.achilles.internals.parser.FunctionParser;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.FunctionSignature;
import info.archinnov.achilles.internals.parser.context.FunctionsContext;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import info.archinnov.achilles.internals.utils.CollectionsHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.commons.io.FileUtils;

@AutoService(value=Processor.class)
public class AchillesProcessor
extends AbstractProcessor {
    protected AptUtils aptUtils;
    protected EntityParser entityParser;
    private boolean processed = false;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.aptUtils = new AptUtils(processingEnv.getElementUtils(), processingEnv.getTypeUtils(), processingEnv.getMessager(), processingEnv.getFiler());
        this.entityParser = new EntityParser(this.aptUtils);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!this.processed) {
            try {
                GlobalParsingContext globalContext = this.initGlobalParsingContext(annotations, roundEnv);
                this.validateCassandraVersionAgainstUsedAnnotations(annotations, globalContext);
                this.parseCodecRegistry(globalContext, annotations, roundEnv);
                List<EntityMetaCodeGen.EntityMetaSignature> tableAndViewSignatures = this.discoverAndValidateTablesAndViews(annotations, roundEnv, globalContext);
                FunctionsContext udfContext = this.parseAndValidateFunctionRegistry(globalContext, annotations, roundEnv, tableAndViewSignatures);
                TypeSpec managerFactoryBuilder = ManagerFactoryBuilderCodeGen.buildInstance(globalContext);
                ManagerFactoryCodeGen.ManagersAndDSLClasses managersAndDSLClasses = ManagerFactoryCodeGen.buildInstance(this.aptUtils, tableAndViewSignatures, udfContext, globalContext);
                this.aptUtils.printNote("[Achilles] Reading previously generated source files (if exist)", new Object[0]);
                try {
                    FileObject resource = this.aptUtils.filer.getResource(StandardLocation.SOURCE_OUTPUT, "info.archinnov.achilles.generated", globalContext.managerFactoryBuilderClassName());
                    File generatedSourceFolder = new File(resource.toUri().getRawPath().replaceAll("(.+/info/archinnov/achilles/generated/).+", "$1"));
                    this.aptUtils.printNote("[Achilles] Cleaning previously generated source files folder : '%s'", generatedSourceFolder.getPath());
                    FileUtils.deleteDirectory((File)generatedSourceFolder);
                }
                catch (IOException ioe) {
                    this.aptUtils.printNote("[Achilles] No previously generated source files found, proceed to code generation", new Object[0]);
                }
                this.aptUtils.printNote("[Achilles] Generating CQL compatible types (used by the application) as class for function calls", new Object[0]);
                for (TypeSpec typeSpec : globalContext.functionParameterTypesCodeGen().buildParameterTypesClasses(udfContext)) {
                    JavaFile.builder((String)"info.archinnov.achilles.generated.function", (TypeSpec)typeSpec).build().writeTo(this.aptUtils.filer);
                }
                this.aptUtils.printNote("[Achilles] Generating SystemFunctions", new Object[0]);
                JavaFile.builder((String)"info.archinnov.achilles.generated.function", (TypeSpec)globalContext.functionsRegistryCodeGen().generateFunctionsRegistryClass("SystemFunctions", InternalSystemFunctionRegistry.SYSTEM_FUNCTIONS)).build().writeTo(this.aptUtils.filer);
                if (globalContext.supportsFeature(CassandraFeature.UDF_UDA)) {
                    this.aptUtils.printNote("[Achilles] Generating FunctionsRegistry", new Object[0]);
                    JavaFile.builder((String)"info.archinnov.achilles.generated.function", (TypeSpec)globalContext.functionsRegistryCodeGen().generateFunctionsRegistryClass("FunctionsRegistry", udfContext.functionSignatures)).build().writeTo(this.aptUtils.filer);
                }
                this.aptUtils.printNote("[Achilles] Generating ManagerFactoryBuilder", new Object[0]);
                JavaFile.builder((String)"info.archinnov.achilles.generated", (TypeSpec)managerFactoryBuilder).build().writeTo(this.aptUtils.filer);
                this.aptUtils.printNote("[Achilles] Generating Manager factory class", new Object[0]);
                JavaFile.builder((String)"info.archinnov.achilles.generated", (TypeSpec)managersAndDSLClasses.managerFactoryClass).build().writeTo(this.aptUtils.filer);
                this.aptUtils.printNote("[Achilles] Generating UDT meta classes", new Object[0]);
                for (TypeSpec typeSpec : globalContext.udtTypes.values()) {
                    JavaFile.builder((String)"info.archinnov.achilles.generated.meta.udt", (TypeSpec)typeSpec).build().writeTo(this.aptUtils.filer);
                }
                this.aptUtils.printNote("[Achilles] Generating entity meta classes", new Object[0]);
                for (EntityMetaCodeGen.EntityMetaSignature signature : tableAndViewSignatures) {
                    JavaFile.builder((String)"info.archinnov.achilles.generated.meta.entity", (TypeSpec)signature.sourceCode).build().writeTo(this.aptUtils.filer);
                }
                this.aptUtils.printNote("[Achilles] Generating manager classes", new Object[0]);
                for (TypeSpec manager : managersAndDSLClasses.managerClasses) {
                    JavaFile.builder((String)"info.archinnov.achilles.generated.manager", (TypeSpec)manager).build().writeTo(this.aptUtils.filer);
                }
                this.aptUtils.printNote("[Achilles] Generating DSL classes", new Object[0]);
                for (TypeSpec dsl : managersAndDSLClasses.dslClasses) {
                    JavaFile.builder((String)"info.archinnov.achilles.generated.dsl", (TypeSpec)dsl).build().writeTo(this.aptUtils.filer);
                }
            }
            catch (AchillesException e) {
                e.printStackTrace();
                this.aptUtils.printError("Error while parsing: %s", new Object[]{e.getMessage(), e});
            }
            catch (IllegalStateException e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                this.aptUtils.printError("Error while parsing: %s", sw.toString(), e);
            }
            catch (IOException e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                this.aptUtils.printError("Fail generating source file : %s", sw.toString(), e);
            }
            catch (Throwable throwable) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                throwable.printStackTrace(pw);
                this.aptUtils.printError("Fail generating source file : %s", sw.toString(), throwable);
            }
            finally {
                this.processed = true;
            }
        }
        return true;
    }

    private void validateCassandraVersionAgainstUsedAnnotations(Set<? extends TypeElement> annotations, GlobalParsingContext parsingContext) {
        InternalCassandraVersion version = parsingContext.cassandraVersion;
        this.aptUtils.validateFalse(AptUtils.containsElementsAnnotatedBy(annotations, FunctionRegistry.class) && !version.supportsFeature(CassandraFeature.UDF_UDA), "Cassandra version %s does not support feature %s so @FunctionRegistry cannot be used", version.version(), CassandraFeature.UDF_UDA.name());
        this.aptUtils.validateFalse(AptUtils.containsElementsAnnotatedBy(annotations, MaterializedView.class) && !version.supportsFeature(CassandraFeature.MATERIALIZED_VIEW), "Cassandra version %s does not support feature %s so @MaterializedView cannot be used", version.version(), CassandraFeature.MATERIALIZED_VIEW.name());
    }

    private GlobalParsingContext initGlobalParsingContext(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.aptUtils.validateFalse(AptUtils.countElementsAnnotatedBy(annotations, CompileTimeConfig.class) > 1L, "Cannot declare more than one @%s in a single compilation unit", CompileTimeConfig.class.getSimpleName());
        GlobalParsingContext context = AptUtils.getTypesAnnotatedByAsStream(annotations, roundEnv, CompileTimeConfig.class).map(typeElement -> this.aptUtils.getAnnotationOnClass((TypeElement)typeElement, CompileTimeConfig.class).get()).findFirst().map(annot -> GlobalParsingContext.fromCompileTimeConfig(annot)).orElseGet(GlobalParsingContext::defaultContext);
        context.validateProjectName(this.aptUtils);
        return context;
    }

    private FunctionsContext parseAndValidateFunctionRegistry(GlobalParsingContext context, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, List<EntityMetaCodeGen.EntityMetaSignature> tableAndViewSignatures) {
        List<FunctionSignature> udfSignatures = AptUtils.getTypesAnnotatedByAsStream(annotations, roundEnv, FunctionRegistry.class).flatMap(x -> FunctionParser.parseFunctionRegistryAndValidateTypes(this.aptUtils, x, context).stream()).collect(Collectors.toList());
        FunctionParser.validateNoDuplicateDeclaration(this.aptUtils, udfSignatures);
        Set functionParameterTypes = udfSignatures.stream().flatMap(x -> x.sourceParameterTypes.stream().map(TypeName::box)).collect(Collectors.toSet());
        Set functionReturnTypes = udfSignatures.stream().map(x -> x.sourceReturnType.box()).collect(Collectors.toSet());
        Set entityColumnTargetTypes = tableAndViewSignatures.stream().filter(EntityMetaCodeGen.EntityMetaSignature::isTable).flatMap(x -> x.fieldMetaSignatures.stream()).map(x -> x.sourceType).collect(Collectors.toSet());
        return new FunctionsContext(udfSignatures, CollectionsHelper.appendAll(functionParameterTypes, functionReturnTypes, entityColumnTargetTypes, TypeUtils.NATIVE_TYPES_2_1));
    }

    private List<EntityMetaCodeGen.EntityMetaSignature> discoverAndValidateTablesAndViews(Set<? extends TypeElement> annotatedTypes, RoundEnvironment roundEnv, GlobalParsingContext parsingContext) {
        List<TypeElement> tableTypes = AptUtils.getTypesAnnotatedBy(annotatedTypes, roundEnv, Table.class);
        List<TypeElement> viewTypes = AptUtils.getTypesAnnotatedBy(annotatedTypes, roundEnv, MaterializedView.class);
        List<TypeElement> types = CollectionsHelper.appendAll(tableTypes, viewTypes);
        parsingContext.beanValidator().validateEntityNames(this.aptUtils, types);
        List<EntityMetaCodeGen.EntityMetaSignature> tableSignatures = tableTypes.stream().map(x -> this.entityParser.parseEntity((TypeElement)x, parsingContext)).collect(Collectors.toList());
        List<EntityMetaCodeGen.EntityMetaSignature> viewSignatures = parsingContext.supportsFeature(CassandraFeature.MATERIALIZED_VIEW) ? viewTypes.stream().map(x -> this.entityParser.parseView((TypeElement)x, parsingContext)).collect(Collectors.toList()) : Collections.EMPTY_LIST;
        List<EntityMetaCodeGen.EntityMetaSignature> tableAndViewSignatures = CollectionsHelper.appendAll(tableSignatures, viewSignatures);
        if (parsingContext.supportsFeature(CassandraFeature.MATERIALIZED_VIEW)) {
            parsingContext.beanValidator().validateViewsAgainstBaseTable(this.aptUtils, viewSignatures, tableSignatures);
        }
        return tableAndViewSignatures;
    }

    private void parseCodecRegistry(GlobalParsingContext parsingContext, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (AptUtils.containsElementsAnnotatedBy(annotations, CodecRegistry.class)) {
            this.aptUtils.printNote("[Achilles] Parsing compile-time codec registry", new Object[0]);
            new CodecRegistryParser(this.aptUtils).parseCodecs(roundEnv, parsingContext);
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Sets.newHashSet((Object[])new String[]{Table.class.getCanonicalName(), MaterializedView.class.getCanonicalName(), CodecRegistry.class.getCanonicalName(), FunctionRegistry.class.getCanonicalName(), CompileTimeConfig.class.getCanonicalName()});
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

