/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.bootstrap;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Session;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.configuration.ArgumentExtractor;
import info.archinnov.achilles.configuration.ConfigurationParameters;
import info.archinnov.achilles.internals.cache.StatementsCache;
import info.archinnov.achilles.internals.context.ConfigurationContext;
import info.archinnov.achilles.internals.runtime.AbstractManagerFactory;
import info.archinnov.achilles.internals.types.ConfigMap;
import info.archinnov.achilles.json.JacksonMapperFactory;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.type.codec.Codec;
import info.archinnov.achilles.type.codec.CodecSignature;
import info.archinnov.achilles.type.interceptor.Interceptor;
import info.archinnov.achilles.type.strategy.InsertStrategy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.validation.Validator;

public abstract class AbstractManagerFactoryBuilder<T extends AbstractManagerFactoryBuilder<T>> {
    protected ConfigMap configMap = new ConfigMap();
    protected Cluster cluster;

    protected AbstractManagerFactoryBuilder(Cluster cluster) {
        this.cluster = cluster;
        info.archinnov.achilles.validation.Validator.validateNotNull((Object)cluster, (String)"Cluster object should not be null", (Object[])new Object[0]);
    }

    protected static ConfigurationContext buildConfigContext(Cluster cluster, ConfigMap configMap) {
        return ArgumentExtractor.initConfigContext(cluster, configMap);
    }

    protected abstract T getThis();

    public abstract <M extends AbstractManagerFactory> M build();

    public T withJacksonMapper(ObjectMapper objectMapper) {
        this.configMap.put(ConfigurationParameters.JACKSON_MAPPER, objectMapper);
        return this.getThis();
    }

    public T withJacksonMapperFactory(JacksonMapperFactory jacksonMapperFactory) {
        this.configMap.put(ConfigurationParameters.JACKSON_MAPPER_FACTORY, jacksonMapperFactory);
        return this.getThis();
    }

    public T withDefaultReadConsistency(ConsistencyLevel defaultReadConsistency) {
        this.configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_READ_DEFAULT, defaultReadConsistency);
        return this.getThis();
    }

    public T withDefaultWriteConsistency(ConsistencyLevel defaultWriteConsistency) {
        this.configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_WRITE_DEFAULT, defaultWriteConsistency);
        return this.getThis();
    }

    public T withDefaultSerialConsistency(ConsistencyLevel defaultSerialConsistency) {
        this.configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_SERIAL_DEFAULT, defaultSerialConsistency);
        return this.getThis();
    }

    public T withDefaultReadConsistencyMap(Map<String, ConsistencyLevel> readConsistencyMap) {
        this.configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_READ_MAP, readConsistencyMap);
        return this.getThis();
    }

    public T withDefaultWriteConsistencyMap(Map<String, ConsistencyLevel> writeConsistencyMap) {
        this.configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_WRITE_MAP, writeConsistencyMap);
        return this.getThis();
    }

    public T withDefaultSerialConsistencyMap(Map<String, ConsistencyLevel> serialConsistencyMap) {
        this.configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_SERIAL_MAP, serialConsistencyMap);
        return this.getThis();
    }

    public T doForceSchemaCreation(boolean forceSchemaCreation) {
        this.configMap.put(ConfigurationParameters.FORCE_SCHEMA_GENERATION, forceSchemaCreation);
        return this.getThis();
    }

    public T validateSchema(boolean validateSchema) {
        this.configMap.put(ConfigurationParameters.VALIDATE_SCHEMA, validateSchema);
        return this.getThis();
    }

    public T withNativeSession(Session nativeSession) {
        this.configMap.put(ConfigurationParameters.NATIVE_SESSION, nativeSession);
        return this.getThis();
    }

    public T withDefaultKeyspaceName(String defaultKeyspaceName) {
        this.configMap.put(ConfigurationParameters.KEYSPACE_NAME, defaultKeyspaceName);
        return this.getThis();
    }

    public T withEventInterceptors(List<Interceptor<?>> interceptors) {
        this.configMap.put(ConfigurationParameters.EVENT_INTERCEPTORS, interceptors);
        return this.getThis();
    }

    public T withBeanValidation(boolean enableBeanValidation) {
        this.configMap.put(ConfigurationParameters.BEAN_VALIDATION_ENABLE, enableBeanValidation);
        return this.getThis();
    }

    public T withPostLoadBeanValidation(boolean enablePostLoadBeanValidation) {
        if (enablePostLoadBeanValidation) {
            info.archinnov.achilles.validation.Validator.validateTrue((this.configMap.containsKey((Object)ConfigurationParameters.BEAN_VALIDATION_ENABLE) && (Boolean)this.configMap.getTyped(ConfigurationParameters.BEAN_VALIDATION_ENABLE) != false ? 1 : 0) != 0, (String)"Before activating Post Load Bean Validation, you should activate first Bean Validation by calling 'withBeanValidation(true)' ", (Object[])new Object[0]);
        }
        this.configMap.put(ConfigurationParameters.POST_LOAD_BEAN_VALIDATION_ENABLE, enablePostLoadBeanValidation);
        return this.getThis();
    }

    public T withBeanValidator(Validator validator) {
        if (validator != null) {
            this.configMap.put(ConfigurationParameters.BEAN_VALIDATION_VALIDATOR, validator);
            this.configMap.put(ConfigurationParameters.BEAN_VALIDATION_ENABLE, true);
        }
        return this.getThis();
    }

    public T withMaxPreparedStatementCacheSize(int maxPreparedStatementCacheSize) {
        this.configMap.put(ConfigurationParameters.PREPARED_STATEMENTS_CACHE_SIZE, maxPreparedStatementCacheSize);
        return this.getThis();
    }

    public T withGlobalInsertStrategy(InsertStrategy globalInsertStrategy) {
        this.configMap.put(ConfigurationParameters.GLOBAL_INSERT_STRATEGY, globalInsertStrategy);
        return this.getThis();
    }

    public T withSchemaNameProvider(SchemaNameProvider schemaNameProvider) {
        this.configMap.put(ConfigurationParameters.SCHEMA_NAME_PROVIDER, schemaNameProvider);
        return this.getThis();
    }

    public T withDefaultExecutorService(ExecutorService executorService) {
        this.configMap.put(ConfigurationParameters.EXECUTOR_SERVICE, executorService);
        return this.getThis();
    }

    public T withExecutorServiceMinThreadCount(int minThreadCount) {
        this.configMap.put(ConfigurationParameters.DEFAULT_EXECUTOR_SERVICE_MIN_THREAD, minThreadCount);
        return this.getThis();
    }

    public T withExecutorServiceMaxThreadCount(int maxThreadCount) {
        this.configMap.put(ConfigurationParameters.DEFAULT_EXECUTOR_SERVICE_MAX_THREAD, maxThreadCount);
        return this.getThis();
    }

    public T withExecutorServiceThreadKeepAliveDuration(int keepAliveDuration) {
        this.configMap.put(ConfigurationParameters.DEFAULT_EXECUTOR_SERVICE_THREAD_KEEPALIVE, keepAliveDuration);
        return this.getThis();
    }

    public T withExecutorServiceThreadQueueSize(int threadQueueSize) {
        this.configMap.put(ConfigurationParameters.DEFAULT_EXECUTOR_SERVICE_QUEUE_SIZE, threadQueueSize);
        return this.getThis();
    }

    public T withExecutorServiceThreadFactory(ThreadFactory factory) {
        this.configMap.put(ConfigurationParameters.DEFAULT_EXECUTOR_SERVICE_THREAD_FACTORY, factory);
        return this.getThis();
    }

    public T withManagedEntityClasses(List<Class<?>> entityClasses) {
        this.configMap.put(ConfigurationParameters.MANAGED_ENTITIES, entityClasses);
        return this.getThis();
    }

    public T withManagedEntityClasses(Class<?> ... entityClasses) {
        this.configMap.put(ConfigurationParameters.MANAGED_ENTITIES, Arrays.asList(entityClasses));
        return this.getThis();
    }

    public T withStatementsCache(StatementsCache statementsCache) {
        this.configMap.put(ConfigurationParameters.STATEMENTS_CACHE, statementsCache);
        return this.getThis();
    }

    public T withParameter(ConfigurationParameters parameter, Object value) {
        this.configMap.put(parameter, value);
        return this.getThis();
    }

    public <FROM, TO> T withRuntimeCodec(CodecSignature<FROM, TO> codecSignature, Codec<FROM, TO> codec) {
        if (!this.configMap.containsKey((Object)ConfigurationParameters.RUNTIME_CODECS)) {
            this.configMap.put(ConfigurationParameters.RUNTIME_CODECS, new HashMap());
        }
        ((Map)this.configMap.getTyped(ConfigurationParameters.RUNTIME_CODECS)).put(codecSignature, codec);
        return this.getThis();
    }

    public T withRuntimeCodecs(Map<CodecSignature<?, ?>, Codec<?, ?>> runtimeCodecs) {
        if (!this.configMap.containsKey((Object)ConfigurationParameters.RUNTIME_CODECS)) {
            this.configMap.put(ConfigurationParameters.RUNTIME_CODECS, new HashMap());
        }
        ((Map)this.configMap.getTyped(ConfigurationParameters.RUNTIME_CODECS)).putAll(runtimeCodecs);
        return this.getThis();
    }

    public T withMaxDMLResultsDisplayed(int maxDMLResultsDisplayed) {
        this.configMap.put(ConfigurationParameters.DML_RESULTS_DISPLAY_SIZE, maxDMLResultsDisplayed);
        return this.getThis();
    }
}

