/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleTypeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TupleTypeBuilder.class);

    public static TupleType of(ProtocolVersion version, CodecRegistry registry, DataType ... dataTypes) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Create TupleType instance for data types %s", Arrays.stream(dataTypes).map(Object::toString).collect(Collectors.toList())));
        }
        return new TupleType(Arrays.asList(dataTypes), version, registry);
    }
}

