package com.meterware.servletunit;
/********************************************************************************************************************
* $Id: ServletUnitContext.java,v 1.7 2004/02/15 06:42:01 russgold Exp $
*
* Copyright (c) 2000-2004, Russell Gold
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated 
* documentation files (the "Software"), to deal in the Software without restriction, including without limitation 
* the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and
* to permit persons to whom the Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or substantial portions 
* of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
* THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
* CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
* DEALINGS IN THE SOFTWARE.
*
*******************************************************************************************************************/


import javax.servlet.http.HttpSession;
import java.util.*;
import java.util.Hashtable;

class ServletUnitContext {

    private SessionListenerDispatcher _listenerDispatcher;


    ServletUnitContext() {
        this( null, new SessionListenerDispatcher() {
            public void sendSessionCreated( HttpSession session ) {}
            public void sendSessionDestroyed( HttpSession session ) {}
            public void sendAttributeAdded( HttpSession session, String name, Object value ) {}
            public void sendAttributeReplaced( HttpSession session, String name, Object oldValue ) {}
            public void sendAttributeRemoved( HttpSession session, String name, Object oldValue ) {}
        } );
    }


    ServletUnitContext( String contextPath, SessionListenerDispatcher dispatcher ) {
        _contextPath = (contextPath != null ? contextPath : "");
        _listenerDispatcher = dispatcher;
    }


	Set getSessionIDs() {
		return _sessions.keySet();
	}


    /**
     * Returns the session with the specified ID, if any.
     **/
    ServletUnitHttpSession getSession( String id ) {
        return (ServletUnitHttpSession) _sessions.get( id );
    }


    /**
     * Creates a new session with a unique ID.
     **/
    ServletUnitHttpSession newSession() {
        ServletUnitHttpSession result = new ServletUnitHttpSession( _listenerDispatcher );
        _sessions.put( result.getId(), result );
        _listenerDispatcher.sendSessionCreated( result );
        return result;
    }

    /**
     * Returns the contextPath
     */
    String getContextPath() {
        return _contextPath;
    }


//------------------------------- private members ---------------------------


    private Hashtable _sessions = new Hashtable();

    private String _contextPath = null;


}
