/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.test;

import java.util.Date;
import java.util.Properties;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.howl.log.xa.XALogger;
import org.objectweb.howl.test.TestDriver;

public class XAWorker
extends Thread {
    final Properties config;
    byte[] commitData = new byte[80];
    byte[][] commitDataRecord = new byte[][]{this.commitData};
    byte[] doneData = null;
    byte[][] doneDataRecord = new byte[1][];
    int count = 200;
    boolean doTimeStamp = false;
    long latency = 0L;
    final TestDriver driver;
    final XALogger log;
    long bytesLogged = 0L;
    int tnl = 0;
    Exception exception = null;
    int transactions = 0;
    long delayBeforeDone = 0L;

    void parseProperties() {
        int ival;
        String val = null;
        String key = null;
        key = "msg.size";
        val = this.config.getProperty("msg.size").trim();
        if (val != null) {
            ival = Integer.parseInt(val);
            if (ival <= 0) {
                throw new IllegalArgumentException();
            }
            if (ival != this.commitData.length) {
                this.commitData = new byte[ival];
            }
        }
        key = "msg.count";
        val = this.config.getProperty("msg.count").trim();
        if (val != null) {
            ival = Integer.parseInt(val);
            if (ival <= 0) {
                throw new IllegalArgumentException();
            }
            this.count = ival;
        }
        key = "msg.timestamp";
        val = this.config.getProperty("msg.timestamp", "false").trim().toLowerCase();
        this.doTimeStamp = val.equals("true");
    }

    void initCommitData() {
        int msgSize = this.commitData.length;
        for (int i = 0; i < msgSize; ++i) {
            this.commitData[i] = (byte)(32 + i % 94);
        }
        this.commitData[msgSize - 2] = 13;
        this.commitData[msgSize - 1] = 10;
        String threadName = "[xxxx]COMMIT:" + Thread.currentThread().getName() + " ";
        this.tnl = threadName.length();
        if (this.tnl < this.commitData.length) {
            System.arraycopy(threadName.getBytes(), 0, this.commitData, 0, this.tnl);
        }
    }

    void initDoneData() {
        this.doneData = ("[xxxx]DONE  :" + Thread.currentThread().getName() + "\n").getBytes();
        this.doneDataRecord[0] = this.doneData;
    }

    XAWorker(TestDriver driver) {
        this.driver = driver;
        this.config = driver.getProperties();
        this.log = driver.getXALogger();
    }

    void setDelayBeforeDone(long delayBeforeDone) {
        this.delayBeforeDone = delayBeforeDone;
    }

    XACommittingTx logCommit(int id) throws LogException, Exception {
        byte[] now;
        int msg = id;
        for (int j = 4; j > 0; --j) {
            this.commitData[j] = (byte)(48 + msg % 10);
            msg /= 10;
        }
        if (this.doTimeStamp && (now = new Date().toString().getBytes()).length < this.commitData.length - this.tnl) {
            System.arraycopy(now, 0, this.commitData, this.tnl, now.length);
        }
        this.bytesLogged += (long)this.commitData.length;
        return this.log.putCommit(this.commitDataRecord);
    }

    void logDone(XACommittingTx tx) throws LogException, Exception {
        System.arraycopy(this.commitData, 1, this.doneData, 1, 4);
        this.log.putDone(this.doneDataRecord, tx);
        this.bytesLogged += (long)this.doneData.length;
        ++this.transactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.parseProperties();
        this.initCommitData();
        this.initDoneData();
        if (this.delayBeforeDone > 0L) {
            this.count = 4;
        }
        try {
            this.driver.getStartBarrier().barrier();
            for (int i = 0; i < this.count; ++i) {
                long startTime = System.currentTimeMillis();
                XACommittingTx tx = this.logCommit(i);
                if (this.delayBeforeDone > 0L) {
                    XAWorker.sleep(this.delayBeforeDone);
                }
                this.logDone(tx);
                this.latency += System.currentTimeMillis() - startTime;
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
        finally {
            this.driver.getStopBarrier().release();
        }
    }
}

