/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.xa.XALogger;
import org.objectweb.howl.test.Barrier;
import org.objectweb.howl.test.TestDriver;
import org.objectweb.howl.test.XAWorker;

public class XALoggerTest
extends TestCase
implements TestDriver {
    XALogger log = null;
    Configuration cfg = null;
    Properties prop = null;
    Barrier startBarrier = null;
    Barrier stopBarrier = null;
    int workers = 0;
    int delayedWorkers = 0;
    long delayBeforeDone = 500L;
    boolean autoMarkMode = true;

    public static void main(String[] args) {
        TestRunner.run((Class)XALoggerTest.class);
    }

    public final Properties getProperties() {
        return this.prop;
    }

    public final Barrier getStartBarrier() {
        return this.startBarrier;
    }

    public final Barrier getStopBarrier() {
        return this.stopBarrier;
    }

    public final XALogger getXALogger() {
        return this.log;
    }

    void parseProperties() throws FileNotFoundException, IOException {
        String val = null;
        String key = null;
        this.prop = new Properties();
        this.prop.load(new FileInputStream("conf/test.properties"));
        key = "XALoggerTest.workers";
        val = this.prop.getProperty("XALoggerTest.workers", "200");
        this.workers = Integer.parseInt(val);
        if (this.workers <= 0) {
            throw new IllegalArgumentException(key);
        }
        key = "XALoggerTest.delayedWorkers";
        val = this.prop.getProperty("XALoggerTest.delayedWorkers", "0");
        this.delayedWorkers = Integer.parseInt(val);
        if (this.delayedWorkers < 0) {
            throw new IllegalArgumentException(key);
        }
        key = "XALoggerTest.delayBeforeDone";
        val = this.prop.getProperty("XALoggerTest.delayBeforeDone", "500");
        this.delayBeforeDone = Long.parseLong(val);
        if (this.delayBeforeDone < 0L) {
            throw new IllegalArgumentException(key);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.parseProperties();
        this.cfg = new Configuration(new File("conf/log.properties"));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public XALoggerTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWorkers(int workers) throws LogException, Exception {
        if (workers <= 0) {
            throw new IllegalArgumentException();
        }
        XAWorker[] xaWorker = new XAWorker[workers];
        this.startBarrier = new Barrier(workers + 1);
        this.stopBarrier = new Barrier(workers + 1);
        for (int i = 0; i < workers; ++i) {
            XAWorker w;
            xaWorker[i] = w = new XAWorker(this);
            if (this.delayedWorkers > 0) {
                --this.delayedWorkers;
                w.setDelayBeforeDone(this.delayBeforeDone);
            }
            w.start();
        }
        Barrier i = this.startBarrier;
        synchronized (i) {
            while (this.startBarrier.getCount() > 1) {
                this.startBarrier.wait();
            }
        }
        long startTime = System.currentTimeMillis();
        this.startBarrier.barrier();
        this.stopBarrier.barrier();
        long stopTime = System.currentTimeMillis();
        long totalBytesLogged = 0L;
        int totalLatency = 0;
        int totalTransactions = 0;
        for (int i2 = 0; i2 < workers; ++i2) {
            XAWorker w = xaWorker[i2];
            totalBytesLogged += w.bytesLogged;
            totalLatency = (int)((long)totalLatency + w.latency);
            totalTransactions += w.transactions;
            if (w.exception == null) continue;
            w.exception.printStackTrace();
            throw w.exception;
        }
        long elapsedTime = stopTime - startTime;
        float avgLatency = (float)totalLatency / (float)totalTransactions;
        float txPerSecond = (float)((double)totalTransactions / ((double)elapsedTime / 1000.0));
        StringBuffer stats = new StringBuffer("<?xml version='1.0' ?>\n<TestResults>");
        stats.append("\n<TestMetrics>\n  <elapsedTime value='" + elapsedTime + "'>Elapsed time (ms) for run</elapsedTime>" + "\n  <totalTransactions value='" + totalTransactions + "'>Total number of transactions</totalTransactions>" + "\n  <txPerSecond value='" + txPerSecond + "'>Number of transactions per second</txPerSecond>" + "\n  <avgLatency value='" + avgLatency + "'>Average Latency</avgLatency>" + "\n</TestMetrics>");
        stats.append(this.log.getStats());
        stats.append("\n</TestResults>");
        System.out.println(stats.toString());
    }

    public void testSingleThread() throws LogException, Exception {
        this.log = new XALogger(this.cfg);
        this.log.open();
        this.log.setAutoMark(true);
        this.prop.setProperty("msg.count", "10");
        this.runWorkers(1);
        this.log.close();
    }

    public void testAutoMarkTrue() throws LogException, Exception {
        this.log = new XALogger(this.cfg);
        this.log.open();
        this.log.setAutoMark(true);
        this.runWorkers(this.workers);
        this.log.close();
    }

    public void testAutoMarkFalseOneDelayedWorker() throws LogException, Exception {
        this.log = new XALogger(this.cfg);
        this.log.open();
        this.log.setAutoMark(false);
        this.delayedWorkers = 1;
        this.runWorkers(this.workers);
        this.log.close();
    }

    public void testAutoMarkFalseFourDelayedWorker() throws LogException, Exception {
        this.log = new XALogger(this.cfg);
        this.log.open();
        this.log.setAutoMark(false);
        this.delayedWorkers = 4;
        this.runWorkers(this.workers);
        this.log.close();
    }
}

