/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogException;

public class ConfigurationTest
extends TestCase {
    Configuration cfg = null;
    Properties prop = null;
    PrintStream systemErr;

    public static void main(String[] args) {
        TestRunner.run((Class)ConfigurationTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.systemErr = System.err;
        this.prop = new Properties();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        System.setErr(this.systemErr);
    }

    public ConfigurationTest(String name) {
        super(name);
    }

    public void testListConfigDefault() throws LogException, Exception {
        System.setErr(null);
        this.cfg = new Configuration(this.prop);
    }

    public void testListConfigTrue() throws LogException, Exception {
        System.setErr(null);
        this.prop.setProperty("listConfig", "true");
        try {
            this.cfg = new Configuration(this.prop);
            ConfigurationTest.fail((String)"Expecting NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testListConfigFalse() throws LogException, Exception {
        System.setErr(null);
        this.prop.setProperty("listConfig", "false");
        this.cfg = new Configuration(this.prop);
    }

    public void testBufferSize_1() throws LogException, Exception {
        this.prop.setProperty("bufferSize", "1");
        this.cfg = new Configuration(this.prop);
        ConfigurationTest.assertEquals((String)"bufferSize", (int)1024, (int)this.cfg.getBufferSize());
    }

    public void testBufferSize_32() throws LogException, Exception {
        this.prop.setProperty("bufferSize", "32");
        this.cfg = new Configuration(this.prop);
        ConfigurationTest.assertEquals((String)"bufferSize", (int)32768, (int)this.cfg.getBufferSize());
    }

    public void testBufferSize_0() throws LogException, Exception {
        this.prop.setProperty("bufferSize", "0");
        try {
            this.cfg = new Configuration(this.prop);
            ConfigurationTest.fail((String)"Expected LogConfigurationException");
        }
        catch (LogConfigurationException logConfigurationException) {
            // empty catch block
        }
    }

    public void testBufferSize_33() throws LogException, Exception {
        this.prop.setProperty("bufferSize", "33");
        try {
            this.cfg = new Configuration(this.prop);
            ConfigurationTest.fail((String)"Expected LogConfigurationException");
        }
        catch (LogConfigurationException logConfigurationException) {
            // empty catch block
        }
    }

    public void testChecksumEnabledError() {
        this.prop.setProperty("checksumEnabled", "yes");
        try {
            this.cfg = new Configuration(this.prop);
            ConfigurationTest.fail((String)"Expected LogConfigurationException");
        }
        catch (LogConfigurationException logConfigurationException) {
            // empty catch block
        }
    }

    public void testMinBuffers_GT_MaxBuffers() {
        this.prop.setProperty("maxBuffers", "1");
        this.prop.setProperty("minBuffers", "2");
        try {
            this.cfg = new Configuration(this.prop);
            ConfigurationTest.fail((String)"Expected LogConfigurationException");
        }
        catch (LogConfigurationException logConfigurationException) {
            // empty catch block
        }
    }

    public void testMinBuffers_LE_zero() {
        this.prop.setProperty("minBuffers", "-1");
        try {
            this.cfg = new Configuration(this.prop);
            ConfigurationTest.fail((String)"Expected LogConfigurationException");
        }
        catch (LogConfigurationException e) {
            // empty catch block
        }
        this.prop.setProperty("minBuffers", "0");
        try {
            this.cfg = new Configuration(this.prop);
            ConfigurationTest.fail((String)"Expected LogConfigurationException");
        }
        catch (LogConfigurationException logConfigurationException) {
            // empty catch block
        }
    }

    public void testMinBuffers_EQ_MaxBuffers() throws LogException, Exception {
        this.prop.setProperty("maxBuffers", "1");
        this.prop.setProperty("minBuffers", "1");
        this.cfg = new Configuration(this.prop);
    }

    public void testConstrucFromFile_FileNotFound() throws LogException, Exception {
        block2: {
            File file = new File("conf/filenotfound.properties");
            try {
                this.cfg = new Configuration(file);
                ConfigurationTest.fail((String)"Expected LogConfigurationException");
            }
            catch (LogConfigurationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof FileNotFoundException) break block2;
                throw e;
            }
        }
    }

    public void testConstructFromFile() throws LogException, Exception {
        this.cfg = new Configuration();
        this.prop.setProperty("maxLogFiles", Integer.toString(this.cfg.getMaxLogFiles() + 1));
        this.prop.setProperty("minBuffers", Integer.toString(this.cfg.getMinBuffers() + 1));
        File file = new File("conf/testConstructFromFile.properties");
        this.prop.store(new FileOutputStream(file), "testConstructFromFile test properties");
        Configuration cfg2 = new Configuration(file);
        ConfigurationTest.assertEquals((String)"maxLogFiles", (int)(this.cfg.getMaxLogFiles() + 1), (int)cfg2.getMaxLogFiles());
        this.cfg.setMaxLogFiles(cfg2.getMaxLogFiles());
        ConfigurationTest.assertEquals((String)"minBuffers", (int)(this.cfg.getMinBuffers() + 1), (int)cfg2.getMinBuffers());
        this.cfg.setMinBuffers(cfg2.getMinBuffers());
        this.verifyConfiguration(cfg2);
    }

    private void verifyConfiguration(Configuration cfg) {
        ConfigurationTest.assertEquals((String)"bufferClassName", (String)this.cfg.getBufferClassName(), (String)cfg.getBufferClassName());
        ConfigurationTest.assertEquals((String)"bufferSize", (int)this.cfg.getBufferSize(), (int)cfg.getBufferSize());
        ConfigurationTest.assertEquals((String)"checksumEnabled", (boolean)this.cfg.isChecksumEnabled(), (boolean)cfg.isChecksumEnabled());
        ConfigurationTest.assertEquals((String)"flushSleepTime", (int)this.cfg.getFlushSleepTime(), (int)cfg.getFlushSleepTime());
        ConfigurationTest.assertEquals((String)"logFileDir", (String)this.cfg.getLogFileDir(), (String)cfg.getLogFileDir());
        ConfigurationTest.assertEquals((String)"logFileExt", (String)this.cfg.getLogFileExt(), (String)cfg.getLogFileExt());
        ConfigurationTest.assertEquals((String)"logFileName", (String)this.cfg.getLogFileName(), (String)cfg.getLogFileName());
        ConfigurationTest.assertEquals((String)"maxBlocksPerFile", (int)this.cfg.getMaxBlocksPerFile(), (int)cfg.getMaxBlocksPerFile());
        ConfigurationTest.assertEquals((String)"minBuffers", (int)this.cfg.getMinBuffers(), (int)cfg.getMinBuffers());
        ConfigurationTest.assertEquals((String)"maxBuffers", (int)this.cfg.getMaxBuffers(), (int)cfg.getMaxBuffers());
        ConfigurationTest.assertEquals((String)"maxLogFiles", (int)this.cfg.getMaxLogFiles(), (int)cfg.getMaxLogFiles());
        ConfigurationTest.assertEquals((String)"threadsWaitingForceThreshold", (int)this.cfg.getThreadsWaitingForceThreshold(), (int)cfg.getThreadsWaitingForceThreshold());
    }

    public void testConstructFromProperties() throws LogException, Exception {
        this.cfg = new Configuration();
        this.prop.setProperty("bufferClassName", this.cfg.getBufferClassName());
        this.prop.setProperty("logFileDir", this.cfg.getLogFileDir());
        this.prop.setProperty("logFileExt", this.cfg.getLogFileExt());
        this.prop.setProperty("logFileName", this.cfg.getLogFileName());
        this.prop.setProperty("bufferSize", Integer.toString(this.cfg.getBufferSize() / 1024));
        this.prop.setProperty("flushSleepTime", Integer.toString(this.cfg.getFlushSleepTime()));
        this.prop.setProperty("maxLogFiles", Integer.toString(this.cfg.getMaxLogFiles()));
        this.prop.setProperty("maxBlocksPerFile", Integer.toString(this.cfg.getMaxBlocksPerFile()));
        this.prop.setProperty("maxBuffers", Integer.toString(this.cfg.getMaxBuffers()));
        this.prop.setProperty("minBuffers", Integer.toString(this.cfg.getMinBuffers()));
        this.prop.setProperty("checksumEnabled", Boolean.toString(this.cfg.isChecksumEnabled()));
        this.prop.setProperty("threadsWaitingForceThreshold", Integer.toString(this.cfg.getThreadsWaitingForceThreshold()));
        Configuration cfg2 = new Configuration(this.prop);
        this.verifyConfiguration(cfg2);
    }

    public void testSetMethods() throws LogException, Exception {
        this.cfg = new Configuration();
        Configuration cfg3 = new Configuration();
        cfg3.setBufferClassName(this.cfg.getBufferClassName());
        cfg3.setLogFileDir(this.cfg.getLogFileDir());
        cfg3.setLogFileExt(this.cfg.getLogFileExt());
        cfg3.setLogFileName(this.cfg.getLogFileName());
        cfg3.setBufferSize(this.cfg.getBufferSize() / 1024);
        cfg3.setMaxBlocksPerFile(this.cfg.getMaxBlocksPerFile());
        cfg3.setMaxLogFiles(this.cfg.getMaxLogFiles());
        cfg3.setMaxBuffers(this.cfg.getMaxBuffers());
        cfg3.setMinBuffers(this.cfg.getMinBuffers());
        cfg3.setChecksumEnabled(this.cfg.isChecksumEnabled());
        cfg3.setFlushSleepTime(this.cfg.getFlushSleepTime());
        cfg3.setThreadsWaitingForceThreshold(this.cfg.getThreadsWaitingForceThreshold());
        this.verifyConfiguration(cfg3);
    }
}

