/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log.xa;

import java.io.IOException;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.InvalidLogKeyException;
import org.objectweb.howl.log.LogClosedException;
import org.objectweb.howl.log.LogEventListener;
import org.objectweb.howl.log.LogFileOverflowException;
import org.objectweb.howl.log.LogRecordSizeException;
import org.objectweb.howl.log.Logger;
import org.objectweb.howl.log.xa.XACommittingTx;

public class XALogger
extends Logger
implements LogEventListener {
    XACommittingTx[] activeTx = null;
    XACommittingTx[] availableTx = null;
    int atxGet = 0;
    int atxPut = 0;
    int atxUsed = 0;
    int maxAtxUsed = 0;
    final Object activeTxLock = new Object();
    int growActiveTxArrayCount = 0;
    int overflowNotificationCount = 0;
    int movedRecordCount = 0;
    long totalWaitForThis = 0L;
    int waitForThisCount = 0;
    long overflowFence = 0L;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void growActiveTxArray() {
        XACommittingTx[] newActiveTx = new XACommittingTx[this.activeTx.length + 50];
        XACommittingTx[] newAvailableTx = new XACommittingTx[newActiveTx.length];
        for (int i = this.activeTx.length; i < newActiveTx.length; ++i) {
            newActiveTx[i] = null;
            newAvailableTx[i] = new XACommittingTx(i);
        }
        Object object = this.activeTxLock;
        synchronized (object) {
            for (int i = 0; i < this.activeTx.length; ++i) {
                newActiveTx[i] = this.activeTx[i];
                newAvailableTx[i] = this.availableTx[i];
            }
            this.atxPut = 0;
            this.atxGet = this.activeTx.length;
            this.activeTx = newActiveTx;
            this.availableTx = newAvailableTx;
        }
        ++this.growActiveTxArrayCount;
    }

    private void init() {
        int i;
        this.activeTx = new XACommittingTx[50];
        for (i = 0; i < this.activeTx.length; ++i) {
            this.activeTx[i] = null;
        }
        this.availableTx = new XACommittingTx[this.activeTx.length];
        for (i = 0; i < this.activeTx.length; ++i) {
            this.availableTx[i] = new XACommittingTx(i);
        }
        super.setLogEventListener(this);
    }

    public XALogger() throws IOException {
        super(new Configuration());
        this.init();
    }

    public XALogger(Configuration config) throws IOException {
        super(config);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XACommittingTx putCommit(byte[][] record) throws LogClosedException, LogRecordSizeException, LogFileOverflowException, InterruptedException, IOException {
        XACommittingTx tx = null;
        long key = 0L;
        long overflowFence = 0L;
        long beginWait = System.currentTimeMillis();
        Object object = this;
        synchronized (object) {
            if (this.overflowFence != 0L) {
                ++this.waitForThisCount;
            }
            while (this.overflowFence != 0L) {
                this.wait();
            }
            this.totalWaitForThis += System.currentTimeMillis() - beginWait;
        }
        do {
            key = this.put(record, true);
            object = this;
            synchronized (object) {
                overflowFence = this.overflowFence;
            }
        } while (key < overflowFence);
        object = this.activeTxLock;
        synchronized (object) {
            if (this.atxUsed == this.activeTx.length) {
                this.growActiveTxArray();
            }
            tx = this.availableTx[this.atxGet];
            if (!$assertionsDisabled && tx == null) {
                throw new AssertionError((Object)("availableTx[" + this.atxGet + "] is null"));
            }
            this.availableTx[this.atxGet] = null;
            this.atxGet = (this.atxGet + 1) % this.activeTx.length;
            tx.setLogKey(key);
            tx.setRecord(record);
            tx.setDone(false);
            tx.setMoving(false);
            int index = tx.getIndex();
            this.activeTx[index] = tx;
            ++this.atxUsed;
            this.maxAtxUsed = Math.max(this.atxUsed, this.maxAtxUsed);
        }
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long putDone(byte[][] record, XACommittingTx tx) throws LogClosedException, LogRecordSizeException, LogFileOverflowException, InterruptedException, IOException {
        Object object = this.activeTxLock;
        synchronized (object) {
            int index = tx.getIndex();
            if (this.activeTx[index] != tx) {
                throw new IllegalArgumentException();
            }
            this.activeTx[index] = null;
        }
        object = tx;
        synchronized (object) {
            tx.setDone(true);
            while (tx.isMoving()) {
                tx.wait();
            }
        }
        long doneKey = 0L;
        do {
            try {
                doneKey = this.put(record, false);
            }
            catch (LogFileOverflowException e) {
                Thread.sleep(10L);
            }
        } while (doneKey == 0L);
        Object object2 = this.activeTxLock;
        synchronized (object2) {
            this.availableTx[this.atxPut] = tx;
            this.atxPut = (this.atxPut + 1) % this.activeTx.length;
            --this.atxUsed;
            if (!$assertionsDisabled && this.atxUsed < 0) {
                throw new AssertionError((Object)("Negative atxUsed (" + this.atxUsed + ")"));
            }
        }
        return doneKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOverflowNotification(long overflowFence) {
        long newMark = Long.MAX_VALUE;
        XACommittingTx tx = null;
        long txKey = 0L;
        if (overflowFence == 0L) {
            throw new IllegalArgumentException("overflowFence == 0");
        }
        ++this.overflowNotificationCount;
        XALogger xALogger = this;
        synchronized (xALogger) {
            this.overflowFence = overflowFence;
        }
        for (int i = 0; i < this.activeTx.length; ++i) {
            Object object = this.activeTxLock;
            synchronized (object) {
                tx = this.activeTx[i];
                if (tx == null) {
                    continue;
                }
            }
            object = tx;
            synchronized (object) {
                if (tx.isDone()) {
                    continue;
                }
                txKey = tx.getLogKey();
                if (txKey > overflowFence) {
                    if (txKey < newMark) {
                        newMark = txKey;
                    }
                    continue;
                }
                tx.setMoving(true);
            }
            try {
                txKey = this.put(tx.getRecord(), false);
                ++this.movedRecordCount;
                object = tx;
                synchronized (object) {
                    tx.setLogKey(txKey);
                    tx.setMoving(false);
                    tx.notifyAll();
                    continue;
                }
            }
            catch (LogClosedException e1) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"unexpected LogClosedException");
                }
                continue;
            }
            catch (LogRecordSizeException e1) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"unexpected LogRecordSizeException");
                }
                continue;
            }
            catch (LogFileOverflowException e1) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"unexpected LogFileOverflowException");
                }
                continue;
            }
            catch (InterruptedException e1) {
                continue;
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        try {
            if (newMark == Long.MAX_VALUE) {
                newMark = overflowFence;
            }
            this.mark(newMark, true);
        }
        catch (InvalidLogKeyException e) {
            System.err.println(e.toString());
            Thread.yield();
        }
        catch (LogClosedException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Log closed during logOverflowNotification processing");
            }
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        XALogger xALogger2 = this;
        synchronized (xALogger2) {
            this.overflowFence = 0L;
            this.notifyAll();
        }
    }

    public String getStats() {
        String name = this.getClass().getName();
        StringBuffer stats = new StringBuffer("\n<XALogger  class='" + name + "'>");
        stats.append("\n<growActiveTxArrayCount value='" + this.growActiveTxArrayCount + "'>Number of times activeTx table was resized to accomodate " + "a larger number of transactions in COMMITTING state" + "</growActiveTxArrayCount>" + "\n<maxAtxUsed value='" + this.maxAtxUsed + "'>Maximum number of active TX entries used" + "</maxAtxUsed>" + "\n<movedRecordCount value='" + this.movedRecordCount + "'>Number of records moved during log overflow notification processing" + "</movedRecordCount>" + "\n<overflowNotificationCount value='" + this.overflowNotificationCount + "'>number of times log overflow notification event was called." + "</overflowNotificationCount>" + "\n<waitForThisCount value='" + this.waitForThisCount + "'>Number of times threads waited for overflow processing to complete" + "</waitForThisCount>" + "\n<totalWaitForThis value='" + this.totalWaitForThis + "'>Total time (ms) threads waited for overflow processing to complete" + "</totalWaitForThis>");
        stats.append(super.getStats());
        stats.append("\n</XALogger>\n");
        return stats.toString();
    }

    static {
        $assertionsDisabled = !XALogger.class.desiredAssertionStatus();
    }
}

