/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.IOException;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.InvalidFileSetException;
import org.objectweb.howl.log.InvalidLogBufferException;
import org.objectweb.howl.log.InvalidLogKeyException;
import org.objectweb.howl.log.LogBufferManager;
import org.objectweb.howl.log.LogClosedException;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogEventListener;
import org.objectweb.howl.log.LogFileManager;
import org.objectweb.howl.log.LogFileOverflowException;
import org.objectweb.howl.log.LogObject;
import org.objectweb.howl.log.LogRecordSizeException;
import org.objectweb.howl.log.ReplayListener;

public class Logger
extends LogObject {
    private volatile boolean isClosed = true;
    private LogBufferManager bmgr = null;
    private LogFileManager lfmgr = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Logger() throws IOException {
        this(new Configuration());
    }

    public Logger(Configuration config) throws IOException {
        super(config);
        this.lfmgr = new LogFileManager(config);
        this.bmgr = new LogBufferManager(config);
    }

    public long put(byte[][] data, boolean sync) throws LogClosedException, LogRecordSizeException, LogFileOverflowException, InterruptedException, IOException {
        if (this.isClosed) {
            throw new LogClosedException();
        }
        long key = this.bmgr.put((short)0, data, sync);
        this.lfmgr.setCurrentKey(key);
        return key;
    }

    public long put(byte[] data, boolean sync) throws LogClosedException, LogRecordSizeException, LogFileOverflowException, InterruptedException, IOException {
        return this.put(new byte[][]{data}, sync);
    }

    public void mark(long key, boolean force) throws InvalidLogKeyException, LogClosedException, IOException, InterruptedException {
        if (this.isClosed) {
            throw new LogClosedException("log is closed");
        }
        this.lfmgr.mark(key, force);
    }

    public void mark(long key) throws InvalidLogKeyException, LogClosedException, IOException, InterruptedException {
        this.mark(key, true);
    }

    public void setAutoMark(boolean autoMark) throws InvalidLogKeyException, LogClosedException, LogFileOverflowException, IOException, InterruptedException {
        this.lfmgr.setAutoMark(autoMark);
    }

    public void close() throws InvalidLogKeyException, LogClosedException, IOException, InterruptedException {
        this.isClosed = true;
        this.lfmgr.close();
    }

    public void open() throws InvalidFileSetException, ClassNotFoundException, IOException, LogConfigurationException, InvalidLogBufferException, InterruptedException {
        this.lfmgr.open();
        this.bmgr.open();
        this.lfmgr.init(this.bmgr);
        this.isClosed = false;
    }

    public void setLogEventListener(LogEventListener eventListener) {
        this.lfmgr.setLogEventListener(eventListener);
    }

    public void replay(ReplayListener listener, long mark) throws InvalidLogKeyException, LogConfigurationException {
        this.bmgr.replay(listener, mark, false);
    }

    public void replay(ReplayListener listener) throws LogConfigurationException {
        block2: {
            try {
                this.replay(listener, this.lfmgr.activeMark);
            }
            catch (InvalidLogKeyException e) {
                if ($assertionsDisabled || e == null) break block2;
                throw new AssertionError((Object)("Unhandled InvalidLogKeyException" + e.toString()));
            }
        }
    }

    public String getStats() {
        String name = this.getClass().getName();
        StringBuffer stats = new StringBuffer("<Logger  class='" + name + "'>");
        stats.append(this.bmgr.getStats());
        stats.append(this.lfmgr.getStats());
        stats.append("\n</Logger>\n");
        return stats.toString();
    }

    static {
        $assertionsDisabled = !Logger.class.desiredAssertionStatus();
    }
}

