/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.InvalidFileSetException;
import org.objectweb.howl.log.InvalidLogBufferException;
import org.objectweb.howl.log.InvalidLogKeyException;
import org.objectweb.howl.log.LogBuffer;
import org.objectweb.howl.log.LogBufferManager;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogEventListener;
import org.objectweb.howl.log.LogFile;
import org.objectweb.howl.log.LogFileOverflowException;
import org.objectweb.howl.log.LogObject;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.LogRecordSizeException;

class LogFileManager
extends LogObject {
    int maxBlocksPerFile = Integer.MAX_VALUE;
    long activeMark = 0L;
    boolean automark = false;
    boolean restartAutoMark = false;
    long currentKey = 0L;
    private long initialKey = 0L;
    final byte[] autoMarkOn = new byte[]{1};
    final byte[] autoMarkOff = new byte[]{0};
    private final Object fileManagerLock = new Object();
    LogFile[] fileSet = null;
    int lfIndex = 0;
    LogFile currentLogFile = null;
    byte[][] fileHeader = new byte[1][35];
    ByteBuffer fileHeaderBB = ByteBuffer.wrap(this.fileHeader[0]);
    byte[][] markRecord = new byte[1][19];
    ByteBuffer markRecordBB = ByteBuffer.wrap(this.markRecord[0]);
    byte[] crlf = "\r\n".getBytes();
    LogBufferManager bmgr;
    private LogEventListener eventListener = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$objectweb$howl$log$LogFileManager;

    LogFileManager(Configuration config) {
        super(config);
        this.maxBlocksPerFile = config.getMaxBlocksPerFile();
    }

    LogFile getLogFileForMark(long mark) {
        LogFile lf = null;
        int requestBsn = this.bmgr.bsnFromMark(mark);
        int fsl = this.fileSet.length;
        if (mark == 0L) {
            int minBsn = Integer.MAX_VALUE;
            int minIndex = fsl;
            int i = 0;
            while (i < fsl) {
                lf = this.fileSet[i];
                if (!lf.newFile && lf.firstBSN < minBsn) {
                    minBsn = lf.firstBSN;
                    minIndex = i;
                }
                ++i;
            }
            if (minIndex < fsl) {
                return this.fileSet[minIndex];
            }
            return null;
        }
        int i = 0;
        while (i < fsl) {
            lf = this.fileSet[i];
            if (!lf.newFile && requestBsn >= lf.firstBSN && mark < lf.highMark) {
                return lf;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogFile getLogFileForWrite(LogBuffer lb) throws LogFileOverflowException {
        block12: {
            try {
                Object object = this.fileManagerLock;
                synchronized (object) {
                    if (this.currentLogFile == null || (lb.bsn - 1) % this.maxBlocksPerFile == 0) {
                        int fsl = this.fileSet.length;
                        this.lfIndex %= fsl;
                        LogFile nextLogFile = this.fileSet[this.lfIndex];
                        if (!$assertionsDisabled && nextLogFile == null) {
                            throw new AssertionError((Object)"nextLogFile == null");
                        }
                        if (this.activeMark < nextLogFile.highMark) {
                            throw new LogFileOverflowException(this.activeMark, nextLogFile.highMark, nextLogFile.file);
                        }
                        ++this.lfIndex;
                        nextLogFile.tod = System.currentTimeMillis();
                        nextLogFile.firstBSN = lb.bsn;
                        long highMark = this.bmgr.markFromBsn(lb.bsn, 0);
                        long switchTod = nextLogFile.tod;
                        if (this.currentLogFile != null) {
                            switchTod = this.currentLogFile.tod;
                            this.currentLogFile.highMark = highMark;
                        }
                        lb.rewind = true;
                        short type = 18432;
                        this.fileHeaderBB.clear();
                        this.fileHeaderBB.put(this.automark ? this.autoMarkOn : this.autoMarkOff);
                        this.fileHeaderBB.putLong(this.activeMark);
                        this.fileHeaderBB.putLong(highMark);
                        this.fileHeaderBB.putLong(switchTod);
                        this.fileHeaderBB.putInt(this.fileSet.length);
                        this.fileHeaderBB.putInt(this.maxBlocksPerFile);
                        this.fileHeaderBB.put(this.crlf);
                        if (!$assertionsDisabled && this.fileHeader[0].length != this.fileHeaderBB.position()) {
                            throw new AssertionError((Object)"byte[] fileHeader size error");
                        }
                        lb.lf = nextLogFile;
                        lb.put(type, this.fileHeader, false);
                        this.currentLogFile = nextLogFile;
                    } else {
                        short type = 17408;
                        this.setMarkData(this.markRecordBB);
                        if (!$assertionsDisabled && this.markRecord[0].length != this.markRecordBB.position()) {
                            throw new AssertionError((Object)"byte[] markRecord size error");
                        }
                        lb.lf = this.currentLogFile;
                        lb.put(type, this.markRecord, false);
                    }
                }
            }
            catch (LogRecordSizeException e) {
                if ($assertionsDisabled || e == null) break block12;
                throw new AssertionError((Object)("Unhandled LogRecordSizeException" + e));
            }
        }
        return this.currentLogFile;
    }

    void setMarkData(ByteBuffer data) {
        data.clear();
        data.put(this.automark ? this.autoMarkOn : this.autoMarkOff);
        data.putLong(this.activeMark);
        data.putInt(this.fileSet.length);
        data.putInt(this.maxBlocksPerFile);
        data.put(this.crlf);
    }

    long mark(long key) throws InvalidLogKeyException, IOException, InterruptedException {
        if (key < this.activeMark || key > this.currentKey) {
            throw new InvalidLogKeyException(" key: " + Long.toHexString(key) + " activeMark: " + Long.toHexString(this.activeMark) + " currentKey: " + Long.toHexString(this.currentKey));
        }
        this.activeMark = key;
        byte[][] markData = new byte[1][this.markRecord[0].length];
        ByteBuffer markDataBuffer = ByteBuffer.wrap(markData[0]);
        short type = 17408;
        this.setMarkData(markDataBuffer);
        long markKey = 0L;
        try {
            markKey = this.bmgr.put(type, markData, false);
        }
        catch (LogRecordSizeException e) {
            if (!$assertionsDisabled && e != null) {
                throw new AssertionError((Object)("Unhandled LogRecordSizeException" + e));
            }
        }
        catch (LogFileOverflowException e) {
        }
        return markKey;
    }

    int read(LogBuffer lb, int bsn) throws IOException, InvalidLogBufferException {
        LogFile lf;
        long mark = this.bmgr.markFromBsn(bsn, 0);
        lb.lf = lf = this.getLogFileForMark(mark);
        if (lf == null) {
            lb.bsn = -1;
            return -1;
        }
        lf.position = 0L;
        if (bsn > 0) {
            int blocksToSkip = bsn - lf.firstBSN;
            lf.position = blocksToSkip * lb.buffer.capacity();
        }
        return lb.read((LogFile)lf, (long)lf.position).bsn;
    }

    long setAutoMark(boolean automark) throws InvalidLogKeyException, IOException, InterruptedException, LogFileOverflowException {
        this.automark = automark;
        return this.mark(automark ? this.currentKey : this.activeMark);
    }

    synchronized void setCurrentKey(long key) {
        if (key > this.currentKey) {
            this.currentKey = key;
        }
        if (this.automark) {
            this.activeMark = this.currentKey;
        }
    }

    void setLogEventListener(LogEventListener eventListener) {
        this.eventListener = eventListener;
    }

    void open() throws FileNotFoundException, InvalidFileSetException {
        int maxLogFiles = this.config.getMaxLogFiles();
        if (maxLogFiles < 2) {
            throw new InvalidFileSetException("Must configure two or more files");
        }
        String logDir = this.config.getLogFileDir();
        String logFileName = this.config.getLogFileName();
        String logFileExt = this.config.getLogFileExt();
        File dir = new File(logDir);
        dir.mkdirs();
        int existingFiles = 0;
        this.fileSet = new LogFile[maxLogFiles];
        int i = 0;
        while (i < maxLogFiles) {
            File name = new File(logDir + "/" + logFileName + "_" + (i + 1) + "." + logFileExt);
            try {
                this.fileSet[i] = new LogFile(name).open();
                if (!this.fileSet[i].newFile) {
                    if (existingFiles != i) {
                        throw new InvalidFileSetException();
                    }
                    ++existingFiles;
                }
            }
            catch (FileNotFoundException e) {
                System.err.println(e + ":" + name);
                throw e;
            }
            ++i;
        }
        this.currentLogFile = null;
    }

    void init(LogBufferManager bmgr) throws IOException, LogConfigurationException, InvalidLogBufferException, InterruptedException {
        this.bmgr = bmgr;
        int lfIndex = 0;
        int bsn = 0;
        LogFile lf = null;
        LogBuffer lb = null;
        try {
            lb = bmgr.getLogBuffer(-1);
        }
        catch (ClassNotFoundException e) {
            lb = null;
        }
        if (lb == null) {
            throw new LogConfigurationException("LogBuffer.class not found");
        }
        int i = 0;
        while (i < this.fileSet.length) {
            lf = this.fileSet[i];
            if (!$assertionsDisabled && lf == null) {
                throw new AssertionError((Object)"LogFile pointer lf is null");
            }
            if (!lf.newFile) {
                lb.read(lf, 0L);
                lf.firstBSN = lb.bsn;
                if (lb.bsn > bsn) {
                    bsn = lb.bsn;
                    lfIndex = i;
                }
            }
            i = (short)(i + 1);
        }
        int fsl = this.fileSet.length;
        int i2 = 0;
        while (i2 < fsl) {
            if (!this.fileSet[i2].newFile) {
                int next = (i2 + 1) % fsl;
                if (!this.fileSet[next].newFile) {
                    this.fileSet[i2].highMark = bmgr.markFromBsn(this.fileSet[next].firstBSN, 0);
                }
            }
            ++i2;
        }
        int blockSize = lb.buffer.capacity();
        lf = this.currentLogFile = this.fileSet[lfIndex];
        this.validateFileHeader(lb);
        long fpos = blockSize;
        if (lb.bsn > 0) {
            try {
                while (lb.read((LogFile)lf, (long)fpos).bsn > bsn) {
                    fpos += (long)blockSize;
                    bsn = lb.bsn;
                }
            }
            catch (InvalidLogBufferException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
        }
        this.lfIndex = lf.newFile ? 0 : lfIndex + 1;
        bmgr.init(this, bsn);
        this.currentKey = this.initialKey = bmgr.markFromBsn(bsn + 1, 0);
        if (this.automark) {
            this.activeMark = this.currentKey;
        }
        if (!$assertionsDisabled && fpos <= 0L) {
            throw new AssertionError((Object)("Unexpected file postion: " + fpos));
        }
        if (bsn > 0) {
            lb.read(lf, fpos - (long)blockSize);
            LogRecord record = new LogRecord(lb.buffer.capacity());
            ByteBuffer dataBuffer = record.dataBuffer;
            while (!record.get(lb).isEOB()) {
                if (record.type != 17408) continue;
                dataBuffer.clear();
                dataBuffer.getShort();
                this.automark = dataBuffer.get() == 1;
                this.activeMark = dataBuffer.getLong();
            }
            lf.highMark = bmgr.markFromBsn(bsn + 1, 0);
        } else {
            fpos = 0L;
        }
        lf.channel.position(fpos);
    }

    void validateFileHeader(LogBuffer lb) throws LogConfigurationException, IOException, InvalidLogBufferException {
        LogFile lf = this.currentLogFile;
        lb.read(lf, 0L);
        if (lb.bsn == -1) {
            return;
        }
        LogRecord fh = new LogRecord(this.fileHeader[0].length);
        if (!$assertionsDisabled && fh == null) {
            throw new AssertionError((Object)"LogRecord reference [fh] is null");
        }
        fh.get(lb);
        if (fh.type != 18432) {
            throw new InvalidLogBufferException("HEADER_TYPE: " + Integer.toHexString(fh.type));
        }
        if (fh.length != this.fileHeader[0].length + 2) {
            throw new InvalidLogBufferException("HEADER_SIZE: expected length(" + (this.fileHeader[0].length + 2) + ") found (" + fh.length + ")");
        }
        ByteBuffer dataBuffer = fh.dataBuffer;
        dataBuffer.clear();
        dataBuffer.getShort();
        this.automark = dataBuffer.get() == 1;
        this.activeMark = dataBuffer.getLong();
        long highMark = dataBuffer.getLong();
        long switchTod = dataBuffer.getLong();
        int nFiles = dataBuffer.getInt();
        if (nFiles != this.fileSet.length) {
            throw new LogConfigurationException("Current configuration number of files [" + this.fileSet.length + "] not equal number of files in set [" + nFiles + "]");
        }
        int nBlocks = dataBuffer.getInt();
        if (nBlocks != this.maxBlocksPerFile) {
            throw new LogConfigurationException("Configured file size [" + this.maxBlocksPerFile + "] blocks not equal previous file size [" + nBlocks + "] blocks");
        }
        short crlf = dataBuffer.getShort();
        if (crlf != 3338) {
            throw new InvalidLogBufferException("FILE_HEADER: expecting CRLF found " + Integer.toHexString(crlf));
        }
        if (!$assertionsDisabled && dataBuffer.capacity() != dataBuffer.position()) {
            throw new AssertionError((Object)"byte[] fileHeader size error");
        }
    }

    void close() throws IOException, InterruptedException {
        boolean interrupted = false;
        InterruptedException exception = null;
        this.bmgr.flushAll();
        byte[][] closeData = new byte[1][2];
        ByteBuffer closeDataBuffer = ByteBuffer.wrap(closeData[0]);
        closeDataBuffer.clear();
        closeDataBuffer.put(this.crlf);
        try {
            this.bmgr.put((short)16896, closeData, false);
        }
        catch (LogRecordSizeException e) {
            if (!$assertionsDisabled && e != null) {
                throw new AssertionError((Object)("Unhandled LogRecordSizeException" + e));
            }
        }
        catch (LogFileOverflowException e) {
        }
        catch (InterruptedException e) {
            interrupted = true;
            exception = e;
        }
        this.bmgr.flushAll();
        int i = 0;
        while (i < this.fileSet.length) {
            this.fileSet[i].close();
            ++i;
        }
        if (interrupted) {
            throw exception;
        }
    }

    String getStats() {
        String name = this.getClass().getName();
        StringBuffer stats = new StringBuffer("\n<LogFileManager  class='" + name + "'>");
        stats.append("\n<initialKey value='" + Long.toHexString(this.initialKey) + "'>" + "Initial Log Key" + "</initialKey>" + "\n<currentKey value='" + Long.toHexString(this.currentKey) + "'>" + "Current Log Key" + "</currentKey>" + "\n<restartAutoMark value='" + this.restartAutoMark + "'>" + "automark value restored from prior log file" + "</restartAutoMark>" + "");
        stats.append("\n<LogFiles>");
        int i = 0;
        while (i < this.fileSet.length) {
            stats.append(this.fileSet[i].getStats());
            ++i;
        }
        stats.append("\n</LogFiles>");
        stats.append("\n</LogFileManager>");
        return stats.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$org$objectweb$howl$log$LogFileManager == null ? (class$org$objectweb$howl$log$LogFileManager = LogFileManager.class$("org.objectweb.howl.log.LogFileManager")) : class$org$objectweb$howl$log$LogFileManager).desiredAssertionStatus();
    }
}

