/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.InvalidLogBufferException;
import org.objectweb.howl.log.LogFile;
import org.objectweb.howl.log.LogFileManager;
import org.objectweb.howl.log.LogFileOverflowException;
import org.objectweb.howl.log.LogObject;
import org.objectweb.howl.log.LogRecordSizeException;

abstract class LogBuffer
extends LogObject {
    final ByteBuffer buffer;
    int index = -1;
    long tod = 0L;
    protected int waitingThreads = 0;
    final Object waitingThreadsLock = new Object();
    int iostatus = 0;
    int bsn = 0;
    boolean rewind = false;
    IOException ioexception = null;
    String name = this.getClass().getName();
    LogFile lf = null;
    boolean doChecksum = true;
    int bytesUsed = 0;

    LogBuffer(Configuration config) {
        super(config);
        this.doChecksum = config.isChecksumEnabled();
        this.buffer = ByteBuffer.allocateDirect(config.getBufferSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int release() {
        Object object = this.waitingThreadsLock;
        synchronized (object) {
            return --this.waitingThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getWaitingThreads() {
        Object object = this.waitingThreadsLock;
        synchronized (object) {
            return this.waitingThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sync() throws IOException, InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        LogBuffer logBuffer = this;
        synchronized (logBuffer) {
            while (this.iostatus != 2) {
                if (this.iostatus == 3) {
                    throw new IOException();
                }
                this.wait();
            }
        }
    }

    String getName() {
        return "(" + this.name + ")";
    }

    abstract LogBuffer init(int var1, LogFileManager var2) throws LogFileOverflowException;

    abstract LogBuffer read(LogFile var1, long var2) throws IOException, InvalidLogBufferException;

    abstract boolean shouldForce();

    abstract long put(short var1, byte[][] var2, boolean var3) throws LogRecordSizeException;

    abstract void write() throws IOException;

    abstract String getStats();
}

